/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.xbill.DNS.APLRecord;
import org.xbill.DNS.DNSInput;
import org.xbill.DNS.DNSOutput;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.RelativeNameException;
import org.xbill.DNS.TextParseException;
import org.xbill.DNS.Tokenizer;
import org.xbill.DNS.WireParseException;

public class APLRecordTest {
    public static Test suite() {
        TestSuite s = new TestSuite();
        s.addTestSuite(Test_Element_init.class);
        s.addTestSuite(Test_init.class);
        s.addTestSuite(Test_rrFromWire.class);
        s.addTestSuite(Test_rdataFromString.class);
        s.addTestSuite(Test_rrToString.class);
        s.addTestSuite(Test_rrToWire.class);
        return s;
    }

    public static class Test_rrToWire
    extends TestCase {
        Name m_an;
        Name m_rn;
        long m_ttl;
        ArrayList m_elements;
        InetAddress m_addr4;
        String m_addr4_string;
        byte[] m_addr4_bytes;
        InetAddress m_addr6;
        String m_addr6_string;
        byte[] m_addr6_bytes;

        protected void setUp() throws TextParseException, UnknownHostException {
            this.m_an = Name.fromString("My.Absolute.Name.");
            this.m_rn = Name.fromString("My.Relative.Name");
            this.m_ttl = 79225L;
            this.m_addr4_string = "193.160.232.5";
            this.m_addr4 = InetAddress.getByName(this.m_addr4_string);
            this.m_addr4_bytes = this.m_addr4.getAddress();
            this.m_addr6_string = "2001:db8:85a3:8d3:1319:8a2e:370:7334";
            this.m_addr6 = InetAddress.getByName(this.m_addr6_string);
            this.m_addr6_bytes = this.m_addr6.getAddress();
            this.m_elements = new ArrayList(2);
            APLRecord.Element e = new APLRecord.Element(true, this.m_addr4, 12);
            this.m_elements.add(e);
            e = new APLRecord.Element(false, this.m_addr6, 64);
            this.m_elements.add(e);
        }

        public void test_empty() {
            APLRecord ar = new APLRecord(this.m_an, 1, this.m_ttl, new ArrayList());
            DNSOutput dout = new DNSOutput();
            ar.rrToWire(dout, null, true);
            Test_rrToWire.assertTrue(Arrays.equals(new byte[0], dout.toByteArray()));
        }

        public void test_basic() {
            APLRecord ar = new APLRecord(this.m_an, 1, this.m_ttl, this.m_elements);
            byte[] exp = new byte[]{0, 1, 12, -124, this.m_addr4_bytes[0], this.m_addr4_bytes[1], this.m_addr4_bytes[2], this.m_addr4_bytes[3], 0, 2, 64, 16, this.m_addr6_bytes[0], this.m_addr6_bytes[1], this.m_addr6_bytes[2], this.m_addr6_bytes[3], this.m_addr6_bytes[4], this.m_addr6_bytes[5], this.m_addr6_bytes[6], this.m_addr6_bytes[7], this.m_addr6_bytes[8], this.m_addr6_bytes[9], this.m_addr6_bytes[10], this.m_addr6_bytes[11], this.m_addr6_bytes[12], this.m_addr6_bytes[13], this.m_addr6_bytes[14], this.m_addr6_bytes[15]};
            DNSOutput dout = new DNSOutput();
            ar.rrToWire(dout, null, true);
            Test_rrToWire.assertTrue(Arrays.equals(exp, dout.toByteArray()));
        }

        public void test_non_IP() throws IOException {
            byte[] exp = new byte[]{0, 3, -126, -123, 1, 2, 3, 4, 5};
            DNSInput di = new DNSInput(exp);
            APLRecord ar = new APLRecord();
            ar.rrFromWire(di);
            DNSOutput dout = new DNSOutput();
            ar.rrToWire(dout, null, true);
            Test_rrToWire.assertTrue(Arrays.equals(exp, dout.toByteArray()));
        }

        public void test_address_with_embedded_zero() throws UnknownHostException {
            InetAddress a = InetAddress.getByName("232.0.11.1");
            ArrayList<APLRecord.Element> elements = new ArrayList<APLRecord.Element>();
            elements.add(new APLRecord.Element(true, a, 31));
            APLRecord ar = new APLRecord(this.m_an, 1, this.m_ttl, elements);
            byte[] exp = new byte[]{0, 1, 31, -124, -24, 0, 11, 1};
            DNSOutput dout = new DNSOutput();
            ar.rrToWire(dout, null, true);
            Test_rrToWire.assertTrue(Arrays.equals(exp, dout.toByteArray()));
        }

        public void test_short_address() throws UnknownHostException {
            InetAddress a = InetAddress.getByName("232.0.11.0");
            ArrayList<APLRecord.Element> elements = new ArrayList<APLRecord.Element>();
            elements.add(new APLRecord.Element(true, a, 31));
            APLRecord ar = new APLRecord(this.m_an, 1, this.m_ttl, elements);
            byte[] exp = new byte[]{0, 1, 31, -125, -24, 0, 11};
            DNSOutput dout = new DNSOutput();
            ar.rrToWire(dout, null, true);
            Test_rrToWire.assertTrue(Arrays.equals(exp, dout.toByteArray()));
        }

        public void test_wildcard_address() throws UnknownHostException {
            InetAddress a = InetAddress.getByName("0.0.0.0");
            ArrayList<APLRecord.Element> elements = new ArrayList<APLRecord.Element>();
            elements.add(new APLRecord.Element(true, a, 31));
            APLRecord ar = new APLRecord(this.m_an, 1, this.m_ttl, elements);
            byte[] exp = new byte[]{0, 1, 31, -128};
            DNSOutput dout = new DNSOutput();
            ar.rrToWire(dout, null, true);
            Test_rrToWire.assertTrue(Arrays.equals(exp, dout.toByteArray()));
        }
    }

    public static class Test_rrToString
    extends TestCase {
        Name m_an;
        Name m_rn;
        long m_ttl;
        ArrayList m_elements;
        InetAddress m_addr4;
        String m_addr4_string;
        byte[] m_addr4_bytes;
        InetAddress m_addr6;
        String m_addr6_string;
        byte[] m_addr6_bytes;

        protected void setUp() throws TextParseException, UnknownHostException {
            this.m_an = Name.fromString("My.Absolute.Name.");
            this.m_rn = Name.fromString("My.Relative.Name");
            this.m_ttl = 79225L;
            this.m_addr4_string = "193.160.232.5";
            this.m_addr4 = InetAddress.getByName(this.m_addr4_string);
            this.m_addr4_bytes = this.m_addr4.getAddress();
            this.m_addr6_string = "2001:db8:85a3:8d3:1319:8a2e:370:7334";
            this.m_addr6 = InetAddress.getByName(this.m_addr6_string);
            this.m_addr6_bytes = this.m_addr6.getAddress();
            this.m_elements = new ArrayList(2);
            APLRecord.Element e = new APLRecord.Element(true, this.m_addr4, 12);
            this.m_elements.add(e);
            e = new APLRecord.Element(false, this.m_addr6, 64);
            this.m_elements.add(e);
        }

        public void test() {
            APLRecord ar = new APLRecord(this.m_an, 1, this.m_ttl, this.m_elements);
            Test_rrToString.assertEquals("!1:" + this.m_addr4_string + "/12 2:" + this.m_addr6_string + "/64", ar.rrToString());
        }
    }

    public static class Test_rdataFromString
    extends TestCase {
        InetAddress m_addr4;
        String m_addr4_string;
        byte[] m_addr4_bytes;
        InetAddress m_addr6;
        String m_addr6_string;
        byte[] m_addr6_bytes;

        protected void setUp() throws TextParseException, UnknownHostException {
            this.m_addr4_string = "193.160.232.5";
            this.m_addr4 = InetAddress.getByName(this.m_addr4_string);
            this.m_addr4_bytes = this.m_addr4.getAddress();
            this.m_addr6_string = "2001:db8:85a3:8d3:1319:8a2e:370:7334";
            this.m_addr6 = InetAddress.getByName(this.m_addr6_string);
            this.m_addr6_bytes = this.m_addr6.getAddress();
        }

        public void test_validIPv4() throws IOException {
            Tokenizer t = new Tokenizer("1:" + this.m_addr4_string + "/11\n");
            APLRecord ar = new APLRecord();
            ar.rdataFromString(t, null);
            ArrayList<APLRecord.Element> exp = new ArrayList<APLRecord.Element>();
            exp.add(new APLRecord.Element(false, this.m_addr4, 11));
            Test_rdataFromString.assertEquals(exp, ar.getElements());
            Test_rdataFromString.assertEquals(1, t.get().type);
        }

        public void test_valid_multi() throws IOException {
            Tokenizer t = new Tokenizer("1:" + this.m_addr4_string + "/11 !2:" + this.m_addr6_string + "/100");
            APLRecord ar = new APLRecord();
            ar.rdataFromString(t, null);
            ArrayList<APLRecord.Element> exp = new ArrayList<APLRecord.Element>();
            exp.add(new APLRecord.Element(false, this.m_addr4, 11));
            exp.add(new APLRecord.Element(true, this.m_addr6, 100));
            Test_rdataFromString.assertEquals(exp, ar.getElements());
        }

        public void test_validIPv6() throws IOException {
            Tokenizer t = new Tokenizer("!2:" + this.m_addr6_string + "/36\n");
            APLRecord ar = new APLRecord();
            ar.rdataFromString(t, null);
            ArrayList<APLRecord.Element> exp = new ArrayList<APLRecord.Element>();
            exp.add(new APLRecord.Element(true, this.m_addr6, 36));
            Test_rdataFromString.assertEquals(exp, ar.getElements());
            Test_rdataFromString.assertEquals(1, t.get().type);
        }

        public void test_no_colon() throws IOException {
            Tokenizer t = new Tokenizer("!1192.68.0.1/20");
            APLRecord ar = new APLRecord();
            try {
                ar.rdataFromString(t, null);
                Test_rdataFromString.fail("TextParseException not thrown");
            }
            catch (TextParseException textParseException) {
                // empty catch block
            }
        }

        public void test_colon_and_slash_swapped() throws IOException {
            Tokenizer t = new Tokenizer("!1/192.68.0.1:20");
            APLRecord ar = new APLRecord();
            try {
                ar.rdataFromString(t, null);
                Test_rdataFromString.fail("TextParseException not thrown");
            }
            catch (TextParseException textParseException) {
                // empty catch block
            }
        }

        public void test_no_slash() throws IOException {
            Tokenizer t = new Tokenizer("!1:192.68.0.1|20");
            APLRecord ar = new APLRecord();
            try {
                ar.rdataFromString(t, null);
                Test_rdataFromString.fail("TextParseException not thrown");
            }
            catch (TextParseException textParseException) {
                // empty catch block
            }
        }

        public void test_empty_family() throws IOException {
            Tokenizer t = new Tokenizer("!:192.68.0.1/20");
            APLRecord ar = new APLRecord();
            try {
                ar.rdataFromString(t, null);
                Test_rdataFromString.fail("TextParseException not thrown");
            }
            catch (TextParseException textParseException) {
                // empty catch block
            }
        }

        public void test_malformed_family() throws IOException {
            Tokenizer t = new Tokenizer("family:192.68.0.1/20");
            APLRecord ar = new APLRecord();
            try {
                ar.rdataFromString(t, null);
                Test_rdataFromString.fail("TextParseException not thrown");
            }
            catch (TextParseException textParseException) {
                // empty catch block
            }
        }

        public void test_invalid_family() throws IOException {
            Tokenizer t = new Tokenizer("3:192.68.0.1/20");
            APLRecord ar = new APLRecord();
            try {
                ar.rdataFromString(t, null);
                Test_rdataFromString.fail("TextParseException not thrown");
            }
            catch (TextParseException textParseException) {
                // empty catch block
            }
        }

        public void test_empty_prefix() throws IOException {
            Tokenizer t = new Tokenizer("1:192.68.0.1/");
            APLRecord ar = new APLRecord();
            try {
                ar.rdataFromString(t, null);
                Test_rdataFromString.fail("TextParseException not thrown");
            }
            catch (TextParseException textParseException) {
                // empty catch block
            }
        }

        public void test_malformed_prefix() throws IOException {
            Tokenizer t = new Tokenizer("1:192.68.0.1/prefix");
            APLRecord ar = new APLRecord();
            try {
                ar.rdataFromString(t, null);
                Test_rdataFromString.fail("TextParseException not thrown");
            }
            catch (TextParseException textParseException) {
                // empty catch block
            }
        }

        public void test_invalid_prefix() throws IOException {
            Tokenizer t = new Tokenizer("1:192.68.0.1/33");
            APLRecord ar = new APLRecord();
            try {
                ar.rdataFromString(t, null);
                Test_rdataFromString.fail("TextParseException not thrown");
            }
            catch (TextParseException textParseException) {
                // empty catch block
            }
        }

        public void test_empty_address() throws IOException {
            Tokenizer t = new Tokenizer("1:/33");
            APLRecord ar = new APLRecord();
            try {
                ar.rdataFromString(t, null);
                Test_rdataFromString.fail("TextParseException not thrown");
            }
            catch (TextParseException textParseException) {
                // empty catch block
            }
        }

        public void test_malformed_address() throws IOException {
            Tokenizer t = new Tokenizer("1:A.B.C.D/33");
            APLRecord ar = new APLRecord();
            try {
                ar.rdataFromString(t, null);
                Test_rdataFromString.fail("TextParseException not thrown");
            }
            catch (TextParseException textParseException) {
                // empty catch block
            }
        }
    }

    public static class Test_rrFromWire
    extends TestCase {
        InetAddress m_addr4;
        byte[] m_addr4_bytes;
        InetAddress m_addr6;
        byte[] m_addr6_bytes;

        protected void setUp() throws TextParseException, UnknownHostException {
            this.m_addr4 = InetAddress.getByName("193.160.232.5");
            this.m_addr4_bytes = this.m_addr4.getAddress();
            this.m_addr6 = InetAddress.getByName("2001:db8:85a3:8d3:1319:8a2e:370:7334");
            this.m_addr6_bytes = this.m_addr6.getAddress();
        }

        public void test_validIPv4() throws IOException {
            byte[] raw = new byte[]{0, 1, 8, -124, this.m_addr4_bytes[0], this.m_addr4_bytes[1], this.m_addr4_bytes[2], this.m_addr4_bytes[3]};
            DNSInput di = new DNSInput(raw);
            APLRecord ar = new APLRecord();
            ar.rrFromWire(di);
            ArrayList<APLRecord.Element> exp = new ArrayList<APLRecord.Element>();
            exp.add(new APLRecord.Element(true, this.m_addr4, 8));
            Test_rrFromWire.assertEquals(exp, ar.getElements());
        }

        public void test_validIPv4_short_address() throws IOException {
            byte[] raw = new byte[]{0, 1, 20, -125, this.m_addr4_bytes[0], this.m_addr4_bytes[1], this.m_addr4_bytes[2]};
            DNSInput di = new DNSInput(raw);
            APLRecord ar = new APLRecord();
            ar.rrFromWire(di);
            InetAddress a = InetAddress.getByName("193.160.232.0");
            ArrayList<APLRecord.Element> exp = new ArrayList<APLRecord.Element>();
            exp.add(new APLRecord.Element(true, a, 20));
            Test_rrFromWire.assertEquals(exp, ar.getElements());
        }

        public void test_invalid_IPv4_prefix() throws IOException {
            byte[] raw = new byte[]{0, 1, 33, -124, this.m_addr4_bytes[0], this.m_addr4_bytes[1], this.m_addr4_bytes[2], this.m_addr4_bytes[3]};
            DNSInput di = new DNSInput(raw);
            APLRecord ar = new APLRecord();
            try {
                ar.rrFromWire(di);
                Test_rrFromWire.fail("WireParseException not thrown");
            }
            catch (WireParseException e) {
                // empty catch block
            }
        }

        public void test_invalid_IPv4_length() throws IOException {
            byte[] raw = new byte[]{0, 1, 8, -123, this.m_addr4_bytes[0], this.m_addr4_bytes[1], this.m_addr4_bytes[2], this.m_addr4_bytes[3], 10};
            DNSInput di = new DNSInput(raw);
            APLRecord ar = new APLRecord();
            try {
                ar.rrFromWire(di);
                Test_rrFromWire.fail("WireParseException not thrown");
            }
            catch (WireParseException e) {
                // empty catch block
            }
        }

        public void test_multiple_validIPv4() throws IOException {
            byte[] raw = new byte[]{0, 1, 8, -124, this.m_addr4_bytes[0], this.m_addr4_bytes[1], this.m_addr4_bytes[2], this.m_addr4_bytes[3], 0, 1, 30, 4, this.m_addr4_bytes[0], this.m_addr4_bytes[1], this.m_addr4_bytes[2], this.m_addr4_bytes[3]};
            DNSInput di = new DNSInput(raw);
            APLRecord ar = new APLRecord();
            ar.rrFromWire(di);
            ArrayList<APLRecord.Element> exp = new ArrayList<APLRecord.Element>();
            exp.add(new APLRecord.Element(true, this.m_addr4, 8));
            exp.add(new APLRecord.Element(false, this.m_addr4, 30));
            Test_rrFromWire.assertEquals(exp, ar.getElements());
        }

        public void test_validIPv6() throws IOException {
            byte[] raw = new byte[]{0, 2, 115, 16, this.m_addr6_bytes[0], this.m_addr6_bytes[1], this.m_addr6_bytes[2], this.m_addr6_bytes[3], this.m_addr6_bytes[4], this.m_addr6_bytes[5], this.m_addr6_bytes[6], this.m_addr6_bytes[7], this.m_addr6_bytes[8], this.m_addr6_bytes[9], this.m_addr6_bytes[10], this.m_addr6_bytes[11], this.m_addr6_bytes[12], this.m_addr6_bytes[13], this.m_addr6_bytes[14], this.m_addr6_bytes[15]};
            DNSInput di = new DNSInput(raw);
            APLRecord ar = new APLRecord();
            ar.rrFromWire(di);
            ArrayList<APLRecord.Element> exp = new ArrayList<APLRecord.Element>();
            exp.add(new APLRecord.Element(false, this.m_addr6, 115));
            Test_rrFromWire.assertEquals(exp, ar.getElements());
        }

        public void test_valid_nonIP() throws IOException {
            byte[] raw = new byte[]{0, 3, -126, -123, 1, 2, 3, 4, 5};
            DNSInput di = new DNSInput(raw);
            APLRecord ar = new APLRecord();
            ar.rrFromWire(di);
            List l = ar.getElements();
            Test_rrFromWire.assertEquals(1, l.size());
            APLRecord.Element el = (APLRecord.Element)l.get(0);
            Test_rrFromWire.assertEquals(3, el.family);
            Test_rrFromWire.assertEquals(true, el.negative);
            Test_rrFromWire.assertEquals(130, el.prefixLength);
            Test_rrFromWire.assertTrue(Arrays.equals(new byte[]{1, 2, 3, 4, 5}, (byte[])el.address));
        }
    }

    public static class Test_init
    extends TestCase {
        Name m_an;
        Name m_rn;
        long m_ttl;
        ArrayList m_elements;
        InetAddress m_addr4;
        String m_addr4_string;
        byte[] m_addr4_bytes;
        InetAddress m_addr6;
        String m_addr6_string;
        byte[] m_addr6_bytes;

        protected void setUp() throws TextParseException, UnknownHostException {
            this.m_an = Name.fromString("My.Absolute.Name.");
            this.m_rn = Name.fromString("My.Relative.Name");
            this.m_ttl = 79225L;
            this.m_addr4_string = "193.160.232.5";
            this.m_addr4 = InetAddress.getByName(this.m_addr4_string);
            this.m_addr4_bytes = this.m_addr4.getAddress();
            this.m_addr6_string = "2001:db8:85a3:8d3:1319:8a2e:370:7334";
            this.m_addr6 = InetAddress.getByName(this.m_addr6_string);
            this.m_addr6_bytes = this.m_addr6.getAddress();
            this.m_elements = new ArrayList(2);
            APLRecord.Element e = new APLRecord.Element(true, this.m_addr4, 12);
            this.m_elements.add(e);
            e = new APLRecord.Element(false, this.m_addr6, 64);
            this.m_elements.add(e);
        }

        public void test_0arg() throws UnknownHostException {
            APLRecord ar = new APLRecord();
            Test_init.assertNull(ar.getName());
            Test_init.assertEquals(0, ar.getType());
            Test_init.assertEquals(0, ar.getDClass());
            Test_init.assertEquals(0L, ar.getTTL());
            Test_init.assertNull(ar.getElements());
        }

        public void test_getObject() {
            APLRecord ar = new APLRecord();
            Record r = ar.getObject();
            Test_init.assertTrue(r instanceof APLRecord);
        }

        public void test_4arg_basic() {
            APLRecord ar = new APLRecord(this.m_an, 1, this.m_ttl, this.m_elements);
            Test_init.assertEquals(this.m_an, ar.getName());
            Test_init.assertEquals(42, ar.getType());
            Test_init.assertEquals(1, ar.getDClass());
            Test_init.assertEquals(this.m_ttl, ar.getTTL());
            Test_init.assertEquals(this.m_elements, ar.getElements());
        }

        public void test_4arg_empty_elements() {
            APLRecord ar = new APLRecord(this.m_an, 1, this.m_ttl, new ArrayList());
            Test_init.assertEquals(new ArrayList(), ar.getElements());
        }

        public void test_4arg_relative_name() {
            try {
                new APLRecord(this.m_rn, 1, this.m_ttl, this.m_elements);
                Test_init.fail("RelativeNameException not thrown");
            }
            catch (RelativeNameException relativeNameException) {
                // empty catch block
            }
        }

        public void test_4arg_invalid_elements() {
            this.m_elements = new ArrayList();
            this.m_elements.add(new Object());
            try {
                new APLRecord(this.m_an, 1, this.m_ttl, this.m_elements);
                Test_init.fail("IllegalArgumentException not thrown");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    public static class Test_Element_init
    extends TestCase {
        InetAddress m_addr4;
        InetAddress m_addr6;

        protected void setUp() throws TextParseException, UnknownHostException {
            this.m_addr4 = InetAddress.getByName("193.160.232.5");
            this.m_addr6 = InetAddress.getByName("2001:db8:85a3:8d3:1319:8a2e:370:7334");
        }

        public void test_valid_IPv4() {
            APLRecord.Element el = new APLRecord.Element(true, this.m_addr4, 16);
            Test_Element_init.assertEquals(1, el.family);
            Test_Element_init.assertEquals(true, el.negative);
            Test_Element_init.assertEquals(this.m_addr4, el.address);
            Test_Element_init.assertEquals(16, el.prefixLength);
        }

        public void test_invalid_IPv4() {
            try {
                new APLRecord.Element(true, this.m_addr4, 33);
                Test_Element_init.fail("IllegalArgumentException not thrown");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        public void test_valid_IPv6() {
            APLRecord.Element el = new APLRecord.Element(false, this.m_addr6, 74);
            Test_Element_init.assertEquals(2, el.family);
            Test_Element_init.assertEquals(false, el.negative);
            Test_Element_init.assertEquals(this.m_addr6, el.address);
            Test_Element_init.assertEquals(74, el.prefixLength);
        }

        public void test_invalid_IPv6() {
            try {
                new APLRecord.Element(true, this.m_addr6, 129);
                Test_Element_init.fail("IllegalArgumentException not thrown");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }
}

