/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.mo.snmp;

import java.util.GregorianCalendar;
import org.snmp4j.agent.MOAccess;
import org.snmp4j.agent.mo.MOScalar;
import org.snmp4j.agent.mo.snmp.DateAndTime;
import org.snmp4j.agent.request.SubRequest;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.Variable;

public class DateAndTimeScalar
extends MOScalar {
    private boolean localtime;

    public DateAndTimeScalar(OID oid, MOAccess access, OctetString value) {
        this(oid, access, value, false);
    }

    public DateAndTimeScalar(OID oid, MOAccess access, OctetString value, boolean localtime) {
        super(oid, access, value);
        this.localtime = localtime;
    }

    public int isValueOK(SubRequest sreq) {
        return DateAndTime.validateDateAndTime(sreq.getVariableBinding().getVariable());
    }

    public Variable getValue() {
        Variable value = super.getValue();
        if (this.localtime) {
            value = DateAndTime.makeDateAndTime(new GregorianCalendar());
        }
        return value;
    }

    public void setCalendar(GregorianCalendar calendar) {
        this.setValue(DateAndTime.makeDateAndTime(calendar));
    }

    public GregorianCalendar getCalendar() {
        return DateAndTime.makeCalendar((OctetString)this.getValue());
    }
}

