/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.snmp;

import java.net.InetAddress;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.opennms.core.utils.InetAddressUtils;
import org.springframework.util.Assert;

public final class SnmpAgentAddress {
    private final InetAddress m_address;
    private final Integer m_port;
    private int m_hashCode = 0;

    public SnmpAgentAddress(InetAddress agentAddress, Integer agentPort) {
        Assert.notNull(agentPort);
        this.m_address = agentAddress;
        this.m_port = agentPort;
        this.m_hashCode = new HashCodeBuilder(7, 15).append(this.m_address).append(this.m_port).toHashCode();
    }

    public InetAddress getAddress() {
        return this.m_address;
    }

    public Integer getPort() {
        return this.m_port;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SnmpAgentAddress)) {
            return false;
        }
        SnmpAgentAddress that = (SnmpAgentAddress)obj;
        return new EqualsBuilder().append(this.getAddress(), that.getAddress()).append(this.getPort(), that.getPort()).isEquals();
    }

    public int hashCode() {
        return this.m_hashCode;
    }

    public String toString() {
        return InetAddressUtils.str(this.m_address) + ":" + this.m_port;
    }
}

