/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class PropertiesCache {
    public static final String CHECK_LAST_MODIFY_STRING = "org.opennms.utils.propertiesCache.enableCheckFileModified";
    Map<String, PropertiesHolder> m_cache = new TreeMap<String, PropertiesHolder>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PropertiesHolder getHolder(File propFile) throws IOException {
        String key = propFile.getCanonicalPath();
        Map<String, PropertiesHolder> map = this.m_cache;
        synchronized (map) {
            PropertiesHolder holder = this.m_cache.get(key);
            if (holder == null) {
                holder = new PropertiesHolder(propFile);
                this.m_cache.put(key, holder);
            }
            return holder;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Map<String, PropertiesHolder> map = this.m_cache;
        synchronized (map) {
            this.m_cache.clear();
        }
    }

    public Properties getProperties(File propFile) throws IOException {
        return this.getHolder(propFile).get();
    }

    public Properties findProperties(File propFile) throws IOException {
        return this.getHolder(propFile).find();
    }

    public void saveProperties(File propFile, Properties properties) throws IOException {
        this.getHolder(propFile).put(properties);
    }

    public void updateProperties(File propFile, Map<String, String> props) throws IOException {
        this.getHolder(propFile).update(props);
    }

    public void setProperty(File propFile, String key, String value) throws IOException {
        this.getHolder(propFile).setProperty(key, value);
    }

    public String getProperty(File propFile, String key) throws IOException {
        return this.getHolder(propFile).getProperty(key);
    }

    private static class PropertiesHolder {
        private Properties m_properties;
        private final File m_file;
        private final Lock lock = new ReentrantLock();
        private long m_lastModify = 0L;
        private boolean m_checkLastModify = Boolean.getBoolean("org.opennms.utils.propertiesCache.enableCheckFileModified");

        PropertiesHolder(File file) {
            this.m_file = file;
            this.m_properties = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Properties read() throws IOException {
            if (!this.m_file.canRead()) {
                return null;
            }
            FileInputStream in = null;
            try {
                in = new FileInputStream(this.m_file);
                Properties prop = new Properties();
                prop.load(in);
                if (this.m_checkLastModify) {
                    this.m_lastModify = this.m_file.lastModified();
                }
                Properties properties = prop;
                return properties;
            }
            finally {
                if (in != null) {
                    try {
                        ((InputStream)in).close();
                    }
                    catch (IOException e) {}
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void write() throws IOException {
            this.m_file.getParentFile().mkdirs();
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(this.m_file);
                this.m_properties.store(out, null);
            }
            finally {
                if (out != null) {
                    try {
                        ((OutputStream)out).close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Properties get() throws IOException {
            this.lock.lock();
            try {
                if (this.m_properties == null) {
                    this.readWithDefault(new Properties());
                } else if (this.m_checkLastModify && this.m_file.canRead() && this.m_lastModify != this.m_file.lastModified()) {
                    this.m_properties = this.read();
                }
                Properties properties = this.m_properties;
                return properties;
            }
            finally {
                this.lock.unlock();
            }
        }

        private void readWithDefault(Properties deflt) throws IOException {
            if (deflt == null && !this.m_file.canRead()) {
                return;
            }
            if (this.m_properties == null) {
                this.m_properties = this.read();
                if (this.m_properties == null) {
                    this.m_properties = deflt;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void put(Properties properties) throws IOException {
            this.lock.lock();
            try {
                this.m_properties = properties;
                this.write();
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void update(Map<String, String> props) throws IOException {
            this.lock.lock();
            try {
                boolean save = false;
                for (Map.Entry<String, String> e : props.entrySet()) {
                    if (e.getValue().equals(this.get().get(e.getKey()))) continue;
                    this.get().put(e.getKey(), e.getValue());
                    save = true;
                }
                if (save) {
                    this.write();
                }
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setProperty(String key, String value) throws IOException {
            this.lock.lock();
            try {
                this.get();
                if (!value.equals(this.get().get(key))) {
                    this.get().put(key, value);
                    this.write();
                }
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Properties find() throws IOException {
            this.lock.lock();
            try {
                if (this.m_properties == null) {
                    this.readWithDefault(null);
                }
                Properties properties = this.m_properties;
                return properties;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getProperty(String key) throws IOException {
            this.lock.lock();
            try {
                String string = this.get().getProperty(key);
                return string;
            }
            finally {
                this.lock.unlock();
            }
        }
    }
}

