/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.concurrent;

import java.util.ArrayList;
import java.util.List;
import org.opennms.core.fiber.Fiber;
import org.opennms.core.queue.ClosableFifoQueue;
import org.opennms.core.queue.FifoQueue;
import org.opennms.core.queue.FifoQueueClosedException;
import org.opennms.core.queue.FifoQueueException;
import org.opennms.core.queue.FifoQueueImpl;
import org.opennms.core.utils.ThreadCategory;
import org.springframework.util.Assert;

public class RunnableConsumerThreadPool
implements Fiber {
    private SizingFifoQueue<Runnable> m_delegateQ;
    private Fiber[] m_fibers;
    private String m_poolName;
    private float m_hiRatio;
    private float m_loRatio;
    private int m_maxSize;
    private String m_log4jPrefix;
    private int m_poolStatus;
    private List<RunnableCompletionListener> m_completedListeners;
    private ThreadGroup m_tGroup;
    private List<RunnableErrorListener> m_errorListeners;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int livingFiberCount() {
        int alive = 0;
        Fiber[] fiberArray = this.m_fibers;
        synchronized (this.m_fibers) {
            for (int i = 0; i < this.m_fibers.length; ++i) {
                if (this.m_fibers[i] == null) continue;
                if (this.m_fibers[i].getStatus() != 4) {
                    ++alive;
                    continue;
                }
                this.m_fibers[i] = null;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return alive;
        }
    }

    public RunnableConsumerThreadPool(String name, float loMark, float hiMark, int max) {
        Assert.state(loMark <= hiMark, "The lo-mark must be less than the hi-mark");
        Assert.state(max > 0, "The maximum number of fibers must be greater than zero");
        this.m_delegateQ = new SizingFifoQueue();
        this.m_fibers = new Fiber[max];
        this.m_poolName = name;
        this.m_hiRatio = hiMark;
        this.m_loRatio = loMark;
        this.m_maxSize = max;
        this.m_tGroup = new ThreadGroup(name + "-tgroup");
        this.m_poolStatus = 0;
        this.m_completedListeners = new ArrayList<RunnableCompletionListener>();
        this.m_errorListeners = new ArrayList<RunnableErrorListener>();
        this.m_log4jPrefix = ThreadCategory.getPrefix();
    }

    public FifoQueue<Runnable> getRunQueue() {
        return this.m_delegateQ;
    }

    @Override
    public void start() {
        try {
            this.m_delegateQ.open();
        }
        catch (FifoQueueException e) {
            throw new RuntimeException(e.getMessage());
        }
        this.m_poolStatus = 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        Fiber[] fiberArray = this.m_fibers;
        synchronized (this.m_fibers) {
            for (Fiber fiber : this.m_fibers) {
                if (fiber == null) continue;
                fiber.stop();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            this.m_poolStatus = 3;
            try {
                this.m_delegateQ.close();
            }
            catch (FifoQueueException e) {
                throw new RuntimeException(e.getMessage());
            }
            return;
        }
    }

    @Override
    public int getStatus() {
        if (this.m_poolStatus == 3 && this.livingFiberCount() == 0) {
            this.m_poolStatus = 4;
        }
        return this.m_poolStatus;
    }

    @Override
    public String getName() {
        return this.m_poolName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCompletionListener(RunnableCompletionListener listener) {
        List<RunnableCompletionListener> list = this.m_completedListeners;
        synchronized (list) {
            this.m_completedListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCompletionListener(RunnableCompletionListener listener) {
        List<RunnableCompletionListener> list = this.m_completedListeners;
        synchronized (list) {
            this.m_completedListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addErrorListener(RunnableErrorListener listener) {
        List<RunnableErrorListener> list = this.m_errorListeners;
        synchronized (list) {
            this.m_errorListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeErrorListener(RunnableErrorListener listener) {
        List<RunnableErrorListener> list = this.m_errorListeners;
        synchronized (list) {
            this.m_errorListeners.remove(listener);
        }
    }

    public static interface RunnableErrorListener {
        public void onRunnableError(Runnable var1, Throwable var2);
    }

    public static interface RunnableCompletionListener {
        public void onRunnableCompletion(Runnable var1);
    }

    private class FiberThreadImpl
    implements Fiber,
    Runnable {
        private Thread m_delegateThread;
        private volatile boolean m_shutdown = false;
        private volatile int m_status = 0;

        FiberThreadImpl(String name) {
            this.m_delegateThread = new Thread(RunnableConsumerThreadPool.this.m_tGroup, this, name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ThreadCategory.setPrefix(RunnableConsumerThreadPool.this.m_log4jPrefix);
            this.m_status = 2;
            while (!this.m_shutdown) {
                Runnable runnable = null;
                try {
                    runnable = (Runnable)RunnableConsumerThreadPool.this.m_delegateQ.remove(500L);
                    if (runnable == null) {
                        continue;
                    }
                }
                catch (InterruptedException e) {
                    this.m_status = 3;
                    break;
                }
                catch (FifoQueueException e) {
                    this.m_status = 3;
                    break;
                }
                try {
                    if (runnable == null) continue;
                    runnable.run();
                    RunnableCompletionListener[] list = null;
                    List list2 = RunnableConsumerThreadPool.this.m_completedListeners;
                    synchronized (list2) {
                        list = RunnableConsumerThreadPool.this.m_completedListeners.toArray(new RunnableCompletionListener[RunnableConsumerThreadPool.this.m_completedListeners.size()]);
                    }
                    for (RunnableCompletionListener listener : list) {
                        listener.onRunnableCompletion(runnable);
                    }
                }
                catch (Throwable t) {
                    this.log().debug("run: an unexpected error occured during fiber run, calling error liseners");
                    RunnableErrorListener[] list = null;
                    List len$ = RunnableConsumerThreadPool.this.m_errorListeners;
                    synchronized (len$) {
                        list = RunnableConsumerThreadPool.this.m_errorListeners.toArray(new RunnableErrorListener[RunnableConsumerThreadPool.this.m_errorListeners.size()]);
                    }
                    if (list.length == 0) {
                        this.log().error("No error listeners defined for unexpected error: " + t, t);
                    }
                    for (RunnableErrorListener listener : list) {
                        listener.onRunnableError(runnable, t);
                    }
                }
            }
            this.m_status = 4;
        }

        @Override
        public void start() {
            this.m_status = 1;
            this.m_shutdown = false;
            this.m_delegateThread.start();
        }

        @Override
        public void stop() {
            this.m_status = 3;
            this.m_shutdown = true;
        }

        @Override
        public String getName() {
            return this.m_delegateThread.getName();
        }

        @Override
        public int getStatus() {
            return this.m_status;
        }

        private ThreadCategory log() {
            return ThreadCategory.getInstance(this.getClass());
        }
    }

    private class SizingFifoQueue<T>
    extends FifoQueueImpl<T>
    implements ClosableFifoQueue<T> {
        private volatile boolean m_isClosed = false;

        private SizingFifoQueue() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void adjust() {
            block12: {
                int e = this.size();
                Fiber[] fiberArray = RunnableConsumerThreadPool.this.m_fibers;
                synchronized (fiberArray) {
                    float ratio;
                    int alive;
                    block11: {
                        alive = RunnableConsumerThreadPool.this.livingFiberCount();
                        ratio = (float)e / (float)(alive <= 0 ? 1 : alive);
                        if (alive <= 1 || !(ratio <= RunnableConsumerThreadPool.this.m_loRatio)) break block11;
                        Fiber f = null;
                        int last = 0;
                        block7: for (Fiber fiber : RunnableConsumerThreadPool.this.m_fibers) {
                            if (fiber == null) continue;
                            switch (fiber.getStatus()) {
                                case 2: {
                                    if (last >= 2) continue block7;
                                    f = fiber;
                                    last = f.getStatus();
                                    continue block7;
                                }
                                case 3: {
                                    if (last >= 3) continue block7;
                                    f = null;
                                    last = 3;
                                }
                            }
                        }
                        if (f == null || f.getStatus() == 3) break block12;
                        if (this.log().isDebugEnabled()) {
                            this.log().debug("adjust: calling stop on fiber " + f.getName());
                        }
                        f.stop();
                        break block12;
                    }
                    if ((alive == 0 && e > 0 || ratio > RunnableConsumerThreadPool.this.m_hiRatio) && alive < RunnableConsumerThreadPool.this.m_maxSize) {
                        for (int x = 0; x < RunnableConsumerThreadPool.this.m_fibers.length; ++x) {
                            if (RunnableConsumerThreadPool.this.m_fibers[x] != null && RunnableConsumerThreadPool.this.m_fibers[x].getStatus() != 4) continue;
                            FiberThreadImpl f = new FiberThreadImpl(RunnableConsumerThreadPool.this.m_poolName + "-fiber" + x);
                            f.start();
                            ((RunnableConsumerThreadPool)RunnableConsumerThreadPool.this).m_fibers[x] = f;
                            if (!this.log().isDebugEnabled()) break;
                            this.log().debug("adjust: started fiber " + f.getName() + " ratio = " + ratio + ", alive = " + alive);
                            break;
                        }
                    }
                }
            }
        }

        @Override
        public boolean isOpen() {
            return !this.m_isClosed;
        }

        @Override
        public boolean isClosed() {
            return this.m_isClosed;
        }

        @Override
        public void close() throws FifoQueueException {
            this.m_isClosed = true;
        }

        @Override
        public void open() throws FifoQueueException {
            this.m_isClosed = false;
        }

        @Override
        public void add(T element) throws FifoQueueException, InterruptedException {
            if (this.m_isClosed) {
                throw new FifoQueueClosedException("Queue Closed");
            }
            super.add(element);
            this.adjust();
        }

        @Override
        public boolean add(T element, long timeout) throws FifoQueueException, InterruptedException {
            if (this.m_isClosed) {
                throw new FifoQueueClosedException("Queue Closed");
            }
            boolean result = super.add(element, timeout);
            this.adjust();
            return result;
        }

        @Override
        public T remove() throws FifoQueueException, InterruptedException {
            if (this.m_isClosed && this.size() == 0) {
                throw new FifoQueueClosedException("Queue Closed");
            }
            Object result = super.remove();
            this.adjust();
            return result;
        }

        @Override
        public T remove(long timeout) throws FifoQueueException, InterruptedException {
            if (this.m_isClosed && this.size() == 0) {
                throw new FifoQueueClosedException("Queue Closed");
            }
            Object result = super.remove(timeout);
            this.adjust();
            return result;
        }

        private ThreadCategory log() {
            return ThreadCategory.getInstance(this.getClass());
        }
    }
}

