/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.maven.plugins;

import com.google.gson.Gson;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.LinkedList;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.opennms.maven.plugins.StructureModule;

@Mojo(name="structure", defaultPhase=LifecyclePhase.PROCESS_SOURCES)
public class StructureMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project.build.directory}", property="outputDir", required=true)
    private File outputDirectory;
    @Parameter(defaultValue="structure-graph.json")
    private String fileName;
    @Parameter(defaultValue="true")
    private boolean rootOnly;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;

    public void execute() throws MojoExecutionException {
        if (this.rootOnly && !this.project.isExecutionRoot()) {
            return;
        }
        List<StructureModule> modules = StructureMojo.toModules(this.project);
        this.getLog().info((CharSequence)String.format("Built structure %d modules.", modules.size()));
        Gson gson = new Gson();
        String json = gson.toJson(modules);
        if (!this.outputDirectory.mkdirs()) {
            this.getLog().error((CharSequence)("Failed to create output directory: " + this.outputDirectory));
        }
        Path path = Paths.get(this.outputDirectory.getAbsolutePath(), this.fileName);
        try {
            this.getLog().info((CharSequence)String.format("Writing graph to: %s", path));
            Files.write(path, json.getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error occurred while writing graph to: " + path, (Exception)e);
        }
    }

    private static List<StructureModule> toModules(MavenProject project) {
        LinkedList<StructureModule> modules = new LinkedList<StructureModule>();
        modules.add(new StructureModule(project));
        if (project.getCollectedProjects() != null) {
            for (MavenProject child : project.getCollectedProjects()) {
                modules.add(new StructureModule(child));
            }
        }
        return modules;
    }
}

