/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.gwt;

import [Ljava.lang.String;;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.LinkedList;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class NewCompileMojo
extends AbstractMojo {
    private File sourceDirectory;
    private File outputDirectory;
    private String className;

    public void execute() throws MojoExecutionException {
        Method main;
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)"CompileMojo#execute()");
        }
        ClassLoader loader = this.getClassLoader();
        String GWTCOMPILER_CLASS_NAME = "com.google.gwt.dev.GWTCompiler";
        Class<?> compiler = null;
        try {
            compiler = loader.loadClass("com.google.gwt.dev.GWTCompiler");
        }
        catch (ClassNotFoundException e) {
            throw new MojoExecutionException("Could not find GWTCompiler.", (Exception)e);
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("  Found class:" + compiler));
        }
        try {
            main = compiler.getMethod("main", String;.class);
        }
        catch (SecurityException e) {
            throw new MojoExecutionException("Permission not granted for reflection.", (Exception)e);
        }
        catch (NoSuchMethodException e) {
            throw new MojoExecutionException("Could not find GWTCompiler#main(String[]).", (Exception)e);
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("  Found method:" + main));
        }
        final LinkedList<String> args = new LinkedList<String>();
        args.add("-out");
        args.add(this.outputDirectory.getAbsolutePath());
        args.add(this.className);
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("  Invoking main with" + args));
        }
        Runnable compile = new Runnable(){

            public void run() {
                try {
                    main.invoke(null, new Object[]{args.toArray(new String[args.size()])});
                }
                catch (IllegalArgumentException e) {
                    throw new RuntimeException("This shouldn't happen.", e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException("Permission not granted for reflection.", e);
                }
                catch (InvocationTargetException e) {
                    throw new RuntimeException("GWTCompiler#main(String[]) failed.", e);
                }
            }
        };
        Thread compileThread = new Thread(compile);
        compileThread.setContextClassLoader(loader);
        compileThread.start();
        try {
            compileThread.join();
        }
        catch (InterruptedException e) {
            throw new MojoExecutionException("Compiler thread stopped.", (Exception)e);
        }
    }

    private ClassLoader getClassLoader() throws MojoExecutionException {
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)"CompileMojo#getClassLoader()");
        }
        URLClassLoader myClassLoader = (URLClassLoader)((Object)((Object)this)).getClass().getClassLoader();
        URL[] originalUrls = myClassLoader.getURLs();
        URL[] urls = new URL[originalUrls.length + 1];
        for (int index = 0; index < originalUrls.length; ++index) {
            try {
                String url = originalUrls[index].toExternalForm();
                urls[index] = new File(url.substring("file:".length())).toURI().toURL();
                continue;
            }
            catch (MalformedURLException e) {
                throw new MojoExecutionException("Failed to convert original classpath to URL.", (Exception)e);
            }
        }
        try {
            urls[originalUrls.length] = this.sourceDirectory.toURL();
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException("Failed to convert source root to URL.", (Exception)e);
        }
        if (this.getLog().isDebugEnabled()) {
            for (int i = 0; i < urls.length; ++i) {
                this.getLog().debug((CharSequence)("  URL:" + urls[i]));
            }
        }
        return new URLClassLoader(urls, myClassLoader.getParent());
    }
}

