/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.gwt;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;

public class JavaCommand {
    public static void main(String[] args) throws IOException, ClassNotFoundException, SecurityException, NoSuchMethodException, InterruptedException {
        ClassLoader cl;
        String classToExecMethod = "main";
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(args));
        if (list.size() < 2) {
            System.err.println("not enough arguments");
            System.exit(1);
        }
        String fileName = (String)list.remove(0);
        String className = (String)list.remove(0);
        File file = new File(fileName);
        if (!file.exists()) {
            System.err.println("warning: " + fileName + " does not exist!");
            cl = ClassLoader.getSystemClassLoader();
        } else {
            cl = JavaCommand.loadClassesFromFile(file);
        }
        String[] classToExecArgs = list.toArray(new String[0]);
        System.out.println("GWT: executing " + className + ".main(" + list + ")");
        Class[] classes = new Class[]{classToExecArgs.getClass()};
        final Object[] methodArgs = new Object[]{classToExecArgs};
        Class<?> c = cl.loadClass(className);
        final Method method = c.getMethod("main", classes);
        Runnable execer = new Runnable(){

            public void run() {
                try {
                    method.invoke(null, methodArgs);
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                    System.exit(1);
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                    System.exit(1);
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                    System.exit(1);
                }
            }
        };
        Thread bootstrapper = new Thread(execer, "Main");
        bootstrapper.setContextClassLoader(cl);
        bootstrapper.start();
        bootstrapper.join();
    }

    public static ClassLoader loadClassesFromFile(File file) throws IOException {
        String line;
        LinkedList<URL> urls = new LinkedList<URL>();
        BufferedReader reader = new BufferedReader(new FileReader(file));
        while ((line = reader.readLine()) != null) {
            File classPathFile;
            line.trim();
            if (line.startsWith("#") || !(classPathFile = new File(line)).exists()) continue;
            urls.add(classPathFile.toURL());
        }
        URL[] urlsArray = urls.toArray(new URL[0]);
        return URLClassLoader.newInstance(urlsArray);
    }
}

