/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.gwt;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.Os;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class GWTCommand {
    private String m_classname;
    private String m_target;
    private String[] m_arguments;
    private Map m_systemProperties;
    private File m_outputDirectory;
    private Log m_logger;
    private List m_classPathEntries = new LinkedList();
    private File m_gwtDirectory;
    private List m_pluginDependencies;
    private Set m_projectDependencies;
    private String[] m_pathElements;
    private List m_wrapperClasspath = new ArrayList();

    public GWTCommand(String classname, String target, String[] arguments) {
        this.m_classname = classname;
        this.m_target = target;
        this.m_arguments = arguments;
    }

    public static GWTCommand create(String classname, String target, String[] arguments) {
        return new GWTCommand(classname, target, arguments);
    }

    public String[] getArguments() {
        return this.m_arguments;
    }

    public void setArguments(String[] arguments) {
        this.m_arguments = arguments;
    }

    public String getClassname() {
        return this.m_classname;
    }

    public void setClassname(String classname) {
        this.m_classname = classname;
    }

    public String getTarget() {
        return this.m_target;
    }

    public void setTarget(String target) {
        this.m_target = target;
    }

    public void setSystemProperties(Map properties) {
        this.m_systemProperties = properties;
    }

    public Map getSystemProperties() {
        return this.m_systemProperties;
    }

    public void setOutputDirectory(File outputDirectory) {
        this.m_outputDirectory = outputDirectory;
    }

    public File getOutputDirectory() {
        return this.m_outputDirectory;
    }

    public void setLog(Log log) {
        this.m_logger = log;
    }

    public Log getLog() {
        return this.m_logger;
    }

    void runCommand(Commandline cl) throws MojoExecutionException {
        this.getLog().debug((CharSequence)("Command line: " + Commandline.toString((String[])cl.getCommandline())));
        StdoutConsumer stdout = new StdoutConsumer(this.getLog());
        StderrConsumer stderr = new StderrConsumer(this.getLog());
        try {
            int result = CommandLineUtils.executeCommandLine((Commandline)cl, (StreamConsumer)stdout, (StreamConsumer)stderr);
            if (result != 0) {
                throw new MojoExecutionException("Toolkit execution returned: '" + result + "'.");
            }
        }
        catch (CommandLineException e) {
            throw new MojoExecutionException("Unable to run " + cl.getExecutable(), (Exception)((Object)e));
        }
    }

    public List getClassPathEntries() {
        return this.m_classPathEntries;
    }

    void addClassPathEntry(String path) {
        this.getClassPathEntries().add(path);
    }

    String getClassPath() {
        String cpsep = System.getProperty("path.separator");
        StringBuffer retval = new StringBuffer();
        boolean first = true;
        Iterator it = this.getClassPathEntries().iterator();
        while (it.hasNext()) {
            String entry = (String)it.next();
            if (first) {
                first = false;
            } else {
                retval.append(cpsep);
            }
            retval.append(entry);
        }
        return retval.toString();
    }

    void getJUnit() throws MojoExecutionException {
        String testClass = this.getTarget();
        Commandline cl = this.setupCommandLine();
        cl.createArgument().setValue(this.getClassname());
        cl.createArgument().setValue(testClass);
        this.runCommand(cl);
    }

    void run() throws MojoExecutionException {
        Iterator it;
        Commandline cl = this.setupCommandLine();
        File classpathFile = null;
        try {
            classpathFile = new File(this.m_outputDirectory, "gwt-classpath");
            FileWriter f = new FileWriter(classpathFile);
            it = this.getClassPathEntries().iterator();
            while (it.hasNext()) {
                f.write((String)it.next() + "\n");
            }
            f.close();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to create temporary claspath file", (Exception)e);
        }
        StringBuffer bootstrapClasspath = new StringBuffer();
        it = this.getWrapperClasspathEntries().iterator();
        while (it.hasNext()) {
            if (bootstrapClasspath.length() != 0) {
                bootstrapClasspath.append(File.pathSeparator);
            }
            bootstrapClasspath.append((String)it.next());
        }
        it = this.getPluginDependencies().iterator();
        while (it.hasNext()) {
            Artifact entry = (Artifact)it.next();
            if (bootstrapClasspath.length() != 0) {
                bootstrapClasspath.append(File.pathSeparator);
            }
            bootstrapClasspath.append(entry.getFile().toString());
        }
        if (bootstrapClasspath.length() > 0) {
            cl.createArgument().setValue("-cp");
            cl.createArgument().setValue(bootstrapClasspath.toString());
        }
        cl.createArgument().setValue("org.codehaus.mojo.gwt.JavaCommand");
        cl.createArgument().setValue(classpathFile.getAbsolutePath());
        cl.createArgument().setValue(this.getClassname());
        for (int i = 0; i < this.getArguments().length; ++i) {
            cl.createArgument().setValue(this.getArguments()[i]);
        }
        cl.createArgument().setValue("-out");
        cl.createArgument().setValue(this.getOutputDirectory().getAbsolutePath());
        cl.createArgument().setValue(this.getTarget());
        this.runCommand(cl);
    }

    private Commandline setupCommandLine() {
        Commandline cl = new Commandline();
        cl.setExecutable("java");
        if (this.isMac()) {
            cl.createArgument().setValue("-XstartOnFirstThread");
        }
        if (this.getSystemProperties() != null) {
            Iterator it = this.getSystemProperties().keySet().iterator();
            while (it.hasNext()) {
                String k = (String)it.next();
                String v = (String)this.getSystemProperties().get(k);
                cl.createArgument().setValue("-D" + k + "=" + v);
            }
        }
        return cl;
    }

    boolean isMac() {
        return Os.isFamily((String)"mac");
    }

    public File getGWTDirectory() {
        return this.m_gwtDirectory;
    }

    public void setGWTDirectory(File gwtDirectory) {
        this.m_gwtDirectory = gwtDirectory;
    }

    public void setPathElements(String[] pathelements) {
        this.m_pathElements = pathelements;
    }

    public String[] getPathElements() {
        return this.m_pathElements;
    }

    public List getPluginDependencies() {
        return this.m_pluginDependencies;
    }

    public void setPluginDependencies(List pluginDependencies) {
        this.m_pluginDependencies = pluginDependencies;
    }

    public Set getProjectDependencies() {
        return this.m_projectDependencies;
    }

    public void setProjectDependencies(Set projectDependencies) {
        this.m_projectDependencies = projectDependencies;
    }

    protected void addGWTJarsFromPluginDependencies() {
        Iterator it = this.getPluginDependencies().iterator();
        while (it.hasNext()) {
            Artifact a = (Artifact)it.next();
            this.getLog().debug((CharSequence)("Dependency " + a + " (" + a.getFile() + ")"));
            File f = a.getFile();
            if (f == null || !a.getGroupId().equals("com.google.gwt")) continue;
            this.addClassPathEntry(f.getAbsolutePath());
        }
    }

    protected void addGWTJarsFromGWTDirectory() {
        if (this.m_gwtDirectory == null) {
            return;
        }
        String[] contents = this.m_gwtDirectory.list();
        if (contents == null) {
            return;
        }
        for (int i = 0; i < contents.length; ++i) {
            if (!contents[i].endsWith(".jar") || contents[i].indexOf("servlet") != -1) continue;
            File f = new File(this.m_gwtDirectory, contents[i]);
            this.getLog().debug((CharSequence)("GWTDirJar " + f));
            this.addClassPathEntry(f.getAbsolutePath());
        }
    }

    void addConfiguredClasspathEntries() {
        String[] pathelements = this.getPathElements();
        if (pathelements != null) {
            for (int i = 0; i < pathelements.length; ++i) {
                this.addClassPathEntry(pathelements[i]);
            }
        }
    }

    void addArtifactsToClasspath(Collection artifacts) {
        Iterator it = artifacts.iterator();
        while (it.hasNext()) {
            Artifact a = (Artifact)it.next();
            this.getLog().debug((CharSequence)("Dependency " + a + " (" + a.getFile() + ")"));
            File f = a.getFile();
            if (f == null || a.getScope().equalsIgnoreCase("provided") || a.getGroupId().equals("com.google.gwt")) continue;
            this.addClassPathEntry(f.getAbsolutePath());
        }
    }

    void addPluginClasspathEntries() {
        this.addArtifactsToClasspath(this.getPluginDependencies());
    }

    void addProjectClasspathEntries() {
        this.addArtifactsToClasspath(this.getProjectDependencies());
    }

    void addGWTJarsToClasspath() {
        this.addGWTJarsFromGWTDirectory();
    }

    public List getWrapperClasspathEntries() {
        return this.m_wrapperClasspath;
    }

    public void addWrapperClasspathEntry(String entry) {
        this.m_wrapperClasspath.add(entry);
    }

    public static class StderrConsumer
    implements StreamConsumer {
        private Log logger;

        public StderrConsumer(Log log) {
            this.logger = log;
        }

        public void consumeLine(String string) {
            this.logger.warn((CharSequence)string);
        }
    }

    public static class StdoutConsumer
    implements StreamConsumer {
        private Log logger;

        public StdoutConsumer(Log log) {
            this.logger = log;
        }

        public void consumeLine(String string) {
            this.logger.info((CharSequence)string);
        }
    }
}

