/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.gwt;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.gwt.GWTCommand;

public abstract class AbstractGWTMojo
extends AbstractMojo {
    private File sourceDirectory;
    private File testsourceDirectory;
    private File outputDirectory;
    private File classDirectory;
    private File testclassDirectory;
    private String moduleName;
    private String homePage;
    File gwtDirectory;
    private MavenProject project;
    private Map properties;
    private String[] pathelements;
    private List pluginArtifacts;
    private Set projectDependencyArtifacts;

    protected String getModuleName() {
        return this.moduleName;
    }

    protected String getHomePage() {
        return this.homePage;
    }

    private void setClassPathEntries(boolean addTest, GWTCommand gwt) {
        gwt.addClassPathEntry(this.sourceDirectory.getAbsolutePath());
        gwt.addClassPathEntry(this.classDirectory.getAbsolutePath());
        if (addTest) {
            gwt.addClassPathEntry(this.testsourceDirectory.getAbsolutePath());
            gwt.addClassPathEntry(this.testclassDirectory.getAbsolutePath());
        }
        this.getLog().debug((CharSequence)("getArtifacts: " + this.project.getArtifacts()));
        this.getLog().debug((CharSequence)("getDependencyArtifacts: " + this.project.getDependencyArtifacts()));
        gwt.addConfiguredClasspathEntries();
        gwt.addProjectClasspathEntries();
        gwt.addPluginClasspathEntries();
        gwt.addGWTJarsToClasspath();
        this.getLog().debug((CharSequence)("Class path: " + gwt.getClassPathEntries()));
    }

    protected void requireGWTDirectory(String goal) throws MojoExecutionException {
        if (this.gwtDirectory == null) {
            throw new MojoExecutionException("gwtDirectory must be configured to run the " + goal + " goal.");
        }
    }

    protected void configure(GWTCommand gwt, boolean addTest) {
        gwt.setPluginDependencies(this.pluginArtifacts);
        gwt.setProjectDependencies(this.projectDependencyArtifacts);
        gwt.setPathElements(this.pathelements);
        gwt.setGWTDirectory(this.gwtDirectory);
        gwt.setLog(this.getLog());
        gwt.setSystemProperties(this.properties);
        gwt.setOutputDirectory(this.outputDirectory);
        this.setClassPathEntries(addTest, gwt);
    }
}

