/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.snmp.joesnmp;

import java.net.InetAddress;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.TrapIdentity;
import org.opennms.netmgt.snmp.TrapInformation;
import org.opennms.netmgt.snmp.TrapProcessor;
import org.opennms.netmgt.snmp.joesnmp.JoeSnmpValue;
import org.opennms.protocols.snmp.SnmpIPAddress;
import org.opennms.protocols.snmp.SnmpPduTrap;
import org.opennms.protocols.snmp.SnmpVarBind;

public class V1TrapInformation
extends TrapInformation {
    private SnmpPduTrap m_pdu;

    public V1TrapInformation(InetAddress agent, String community, SnmpPduTrap pdu, TrapProcessor trapProcessor) {
        super(agent, community, trapProcessor);
        this.m_pdu = pdu;
    }

    protected int getPduLength() {
        return this.m_pdu.getLength();
    }

    protected long getTimeStamp() {
        return this.m_pdu.getTimeStamp();
    }

    protected TrapIdentity getTrapIdentity() {
        return new TrapIdentity(SnmpObjId.get((int[])this.m_pdu.getEnterprise().getIdentifiers()), this.m_pdu.getGeneric(), this.m_pdu.getSpecific());
    }

    protected InetAddress getTrapAddress() {
        return SnmpIPAddress.toInetAddress((SnmpIPAddress)this.m_pdu.getAgentAddress());
    }

    protected SnmpVarBind getVarBindAt(int index) {
        return this.m_pdu.getVarBindAt(index);
    }

    protected String getVersion() {
        return "v1";
    }

    protected void processVarBindAt(int i) {
        SnmpObjId name = SnmpObjId.get((int[])this.getVarBindAt(i).getName().getIdentifiers());
        JoeSnmpValue value = new JoeSnmpValue(this.getVarBindAt(i).getValue());
        this.processVarBind(name, value);
    }
}

