/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.snmp;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.opennms.netmgt.snmp.RowCallback;
import org.opennms.netmgt.snmp.RowResultFactory;
import org.opennms.netmgt.snmp.SnmpInstId;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpResult;
import org.opennms.netmgt.snmp.SnmpRowResult;

public class SnmpTableResult
implements RowResultFactory {
    private final RowCallback m_callback;
    private final SnmpObjId[] m_columns;
    private final RowResultFactory m_rowResultFactory;
    private final List<SnmpObjId> m_finishedColumns;
    private final Map<SnmpInstId, SnmpRowResult> m_pendingData;
    private volatile boolean m_finished = false;

    public SnmpTableResult(RowCallback callback, SnmpObjId ... columns) {
        this(callback, (RowResultFactory)null, columns);
    }

    public SnmpTableResult(RowCallback callback, RowResultFactory rowResultFactory, SnmpObjId ... columns) {
        this.m_callback = callback;
        this.m_columns = columns;
        this.m_rowResultFactory = rowResultFactory == null ? this : rowResultFactory;
        this.m_finishedColumns = new ArrayList<SnmpObjId>();
        this.m_pendingData = new TreeMap<SnmpInstId, SnmpRowResult>();
    }

    private int getColumnCount() {
        return this.m_columns.length;
    }

    void storeResult(SnmpResult result) {
        SnmpInstId instId = result.getInstance();
        if (!this.m_pendingData.containsKey(instId)) {
            this.m_pendingData.put(instId, this.m_rowResultFactory.createRowResult(this.getColumnCount(), instId));
        }
        SnmpRowResult row = this.m_pendingData.get(instId);
        row.addResult(result.getBase(), result);
        this.handleCompleteRows();
    }

    public void setFinished(boolean finished) {
        this.m_finished = finished;
    }

    public boolean isFinished() {
        return this.m_finished;
    }

    void handleCompleteRows() {
        SnmpInstId lastInstance = null;
        for (SnmpRowResult row : this.m_pendingData.values()) {
            if (!row.isComplete(this.m_finishedColumns.toArray(new SnmpObjId[this.m_finishedColumns.size()]))) continue;
            lastInstance = row.getInstance();
        }
        if (lastInstance != null || this.isFinished()) {
            Iterator<SnmpInstId> i = this.m_pendingData.keySet().iterator();
            while (i.hasNext()) {
                SnmpInstId key = i.next();
                this.m_callback.rowCompleted(this.m_pendingData.get(key));
                i.remove();
                if (!key.equals(lastInstance)) continue;
                break;
            }
        }
    }

    void tableFinished() {
        this.setFinished(true);
        this.handleCompleteRows();
    }

    public void columnFinished(SnmpObjId columnId) {
        this.m_finishedColumns.add(columnId);
        this.handleCompleteRows();
    }

    public SnmpRowResult createRowResult(int columnCount, SnmpInstId instance) {
        return new SnmpRowResult(columnCount, instance);
    }
}

