/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.jasper.rrdtool;

import java.util.Date;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import org.opennms.netmgt.jasper.rrdtool.Entry;
import org.opennms.netmgt.jasper.rrdtool.Xport;

public class RrdtoolDataSource
implements JRDataSource {
    private int m_currentRow = -1;
    private Xport m_data;

    public RrdtoolDataSource(Xport data) {
        this.m_data = data;
    }

    public Object getFieldValue(JRField field) throws JRException {
        if ("Timestamp".equalsIgnoreCase(this.getColumnName(field))) {
            long ts = new Long(this.m_data.getData().getRow(this.m_currentRow).getT().getContent()) * 1000L;
            return new Date(ts);
        }
        if ("Step".equalsIgnoreCase(this.getColumnName(field))) {
            return new Integer(this.m_data.getMeta().getStep().getContent());
        }
        int index = this.getColumnIndex(field);
        return new Double(this.m_data.getData().getRow(this.m_currentRow).getV(index).getContent());
    }

    private String getColumnName(JRField field) {
        return field.getDescription() == null || field.getDescription().trim().equals("") ? field.getName() : field.getDescription();
    }

    public boolean next() throws JRException {
        ++this.m_currentRow;
        return this.m_data == null || this.m_data.getData() == null ? false : this.m_currentRow < this.m_data.getData().getRowCount();
    }

    private int getColumnIndex(JRField field) {
        String column = this.getColumnName(field);
        int i = 0;
        for (Entry legend : this.m_data.getMeta().getLegend().getEntryCollection()) {
            if (legend.getContent().equals(column)) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

