/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.jasper.jrobin;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.ListIterator;
import org.jrobin.core.RrdException;

class RrdCmdScanner {
    private LinkedList<String> words = new LinkedList();
    private StringBuffer buff;

    RrdCmdScanner(String command) throws RrdException {
        String cmd = command.trim();
        char activeQuote = '\u0000';
        for (int i = 0; i < cmd.length(); ++i) {
            char c2;
            char c = cmd.charAt(i);
            if ((c == '\"' || c == '\'') && activeQuote == '\u0000') {
                this.initWord();
                activeQuote = c;
                continue;
            }
            if (c == activeQuote) {
                activeQuote = '\u0000';
                continue;
            }
            if (this.isSeparator(c) && activeQuote == '\u0000') {
                this.finishWord();
                continue;
            }
            if (c == '\\' && activeQuote == '\"' && i + 1 < cmd.length() && ((c2 = cmd.charAt(i + 1)) == '\\' || c2 == '\"')) {
                this.appendWord(c2);
                ++i;
                continue;
            }
            this.appendWord(c);
        }
        if (activeQuote != '\u0000') {
            throw new RrdException("End of command reached but " + activeQuote + " expected");
        }
        this.finishWord();
    }

    String getCmdType() {
        if (this.words.size() > 0) {
            return this.words.get(0);
        }
        return null;
    }

    private void appendWord(char c) {
        if (this.buff == null) {
            this.buff = new StringBuffer("");
        }
        this.buff.append(c);
    }

    private void finishWord() {
        if (this.buff != null) {
            this.words.add(this.buff.toString());
            this.buff = null;
        }
    }

    private void initWord() {
        if (this.buff == null) {
            this.buff = new StringBuffer("");
        }
    }

    void dump() {
        for (String word : this.words) {
            System.out.println(word);
        }
    }

    String getOptionValue(String shortForm, String longForm, String defaultValue) throws RrdException {
        String value = null;
        if (shortForm != null) {
            value = this.getOptionValue("-" + shortForm);
        }
        if (value == null && longForm != null) {
            value = this.getOptionValue("--" + longForm);
        }
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    String getOptionValue(String shortForm, String longForm) throws RrdException {
        return this.getOptionValue(shortForm, longForm, null);
    }

    private String getOptionValue(String fullForm) throws RrdException {
        ListIterator iter = this.words.listIterator();
        while (iter.hasNext()) {
            String word = (String)iter.next();
            if (word.equals(fullForm)) {
                if (iter.hasNext()) {
                    iter.remove();
                    String value = (String)iter.next();
                    iter.remove();
                    return value;
                }
                throw new RrdException("Value for option " + fullForm + " expected but not found");
            }
            if (!word.startsWith(fullForm)) continue;
            int pos = fullForm.length();
            if (word.charAt(pos) == '=') {
                ++pos;
            }
            iter.remove();
            return word.substring(pos);
        }
        return null;
    }

    boolean getBooleanOption(String shortForm, String longForm) {
        ListIterator iter = this.words.listIterator();
        while (iter.hasNext()) {
            String word = (String)iter.next();
            if ((shortForm == null || !word.equals("-" + shortForm)) && (longForm == null || !word.equals("--" + longForm))) continue;
            iter.remove();
            return true;
        }
        return false;
    }

    String[] getMultipleOptions(String shortForm, String longForm) throws RrdException {
        String value;
        ArrayList<String> values = new ArrayList<String>();
        while ((value = this.getOptionValue(shortForm, longForm, null)) != null) {
            values.add(value);
        }
        return values.toArray(new String[values.size()]);
    }

    String[] getRemainingWords() {
        return this.words.toArray(new String[this.words.size()]);
    }

    boolean isSeparator(char c) {
        return Character.isWhitespace(c);
    }
}

