/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.jasper.jrobin;

import java.util.Date;
import java.util.List;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import org.opennms.netmgt.jasper.jrobin.RrdXportCmd;

public class JRobinDataSource
implements JRDataSource {
    private int m_currentRow = -1;
    private long[] m_timestamps;
    private long m_step;
    private List<RrdXportCmd.XPort> m_xports;

    public JRobinDataSource(long step, long[] timestamps, List<RrdXportCmd.XPort> xports) {
        this.m_step = step;
        this.m_timestamps = timestamps;
        this.m_xports = xports;
    }

    public Object getFieldValue(JRField field) throws JRException {
        Object computeFieldValue = this.computeFieldValue(field);
        return computeFieldValue;
    }

    private Object computeFieldValue(JRField field) {
        if ("Timestamp".equalsIgnoreCase(this.getColumnName(field))) {
            return new Date(this.m_timestamps[this.m_currentRow] * 1000L);
        }
        if ("Step".equalsIgnoreCase(this.getColumnName(field))) {
            return this.m_step;
        }
        RrdXportCmd.XPort xport = this.findXPortForField(this.getColumnName(field));
        return xport == null ? null : Double.valueOf(xport.values[this.m_currentRow]);
    }

    private String getColumnName(JRField field) {
        return field.getDescription() == null || field.getDescription().trim().equals("") ? field.getName() : field.getDescription();
    }

    private RrdXportCmd.XPort findXPortForField(String description) {
        for (RrdXportCmd.XPort xport : this.m_xports) {
            if (!xport.legend.equalsIgnoreCase(description)) continue;
            return xport;
        }
        return null;
    }

    public boolean next() throws JRException {
        ++this.m_currentRow;
        return this.m_currentRow < this.m_timestamps.length;
    }
}

