/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.jasper.jrobin;

import java.util.Date;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;

public class FakeJRobinDataSource
implements JRDataSource {
    private static long INCREMENT = 300000L;
    private int m_rows;
    private String[] m_fields;
    private int m_currentRow = 0;
    private long m_end;

    public FakeJRobinDataSource(String queryString) {
        String[] stringArray = queryString.split(":");
        this.m_rows = Integer.parseInt(stringArray[0]);
        this.m_fields = new String[stringArray.length - 1];
        System.arraycopy(stringArray, 1, this.m_fields, 0, this.m_fields.length);
        this.m_end = System.currentTimeMillis() / INCREMENT * INCREMENT;
    }

    public Object getFieldValue(JRField field) throws JRException {
        if ("Timestamp".equals(field.getName())) {
            long millis = this.m_end - (long)(this.m_rows - this.m_currentRow) * INCREMENT;
            return new Date(millis);
        }
        Integer index = this.getColumnIndex(field.getName());
        return index == null ? null : Double.valueOf(this.m_currentRow * index);
    }

    private Integer getColumnIndex(String fieldName) {
        for (int i = 0; i < this.m_fields.length; ++i) {
            if (!this.m_fields[i].equals(fieldName)) continue;
            return i + 1;
        }
        return null;
    }

    public boolean next() throws JRException {
        ++this.m_currentRow;
        return this.m_currentRow <= this.m_rows;
    }
}

