/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.jasper.jrobin;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.engine.JRDataSource;
import org.jrobin.core.RrdException;
import org.jrobin.core.Util;
import org.jrobin.data.DataProcessor;
import org.jrobin.graph.RrdGraphConstants;
import org.opennms.netmgt.jasper.jrobin.ColonSplitter;
import org.opennms.netmgt.jasper.jrobin.JRobinDataSource;
import org.opennms.netmgt.jasper.jrobin.RrdToolCmd;

class RrdXportCmd
extends RrdToolCmd
implements RrdGraphConstants {
    private DataProcessor dproc;
    private List<XPort> xports;

    RrdXportCmd() {
    }

    @Override
    String getCmdType() {
        return "xport";
    }

    @Override
    JRDataSource execute() throws RrdException, IOException {
        String startStr = this.getOptionValue("s", "start", "end-1d");
        String endStr = this.getOptionValue("e", "end", "now");
        long[] span = Util.getTimestamps((String)startStr, (String)endStr);
        this.dproc = new DataProcessor(span[0], span[1]);
        this.xports = new ArrayList<XPort>();
        long step = RrdXportCmd.parseLong(this.getOptionValue(null, "step", "1"));
        int maxRows = RrdXportCmd.parseInt(this.getOptionValue("m", "maxrows", "400"));
        long minStep = (long)Math.ceil((double)(span[1] - span[0]) / (double)(maxRows - 1));
        step = Math.max(step, minStep);
        this.dproc.setFetchRequestResolution(step);
        this.dproc.setStep(step);
        String[] words = this.getRemainingWords();
        if (words.length < 1) {
            throw new RrdException("Incomplete XPORT command");
        }
        for (int i = 0; i < words.length; ++i) {
            if (words[i].startsWith("DEF:")) {
                this.parseDef(words[i]);
                continue;
            }
            if (words[i].startsWith("CDEF:")) {
                this.parseCDef(words[i]);
                continue;
            }
            if (words[i].startsWith("XPORT:")) {
                this.parseXport(words[i]);
                continue;
            }
            throw new RrdException("Invalid XPORT syntax: " + words[i]);
        }
        JRDataSource result = this.xports.size() == 0 ? null : this.xport();
        RrdXportCmd.println(this.xports.size() == 0 ? "No XPORT statement found, nothing done" : result.toString());
        return result;
    }

    private JRDataSource xport() throws IOException, RrdException {
        this.dproc.processData();
        long[] timestamps = this.dproc.getTimestamps();
        for (int i = 0; i < timestamps.length; ++i) {
            timestamps[i] = timestamps[i] - this.dproc.getStep();
        }
        for (XPort xport : this.xports) {
            xport.values = this.dproc.getValues(xport.name);
        }
        return new JRobinDataSource(this.dproc.getStep(), timestamps, this.xports);
    }

    private void parseDef(String word) throws RrdException {
        String[] tokens1 = new ColonSplitter(word).split();
        if (tokens1.length != 4) {
            throw new RrdException("Invalid DEF syntax: " + word);
        }
        String[] tokens2 = tokens1[1].split("=");
        if (tokens2.length != 2) {
            throw new RrdException("Invalid DEF syntax: " + word);
        }
        this.dproc.addDatasource(tokens2[0], tokens2[1], tokens1[2], tokens1[3]);
    }

    private void parseCDef(String word) throws RrdException {
        String[] tokens1 = new ColonSplitter(word).split();
        if (tokens1.length != 2) {
            throw new RrdException("Invalid CDEF syntax: " + word);
        }
        String[] tokens2 = tokens1[1].split("=");
        if (tokens2.length != 2) {
            throw new RrdException("Invalid CDEF syntax: " + word);
        }
        this.dproc.addDatasource(tokens2[0], tokens2[1]);
    }

    private void parseXport(String word) throws RrdException {
        String[] tokens = new ColonSplitter(word).split();
        if (tokens.length != 2 && tokens.length != 3) {
            throw new RrdException("Invalid XPORT syntax: " + word);
        }
        XPort xport = new XPort(tokens[1], tokens.length == 3 ? tokens[2] : null);
        this.xports.add(xport);
    }

    static class XPort {
        String name;
        String legend;
        double[] values;

        XPort(String name, String legend) {
            this.name = name;
            this.legend = legend != null ? legend : "";
        }
    }
}

