/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.vaadin.surveillanceviews.ui.dashboard;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.vaadin.data.Container;
import com.vaadin.data.util.BeanItemContainer;
import com.vaadin.server.Page;
import com.vaadin.server.VaadinServlet;
import com.vaadin.ui.Button;
import com.vaadin.ui.Table;
import com.vaadin.ui.Window;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import org.opennms.features.topology.api.support.InfoWindow;
import org.opennms.features.vaadin.surveillanceviews.service.SurveillanceViewService;
import org.opennms.features.vaadin.surveillanceviews.ui.dashboard.SurveillanceViewDetailTable;
import org.opennms.netmgt.model.OnmsCategory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SurveillanceViewNodeRtcTable
extends SurveillanceViewDetailTable {
    private static final Logger LOG = LoggerFactory.getLogger(SurveillanceViewNodeRtcTable.class);
    private BeanItemContainer<SurveillanceViewService.NodeRtc> m_beanItemContainer = new BeanItemContainer(SurveillanceViewService.NodeRtc.class);
    protected ListenableFuture<List<SurveillanceViewService.NodeRtc>> m_future;

    public SurveillanceViewNodeRtcTable(SurveillanceViewService surveillanceViewService, boolean enabled) {
        super("Outages", surveillanceViewService, enabled);
        this.setContainerDataSource((Container)this.m_beanItemContainer);
        this.addStyleName("surveillance-view");
        this.addGeneratedColumn("node", new Table.ColumnGenerator(){

            public Object generateCell(Table table, Object itemId, Object propertyId) {
                final SurveillanceViewService.NodeRtc nodeRtc = (SurveillanceViewService.NodeRtc)itemId;
                Button button = new Button(nodeRtc.getNode().getLabel());
                button.setPrimaryStyleName("link");
                button.setEnabled(SurveillanceViewNodeRtcTable.this.m_enabled);
                button.addStyleName("white");
                button.addClickListener(new Button.ClickListener(){

                    public void buttonClick(Button.ClickEvent clickEvent) {
                        URI currentLocation = Page.getCurrent().getLocation();
                        String contextRoot = VaadinServlet.getCurrent().getServletContext().getContextPath();
                        String redirectFragment = contextRoot + "/element/node.jsp?quiet=true&node=" + nodeRtc.getNode().getId();
                        LOG.debug("node {} clicked, current location = {}, uri = {}", new Object[]{nodeRtc.getNode().getId(), currentLocation, redirectFragment});
                        try {
                            SurveillanceViewNodeRtcTable.this.getUI().addWindow((Window)new InfoWindow(new URL(currentLocation.toURL(), redirectFragment), new InfoWindow.LabelCreator(){

                                public String getLabel() {
                                    return "Node Info " + nodeRtc.getNode().getId();
                                }
                            }));
                        }
                        catch (MalformedURLException e) {
                            LOG.error(e.getMessage(), (Throwable)e);
                        }
                    }
                });
                return button;
            }
        });
        this.addGeneratedColumn("currentOutages", new Table.ColumnGenerator(){

            public Object generateCell(Table table, Object itemId, Object columnId) {
                SurveillanceViewService.NodeRtc nodeRtc = (SurveillanceViewService.NodeRtc)itemId;
                return SurveillanceViewNodeRtcTable.this.getImageSeverityLayout(nodeRtc.getDownServiceCount() + " of " + nodeRtc.getServiceCount());
            }
        });
        this.addGeneratedColumn("availability", new Table.ColumnGenerator(){

            public Object generateCell(Table table, Object itemId, Object propertyId) {
                SurveillanceViewService.NodeRtc nodeRtc = (SurveillanceViewService.NodeRtc)itemId;
                return SurveillanceViewNodeRtcTable.this.getImageSeverityLayout(nodeRtc.getAvailabilityAsString());
            }
        });
        this.setCellStyleGenerator(new Table.CellStyleGenerator(){

            public String getStyle(Table table, Object itemId, Object propertyId) {
                String style = null;
                SurveillanceViewService.NodeRtc nodeRtc = (SurveillanceViewService.NodeRtc)itemId;
                if (!"node".equals(propertyId)) {
                    style = nodeRtc.getAvailability() == 1.0 ? "rtc-normal" : "rtc-critical";
                }
                return style;
            }
        });
        this.setColumnHeader("node", "Node");
        this.setColumnHeader("currentOutages", "Current Outages");
        this.setColumnHeader("availability", "24 Hour Availability");
        this.setColumnExpandRatio("node", 1.0f);
        this.setColumnExpandRatio("currentOutages", 1.0f);
        this.setColumnExpandRatio("availability", 1.0f);
        this.setVisibleColumns(new Object[]{"node", "currentOutages", "availability"});
    }

    @Override
    public void refreshDetails(final Set<OnmsCategory> rowCategories, final Set<OnmsCategory> colCategories) {
        if (this.m_future != null && !this.m_future.isDone()) {
            return;
        }
        this.m_future = this.getSurveillanceViewService().getExecutorService().submit((Callable)new Callable<List<SurveillanceViewService.NodeRtc>>(){

            @Override
            public List<SurveillanceViewService.NodeRtc> call() throws Exception {
                return SurveillanceViewNodeRtcTable.this.getSurveillanceViewService().getNodeRtcsForCategories(rowCategories, colCategories);
            }
        });
        this.m_future.addListener(new Runnable(){

            @Override
            public void run() {
                try {
                    final List nodeRtcs = (List)SurveillanceViewNodeRtcTable.this.m_future.get();
                    SurveillanceViewNodeRtcTable.this.getUI().access(new Runnable(){

                        @Override
                        public void run() {
                            SurveillanceViewNodeRtcTable.this.m_beanItemContainer.removeAllItems();
                            if (nodeRtcs != null && !nodeRtcs.isEmpty()) {
                                for (SurveillanceViewService.NodeRtc nodeRtc : nodeRtcs) {
                                    SurveillanceViewNodeRtcTable.this.m_beanItemContainer.addItem((Object)nodeRtc);
                                }
                            }
                            SurveillanceViewNodeRtcTable.this.sort(new Object[]{"node"}, new boolean[]{true});
                            SurveillanceViewNodeRtcTable.this.refreshRowCache();
                        }
                    });
                }
                catch (InterruptedException e) {
                    LOG.error("Interrupted", (Throwable)e);
                }
                catch (ExecutionException e) {
                    LOG.error("Exception in task", e.getCause());
                }
            }
        }, MoreExecutors.directExecutor());
    }
}

