/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.vaadin.surveillanceviews.ui.dashboard;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.vaadin.data.Container;
import com.vaadin.data.util.BeanItemContainer;
import com.vaadin.server.Page;
import com.vaadin.server.VaadinServlet;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Table;
import com.vaadin.ui.Window;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import org.opennms.features.topology.api.support.InfoWindow;
import org.opennms.features.vaadin.surveillanceviews.service.SurveillanceViewService;
import org.opennms.features.vaadin.surveillanceviews.ui.dashboard.SurveillanceViewDetailTable;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.netmgt.model.OnmsCategory;
import org.opennms.netmgt.model.OnmsNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SurveillanceViewAlarmTable
extends SurveillanceViewDetailTable {
    private static final Logger LOG = LoggerFactory.getLogger(SurveillanceViewAlarmTable.class);
    private BeanItemContainer<Alarm> m_beanItemContainer = new BeanItemContainer(Alarm.class);
    protected ListenableFuture<List<Alarm>> m_future;

    public SurveillanceViewAlarmTable(SurveillanceViewService surveillanceViewService, boolean enabled) {
        super("Alarms", surveillanceViewService, enabled);
        this.setContainerDataSource((Container)this.m_beanItemContainer);
        this.addStyleName("surveillance-view");
        this.addGeneratedColumn("nodeLabel", new Table.ColumnGenerator(){

            public Object generateCell(Table table, Object itemId, Object propertyId) {
                final Alarm alarm = (Alarm)itemId;
                Button icon = SurveillanceViewAlarmTable.this.getClickableIcon("glyphicon glyphicon-warning-sign", new Button.ClickListener(){

                    public void buttonClick(Button.ClickEvent clickEvent) {
                        URI currentLocation = Page.getCurrent().getLocation();
                        String contextRoot = VaadinServlet.getCurrent().getServletContext().getContextPath();
                        String redirectFragment = contextRoot + "/alarm/detail.htm?quiet=true&id=" + alarm.getId();
                        LOG.debug("alarm {} clicked, current location = {}, uri = {}", new Object[]{alarm.getId(), currentLocation, redirectFragment});
                        try {
                            SurveillanceViewAlarmTable.this.getUI().addWindow((Window)new InfoWindow(new URL(currentLocation.toURL(), redirectFragment), new InfoWindow.LabelCreator(){

                                public String getLabel() {
                                    return "Alarm Info " + alarm.getId();
                                }
                            }));
                        }
                        catch (MalformedURLException e) {
                            LOG.error(e.getMessage(), (Throwable)e);
                        }
                    }
                });
                Button button = new Button(alarm.getNodeLabel());
                button.setPrimaryStyleName("link");
                button.setEnabled(SurveillanceViewAlarmTable.this.m_enabled);
                button.addClickListener(new Button.ClickListener(){

                    public void buttonClick(Button.ClickEvent clickEvent) {
                        URI currentLocation = Page.getCurrent().getLocation();
                        String contextRoot = VaadinServlet.getCurrent().getServletContext().getContextPath();
                        String redirectFragment = contextRoot + "/element/node.jsp?quiet=true&node=" + alarm.getNodeId();
                        LOG.debug("node {} clicked, current location = {}, uri = {}", new Object[]{alarm.getNodeId(), currentLocation, redirectFragment});
                        try {
                            SurveillanceViewAlarmTable.this.getUI().addWindow((Window)new InfoWindow(new URL(currentLocation.toURL(), redirectFragment), new InfoWindow.LabelCreator(){

                                public String getLabel() {
                                    return "Node Info " + alarm.getNodeId();
                                }
                            }));
                        }
                        catch (MalformedURLException e) {
                            LOG.error(e.getMessage(), (Throwable)e);
                        }
                    }
                });
                HorizontalLayout horizontalLayout = new HorizontalLayout();
                horizontalLayout.addComponent((Component)icon);
                horizontalLayout.addComponent((Component)button);
                horizontalLayout.setSpacing(true);
                return horizontalLayout;
            }
        });
        this.addGeneratedColumn("severity", new Table.ColumnGenerator(){

            public Object generateCell(Table table, Object itemId, Object propertyId) {
                Alarm alarm = (Alarm)itemId;
                return SurveillanceViewAlarmTable.this.getImageSeverityLayout(alarm.getSeverity());
            }
        });
        this.setCellStyleGenerator(new Table.CellStyleGenerator(){

            public String getStyle(Table source, Object itemId, Object propertyId) {
                Alarm alarm = (Alarm)itemId;
                String style = alarm.getSeverity().toLowerCase();
                if ("severity".equals(propertyId)) {
                    style = style + "-image";
                }
                return style;
            }
        });
        this.setColumnHeader("nodeLabel", "Node");
        this.setColumnHeader("severity", "Severity");
        this.setColumnHeader("uei", "UEI");
        this.setColumnHeader("counter", "Count");
        this.setColumnHeader("lastEventTime", "Last Time");
        this.setColumnHeader("logMsg", "Log Msg");
        this.setColumnExpandRatio("nodeLabel", 2.25f);
        this.setColumnExpandRatio("severity", 1.0f);
        this.setColumnExpandRatio("uei", 3.0f);
        this.setColumnExpandRatio("counter", 0.5f);
        this.setColumnExpandRatio("lastEventTime", 1.5f);
        this.setColumnExpandRatio("logMsg", 4.0f);
        this.setVisibleColumns(new Object[]{"nodeLabel", "severity", "uei", "counter", "lastEventTime", "logMsg"});
    }

    @Override
    public void refreshDetails(final Set<OnmsCategory> rowCategories, final Set<OnmsCategory> colCategories) {
        if (this.m_future != null && !this.m_future.isDone()) {
            return;
        }
        this.m_future = this.getSurveillanceViewService().getExecutorService().submit((Callable)new Callable<List<Alarm>>(){

            @Override
            public List<Alarm> call() throws Exception {
                List<OnmsAlarm> onmsAlarms = SurveillanceViewAlarmTable.this.getSurveillanceViewService().getAlarmsForCategories(rowCategories, colCategories);
                ArrayList<Alarm> alarms = new ArrayList<Alarm>();
                HashMap<Integer, OnmsNode> nodeMap = new HashMap<Integer, OnmsNode>();
                for (OnmsAlarm onmsAlarm : onmsAlarms) {
                    if (!nodeMap.containsKey(onmsAlarm.getNodeId())) {
                        nodeMap.put(onmsAlarm.getNodeId(), SurveillanceViewAlarmTable.this.getSurveillanceViewService().getNodeForId(onmsAlarm.getNodeId()));
                    }
                    alarms.add(new Alarm(onmsAlarm.getId(), onmsAlarm.getUei(), onmsAlarm.getSeverityId(), onmsAlarm.getSeverity().getLabel(), ((OnmsNode)nodeMap.get(onmsAlarm.getNodeId())).getLabel(), onmsAlarm.getNodeId(), onmsAlarm.getLogMsg(), onmsAlarm.getCounter(), onmsAlarm.getFirstEventTime(), onmsAlarm.getLastEventTime()));
                }
                return alarms;
            }
        });
        this.m_future.addListener(new Runnable(){

            @Override
            public void run() {
                try {
                    final List alarms = (List)SurveillanceViewAlarmTable.this.m_future.get();
                    SurveillanceViewAlarmTable.this.getUI().access(new Runnable(){

                        @Override
                        public void run() {
                            SurveillanceViewAlarmTable.this.m_beanItemContainer.removeAllItems();
                            if (alarms != null && !alarms.isEmpty()) {
                                for (Alarm alarm : alarms) {
                                    SurveillanceViewAlarmTable.this.m_beanItemContainer.addItem((Object)alarm);
                                }
                            }
                            SurveillanceViewAlarmTable.this.sort(new Object[]{"severityId", "lastEventTime"}, new boolean[]{false, false});
                            SurveillanceViewAlarmTable.this.refreshRowCache();
                        }
                    });
                }
                catch (InterruptedException e) {
                    LOG.error("Interrupted", (Throwable)e);
                }
                catch (ExecutionException e) {
                    LOG.error("Exception in task", e.getCause());
                }
            }
        }, (Executor)MoreExecutors.sameThreadExecutor());
    }

    public class Alarm {
        private int id;
        private int nodeId;
        private int severityId;
        private String severity;
        private String nodeLabel;
        private String logMsg;
        private int counter;
        private Date firstEventTime;
        private Date lastEventTime;
        private String uei;

        public Alarm(int id, String uei, int severityId, String severity, String nodeLabel, int nodeId, String logMsg, int counter, Date firstEventTime, Date lastEventTime) {
            this.id = id;
            this.uei = uei;
            this.severityId = severityId;
            this.severity = severity;
            this.nodeLabel = nodeLabel;
            this.nodeId = nodeId;
            this.logMsg = logMsg;
            this.counter = counter;
            this.firstEventTime = firstEventTime;
            this.lastEventTime = lastEventTime;
        }

        public String getSeverity() {
            return this.severity;
        }

        public int getSeverityId() {
            return this.severityId;
        }

        public int getNodeId() {
            return this.nodeId;
        }

        public int getId() {
            return this.id;
        }

        public String getUei() {
            return this.uei;
        }

        public String getNodeLabel() {
            return this.nodeLabel;
        }

        public String getLogMsg() {
            return this.logMsg;
        }

        public int getCounter() {
            return this.counter;
        }

        public Date getFirstEventTime() {
            return this.firstEventTime;
        }

        public Date getLastEventTime() {
            return this.lastEventTime;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Alarm alarm = (Alarm)o;
            if (this.counter != alarm.counter) {
                return false;
            }
            if (this.id != alarm.id) {
                return false;
            }
            if (this.nodeId != alarm.nodeId) {
                return false;
            }
            if (this.firstEventTime != null ? !this.firstEventTime.equals(alarm.firstEventTime) : alarm.firstEventTime != null) {
                return false;
            }
            if (this.lastEventTime != null ? !this.lastEventTime.equals(alarm.lastEventTime) : alarm.lastEventTime != null) {
                return false;
            }
            if (this.logMsg != null ? !this.logMsg.equals(alarm.logMsg) : alarm.logMsg != null) {
                return false;
            }
            if (this.nodeLabel != null ? !this.nodeLabel.equals(alarm.nodeLabel) : alarm.nodeLabel != null) {
                return false;
            }
            return !(this.severity != null ? !this.severity.equals(alarm.severity) : alarm.severity != null);
        }

        public int hashCode() {
            int result = this.id;
            result = 31 * result + this.nodeId;
            result = 31 * result + (this.severity != null ? this.severity.hashCode() : 0);
            result = 31 * result + (this.nodeLabel != null ? this.nodeLabel.hashCode() : 0);
            result = 31 * result + (this.logMsg != null ? this.logMsg.hashCode() : 0);
            result = 31 * result + this.counter;
            result = 31 * result + (this.firstEventTime != null ? this.firstEventTime.hashCode() : 0);
            result = 31 * result + (this.lastEventTime != null ? this.lastEventTime.hashCode() : 0);
            return result;
        }
    }
}

