/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.vaadin.surveillanceviews.ui;

import com.vaadin.annotations.Theme;
import com.vaadin.annotations.Title;
import com.vaadin.server.VaadinRequest;
import com.vaadin.ui.Component;
import com.vaadin.ui.Notification;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import org.opennms.features.vaadin.surveillanceviews.config.SurveillanceViewProvider;
import org.opennms.features.vaadin.surveillanceviews.service.SurveillanceViewService;
import org.opennms.features.vaadin.surveillanceviews.ui.SurveillanceViewsConfigList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Theme(value="opennms")
@Title(value="OpenNMS Surveillance Views")
public class SurveillanceViewsConfigUI
extends UI {
    private static final Logger LOG = LoggerFactory.getLogger(SurveillanceViewsConfigUI.class);
    private SurveillanceViewService m_surveillanceViewService;

    protected void init(VaadinRequest request) {
        SurveillanceViewProvider.getInstance().load();
        VerticalLayout rootLayout = new VerticalLayout();
        rootLayout.setSizeFull();
        rootLayout.setSpacing(true);
        rootLayout.addComponent((Component)new SurveillanceViewsConfigList(this.m_surveillanceViewService));
        this.setContent((Component)rootLayout);
    }

    public void notifyMessage(String message, String description, Notification.Type type) {
        Notification m_notification = new Notification("Message", type);
        m_notification.setCaption(message);
        m_notification.setDescription(description);
        m_notification.setDelayMsec(1000);
        if (this.getUI() != null && this.getPage() != null) {
            m_notification.show(this.getUI().getPage());
        }
    }

    public void notifyMessage(String message, String description) {
        this.notifyMessage(message, description, Notification.Type.TRAY_NOTIFICATION);
    }

    public void setSurveillanceViewService(SurveillanceViewService surveillanceViewService) {
        this.m_surveillanceViewService = surveillanceViewService;
    }
}

