/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.vaadin.surveillanceviews.ui;

import com.vaadin.data.Validator;
import com.vaadin.data.validator.AbstractStringValidator;
import com.vaadin.server.Sizeable;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.FormLayout;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Notification;
import com.vaadin.ui.Table;
import com.vaadin.ui.TextField;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.ui.Window;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.opennms.features.vaadin.surveillanceviews.model.Category;
import org.opennms.features.vaadin.surveillanceviews.model.ColumnDef;
import org.opennms.features.vaadin.surveillanceviews.model.Def;
import org.opennms.features.vaadin.surveillanceviews.model.RowDef;
import org.opennms.features.vaadin.surveillanceviews.service.SurveillanceViewService;
import org.opennms.features.vaadin.surveillanceviews.ui.SurveillanceViewsConfigUI;
import org.opennms.netmgt.model.OnmsCategory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SurveillanceViewConfigurationCategoryWindow
extends Window {
    private static final Logger LOG = LoggerFactory.getLogger(SurveillanceViewConfigurationCategoryWindow.class);

    public SurveillanceViewConfigurationCategoryWindow(SurveillanceViewService surveillanceViewService, final Collection<?> defs, final Def def, final SaveActionListener saveActionListener) {
        super("Window title");
        if (def instanceof RowDef) {
            super.setCaption("Row definition");
        } else {
            super.setCaption("Column definition");
        }
        this.setModal(true);
        this.setClosable(false);
        this.setResizable(false);
        this.setWidth(30.0f, Sizeable.Unit.PERCENTAGE);
        this.setHeight(400.0f, Sizeable.Unit.PIXELS);
        final TextField labelField = new TextField();
        labelField.setValue(def.getLabel());
        labelField.setImmediate(true);
        labelField.setCaption("Label");
        labelField.setDescription("Label of this category");
        labelField.setWidth(100.0f, Sizeable.Unit.PERCENTAGE);
        labelField.addValidator((Validator)new AbstractStringValidator("Please use an unique name for this column/row definition"){

            protected boolean isValidValue(String s) {
                if ("".equals(s.trim())) {
                    return false;
                }
                for (Def defx : defs) {
                    if (!defx.getLabel().equals(s) || defx == def) continue;
                    return false;
                }
                return true;
            }
        });
        final Table categoriesTable = new Table();
        categoriesTable.setSizeFull();
        categoriesTable.setHeight(250.0f, Sizeable.Unit.PIXELS);
        categoriesTable.setCaption("Categories");
        categoriesTable.setSortEnabled(true);
        categoriesTable.addContainerProperty((Object)"name", String.class, (Object)"");
        categoriesTable.setColumnHeader((Object)"name", "Category");
        categoriesTable.setColumnExpandRatio((Object)"Category", 1.0f);
        categoriesTable.setSelectable(true);
        categoriesTable.setMultiSelect(true);
        List<OnmsCategory> categories = surveillanceViewService.getOnmsCategories();
        final HashMap<Integer, OnmsCategory> categoriesMap = new HashMap<Integer, OnmsCategory>();
        for (OnmsCategory onmsCategory : categories) {
            categoriesTable.addItem(new Object[]{onmsCategory.getName()}, (Object)onmsCategory.getId());
            categoriesMap.put(onmsCategory.getId(), onmsCategory);
            if (!def.containsCategory(onmsCategory.getName())) continue;
            categoriesTable.select((Object)onmsCategory.getId());
        }
        FormLayout baseFormLayout = new FormLayout();
        baseFormLayout.setSizeFull();
        baseFormLayout.setMargin(true);
        baseFormLayout.addComponent((Component)labelField);
        baseFormLayout.addComponent((Component)categoriesTable);
        VerticalLayout verticalLayout = new VerticalLayout();
        verticalLayout.setSizeFull();
        verticalLayout.addComponent((Component)baseFormLayout);
        verticalLayout.setExpandRatio((Component)baseFormLayout, 1.0f);
        HorizontalLayout horizontalLayout = new HorizontalLayout();
        horizontalLayout.setMargin(true);
        horizontalLayout.setSpacing(true);
        horizontalLayout.setWidth(100.0f, Sizeable.Unit.PERCENTAGE);
        Button cancel = new Button("Cancel");
        cancel.setDescription("Cancel editing properties");
        cancel.addClickListener(new Button.ClickListener(){

            public void buttonClick(Button.ClickEvent event) {
                SurveillanceViewConfigurationCategoryWindow.this.close();
            }
        });
        cancel.setClickShortcut(27, null);
        horizontalLayout.addComponent((Component)cancel);
        horizontalLayout.setExpandRatio((Component)cancel, 1.0f);
        horizontalLayout.setComponentAlignment((Component)cancel, Alignment.TOP_RIGHT);
        Button ok = new Button("Save");
        ok.setDescription("Save properties and close");
        ok.addClickListener(new Button.ClickListener(){

            public void buttonClick(Button.ClickEvent event) {
                Def finalDef = null;
                if (def instanceof RowDef) {
                    finalDef = new RowDef();
                }
                if (def instanceof ColumnDef) {
                    finalDef = new ColumnDef();
                }
                Set categories = (Set)categoriesTable.getValue();
                if (!labelField.isValid()) {
                    ((SurveillanceViewsConfigUI)SurveillanceViewConfigurationCategoryWindow.this.getUI()).notifyMessage("Error", "Please use an unique label for this category", Notification.Type.ERROR_MESSAGE);
                    return;
                }
                if (categories.isEmpty()) {
                    ((SurveillanceViewsConfigUI)SurveillanceViewConfigurationCategoryWindow.this.getUI()).notifyMessage("Error", "You must choose at least one surveillance category", Notification.Type.ERROR_MESSAGE);
                    return;
                }
                for (Object object : categories) {
                    Category category = new Category();
                    category.setName(((OnmsCategory)categoriesMap.get(object)).getName());
                    finalDef.getCategories().add(category);
                }
                finalDef.setLabel((String)labelField.getValue());
                saveActionListener.save(finalDef);
                SurveillanceViewConfigurationCategoryWindow.this.close();
            }
        });
        ok.setClickShortcut(13, null);
        horizontalLayout.addComponent((Component)ok);
        verticalLayout.addComponent((Component)horizontalLayout);
        this.setContent((Component)verticalLayout);
    }

    public static interface SaveActionListener {
        public void save(Def var1);
    }
}

