/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.vaadin.surveillanceviews.model;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import org.opennms.features.vaadin.surveillanceviews.model.Category;
import org.opennms.features.vaadin.surveillanceviews.model.Def;

public class RowDef
implements Def {
    private String m_label = "default";
    private String m_reportCategory;
    private List<Category> m_categories = new LinkedList<Category>();

    @Override
    @XmlAttribute(name="label", required=true)
    public String getLabel() {
        return this.m_label;
    }

    @Override
    public void setLabel(String label) {
        this.m_label = label;
    }

    @Override
    @XmlAttribute(name="report-category", required=false)
    public String getReportCategory() {
        return this.m_reportCategory;
    }

    @Override
    public void setReportCategory(String reportCategory) {
        this.m_reportCategory = reportCategory;
    }

    @Override
    @XmlElement(name="category")
    public List<Category> getCategories() {
        return this.m_categories;
    }

    @Override
    public Set<String> getCategoryNames() {
        HashSet<String> listOfNames = new HashSet<String>();
        for (Category category : this.getCategories()) {
            listOfNames.add(category.getName());
        }
        return listOfNames;
    }

    @Override
    public boolean containsCategory(String name) {
        for (Category category : this.getCategories()) {
            if (!name.equals(category.getName())) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RowDef rowDef = (RowDef)o;
        if (this.m_categories != null ? !this.m_categories.equals(rowDef.m_categories) : rowDef.m_categories != null) {
            return false;
        }
        if (this.m_label != null ? !this.m_label.equals(rowDef.m_label) : rowDef.m_label != null) {
            return false;
        }
        return !(this.m_reportCategory != null ? !this.m_reportCategory.equals(rowDef.m_reportCategory) : rowDef.m_reportCategory != null);
    }

    public int hashCode() {
        int result = this.m_label != null ? this.m_label.hashCode() : 0;
        result = 31 * result + (this.m_reportCategory != null ? this.m_reportCategory.hashCode() : 0);
        result = 31 * result + (this.m_categories != null ? this.m_categories.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "RowDef [label=" + this.m_label + ", reportCategory=" + this.m_reportCategory + ", categories=" + this.m_categories + "]";
    }
}

