/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.vaadin.nodemaps.internal;

import com.vaadin.annotations.JavaScript;
import com.vaadin.annotations.StyleSheet;
import com.vaadin.annotations.Theme;
import com.vaadin.annotations.Title;
import com.vaadin.event.UIEvents;
import com.vaadin.server.Sizeable;
import com.vaadin.server.VaadinRequest;
import com.vaadin.server.VaadinServletRequest;
import com.vaadin.ui.AbsoluteLayout;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Component;
import com.vaadin.ui.CustomLayout;
import com.vaadin.ui.TabSheet;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalSplitPanel;
import com.vaadin.v7.ui.HorizontalLayout;
import com.vaadin.v7.ui.VerticalLayout;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.opennms.core.sysprops.SystemProperties;
import org.opennms.features.topology.api.HasExtraComponents;
import org.opennms.features.topology.api.HeaderUtil;
import org.opennms.features.topology.api.VerticesUpdateManager;
import org.opennms.features.topology.api.browsers.SelectionAwareTable;
import org.opennms.features.topology.api.browsers.SelectionChangedListener;
import org.opennms.features.topology.api.topo.VertexRef;
import org.opennms.features.topology.plugins.browsers.AlarmTable;
import org.opennms.features.topology.plugins.browsers.NodeTable;
import org.opennms.features.vaadin.nodemaps.internal.InvalidConfigurationWindow;
import org.opennms.features.vaadin.nodemaps.internal.NodeMapComponent;
import org.opennms.features.vaadin.nodemaps.internal.NodeMapConfiguration;
import org.opennms.osgi.EventProxy;
import org.opennms.osgi.VaadinApplicationContext;
import org.opennms.osgi.VaadinApplicationContextImpl;
import org.opennms.web.api.OnmsHeaderProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

@Title(value="OpenNMS Node Maps")
@Theme(value="opennms")
@JavaScript(value={"theme://../opennms/assets/node-maps-init.vaadin.js"})
@StyleSheet(value={"theme://../opennms/assets/leaflet.css", "gwt/public/node-maps.css"})
public class NodeMapsApplication
extends UI {
    private static final Logger LOG = LoggerFactory.getLogger(NodeMapsApplication.class);
    private static final int REFRESH_INTERVAL = SystemProperties.getInteger((String)"org.opennms.features.nodemaps.refresh", (int)30000);
    private VerticalLayout m_rootLayout;
    private VerticalLayout m_layout;
    private NodeMapComponent m_nodeMapComponent;
    private OnmsHeaderProvider m_headerProvider;
    private String m_headerHtml;
    private VaadinRequest m_request;
    private AlarmTable m_alarmTable;
    private NodeTable m_nodeTable;
    private NodeMapConfiguration configuration;

    public void setHeaderProvider(OnmsHeaderProvider headerProvider) {
        this.m_headerProvider = headerProvider;
    }

    public void setNodeMapComponent(NodeMapComponent nodeMapComponent) {
        this.m_nodeMapComponent = nodeMapComponent;
    }

    public void setHeaderHtml(String headerHtml) {
        this.m_headerHtml = headerHtml;
    }

    public void setAlarmTable(AlarmTable table) {
        this.m_alarmTable = table;
    }

    public void setNodeTable(NodeTable table) {
        this.m_nodeTable = table;
    }

    private void updateWidgetView() {
        VerticalSplitPanel bottomLayoutBar = new VerticalSplitPanel();
        bottomLayoutBar.setFirstComponent((Component)this.m_nodeMapComponent);
        bottomLayoutBar.setSplitPosition(70.0f, Sizeable.Unit.PERCENTAGE);
        bottomLayoutBar.setSizeFull();
        bottomLayoutBar.setSecondComponent(this.getTabSheet());
        this.m_layout.addComponent((Component)bottomLayoutBar);
        this.m_layout.markAsDirty();
    }

    private Component getTabSheet() {
        AbsoluteLayout bottomLayout = new AbsoluteLayout();
        bottomLayout.setSizeFull();
        final TabSheet tabSheet = new TabSheet();
        tabSheet.setSizeFull();
        for (final SelectionAwareTable view : new SelectionAwareTable[]{this.m_alarmTable, this.m_nodeTable}) {
            tabSheet.addTab((Component)view, view == this.m_alarmTable ? "Alarms" : "Nodes", null);
            try {
                Component[] extras = ((HasExtraComponents)view).getExtraComponents();
                if (extras != null && extras.length > 0) {
                    final HorizontalLayout extraControls = new HorizontalLayout();
                    extraControls.setHeight(32.0f, Sizeable.Unit.PIXELS);
                    extraControls.setSpacing(true);
                    for (Component component : extras) {
                        extraControls.addComponent(component);
                        extraControls.setComponentAlignment(component, Alignment.MIDDLE_RIGHT);
                    }
                    tabSheet.addSelectedTabChangeListener(new TabSheet.SelectedTabChangeListener(){

                        public void selectedTabChange(TabSheet.SelectedTabChangeEvent event) {
                            TabSheet source = (TabSheet)event.getSource();
                            if (source == tabSheet) {
                                if (source.getSelectedTab() == view) {
                                    extraControls.setVisible(true);
                                } else {
                                    extraControls.setVisible(false);
                                }
                            }
                        }
                    });
                    bottomLayout.addComponent((Component)extraControls, "top:0px;right:5px;z-index:100");
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
            view.setSizeFull();
        }
        bottomLayout.addComponent((Component)tabSheet, "top: 0; left: 0; bottom: 0; right: 0;");
        return bottomLayout;
    }

    protected void init(VaadinRequest vaadinRequest) {
        this.m_request = vaadinRequest;
        LOG.debug("initializing");
        VaadinApplicationContextImpl context = new VaadinApplicationContextImpl();
        UI currentUI = UI.getCurrent();
        context.setSessionId(currentUI.getSession().getSession().getId());
        context.setUiId(currentUI.getUIId());
        context.setUsername(vaadinRequest.getRemoteUser());
        Assert.notNull((Object)this.m_alarmTable);
        Assert.notNull((Object)this.m_nodeTable);
        String searchString = vaadinRequest.getParameter("search");
        Integer maxClusterRadius = SystemProperties.getInteger((String)"gwt.maxClusterRadius", (int)350);
        LOG.info("Starting search string: {}, max cluster radius: {}", (Object)searchString, (Object)maxClusterRadius);
        this.m_alarmTable.setVaadinApplicationContext((VaadinApplicationContext)context);
        EventProxy eventProxy = new EventProxy(){

            public <T> void fireEvent(T eventObject) {
                LOG.debug("got event: {}", eventObject);
                if (eventObject instanceof VerticesUpdateManager.VerticesUpdateEvent) {
                    VerticesUpdateManager.VerticesUpdateEvent event = (VerticesUpdateManager.VerticesUpdateEvent)eventObject;
                    ArrayList<Integer> nodeIds = new ArrayList<Integer>();
                    for (VertexRef ref : event.getVertexRefs()) {
                        if (!"nodes".equals(ref.getNamespace()) || ref.getId() == null) continue;
                        nodeIds.add(Integer.valueOf(ref.getId()));
                    }
                    NodeMapsApplication.this.m_nodeMapComponent.setSelectedNodes(nodeIds);
                    return;
                }
                LOG.warn("Unsure how to deal with event: {}", eventObject);
            }

            public <T> void addPossibleEventConsumer(T possibleEventConsumer) {
                LOG.debug("(ignoring) add consumer: {}", possibleEventConsumer);
            }
        };
        this.m_alarmTable.setEventProxy(eventProxy);
        this.m_nodeTable.setEventProxy(eventProxy);
        this.createMapPanel(searchString, maxClusterRadius);
        this.createRootLayout();
        this.setupAutoRefresher();
        if (!this.configuration.isValid()) {
            new InvalidConfigurationWindow(this.configuration).open();
        }
    }

    public void setConfiguration(NodeMapConfiguration configuration) {
        this.configuration = configuration;
    }

    private void createMapPanel(String searchString, int maxClusterRadius) {
        this.m_nodeMapComponent.setSearchString(searchString);
        this.m_nodeMapComponent.setSizeFull();
        this.m_nodeMapComponent.setMaxClusterRadius(maxClusterRadius);
    }

    private void createRootLayout() {
        this.m_rootLayout = new VerticalLayout();
        this.m_rootLayout.setSizeFull();
        this.m_rootLayout.addStyleName("root-layout");
        this.setContent((Component)this.m_rootLayout);
        this.addHeader();
        this.addContentLayout();
    }

    private void addContentLayout() {
        this.m_layout = new VerticalLayout();
        this.m_layout.setSizeFull();
        this.m_rootLayout.addComponent((Component)this.m_layout);
        this.m_rootLayout.setExpandRatio((Component)this.m_layout, 1.0f);
        this.updateWidgetView();
    }

    private void addHeader() {
        if (this.m_headerProvider != null) {
            try {
                this.setHeaderHtml(this.getHeader(((VaadinServletRequest)this.m_request).getHttpServletRequest()));
            }
            catch (Exception e) {
                LOG.error("failed to get header HTML for request " + this.m_request.getPathInfo(), (Throwable)e);
            }
        }
        if (this.m_headerHtml != null) {
            ByteArrayInputStream is = null;
            try {
                is = new ByteArrayInputStream(this.m_headerHtml.getBytes());
                CustomLayout headerLayout = new CustomLayout((InputStream)is);
                headerLayout.setWidth("100%");
                headerLayout.addStyleName("onmsheader");
                headerLayout.addAttachListener(HeaderUtil.getAttachListener());
                this.m_rootLayout.addComponent((Component)headerLayout);
            }
            catch (IOException e) {
                this.closeQuietly(is);
                LOG.debug("failed to get header layout data", (Throwable)e);
            }
        }
    }

    private String getHeader(HttpServletRequest request) throws Exception {
        if (this.m_headerProvider == null) {
            return "";
        }
        return this.m_headerProvider.getHeaderHtml(request);
    }

    private void closeQuietly(InputStream is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException closeE) {
                LOG.debug("failed to close HTML input stream", (Throwable)closeE);
            }
        }
    }

    public void setupAutoRefresher() {
        this.setPollInterval(REFRESH_INTERVAL);
        this.addPollListener((UIEvents.PollListener & Serializable)event -> this.m_nodeMapComponent.refresh());
    }

    public void refresh() {
        this.m_nodeMapComponent.refresh();
    }

    public void setFocusedNodes(List<Integer> nodeIds) {
        this.m_alarmTable.selectionChanged((SelectionChangedListener.Selection)new SelectionChangedListener.AlarmNodeIdSelection(nodeIds));
        this.m_nodeTable.selectionChanged((SelectionChangedListener.Selection)new SelectionChangedListener.IdSelection(nodeIds));
        this.m_alarmTable.refreshRowCache();
        this.m_nodeTable.refreshRowCache();
    }

    public String toString() {
        return "NodeMapsApplication@" + this.hashCode();
    }
}

