/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.vaadin.nodemaps.internal.gwt.client.ui;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.shared.HasHandlers;
import com.google.gwt.user.client.ui.Widget;
import com.vaadin.client.ServerConnector;
import com.vaadin.client.communication.RpcProxy;
import com.vaadin.client.communication.StateChangeEvent;
import com.vaadin.client.ui.AbstractComponentConnector;
import com.vaadin.shared.ui.Connect;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.discotools.gwt.leaflet.client.types.Icon;
import org.discotools.gwt.leaflet.client.types.IconOptions;
import org.discotools.gwt.leaflet.client.types.LatLng;
import org.discotools.gwt.leaflet.client.types.Point;
import org.opennms.features.vaadin.nodemaps.internal.NodeMapComponent;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.JSNodeMarker;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.MapNode;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.NodeMapState;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.OpenNMSEventManager;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.event.NodeMarkerClusterCallback;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.event.SearchStringSetEvent;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.ui.NodeIdSelectionRpc;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.ui.NodeMapWidget;

@Connect(value=NodeMapComponent.class)
public class NodeMapConnector
extends AbstractComponentConnector
implements HasHandlers {
    private static final long serialVersionUID = 5000748508667861638L;
    private Logger LOG = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    private Map<String, Icon> m_icons;
    private NodeIdSelectionRpc m_rpc = (NodeIdSelectionRpc)RpcProxy.create(NodeIdSelectionRpc.class, (ServerConnector)this);
    private int m_maxClusterRadius;

    public NodeMapConnector() {
        this.initializeIcons();
    }

    private static final native boolean isRetina();

    public void onStateChanged(StateChangeEvent stateChangeEvent) {
        this.LOG.info("NodeMapConnector.onStateChanged(" + stateChangeEvent + ")");
        super.onStateChanged(stateChangeEvent);
        if (stateChangeEvent.hasPropertyChanged("maxClusterRadius")) {
            this.getWidget().setMaxClusterRadius(this.getState().maxClusterRadius);
        }
        if (stateChangeEvent.hasPropertyChanged("searchString")) {
            String searchString = this.getState().searchString;
            this.LOG.info("NodeMapConnector.onStateChanged(): searchString is now: " + searchString);
            if (searchString == null) {
                this.getEventManager().fireEvent(new SearchStringSetEvent(""));
            } else {
                this.getEventManager().fireEvent(new SearchStringSetEvent(searchString));
            }
        }
        if (stateChangeEvent.hasPropertyChanged("nodes")) {
            this.updateNodes();
        }
        if (stateChangeEvent.hasPropertyChanged("nodeIds")) {
            List<Integer> nodeIds = this.getState().nodeIds;
            this.LOG.info("NodeMapConnector.onStateChanged(): nodeIds is now: " + nodeIds);
            if (nodeIds != null && nodeIds.size() > 0) {
                StringBuilder sb = new StringBuilder("nodeId in ");
                Iterator<Integer> i = nodeIds.iterator();
                while (i.hasNext()) {
                    sb.append(i.next());
                    if (!i.hasNext()) continue;
                    sb.append(", ");
                }
                this.getEventManager().fireEvent(new SearchStringSetEvent(sb.toString()));
            }
        }
        if (stateChangeEvent.hasPropertyChanged("groupByState")) {
            this.getWidget().setGroupByState(this.getState().groupByState);
        }
        if (!this.getWidget().isInitialized() && stateChangeEvent.hasPropertyChanged("tileServerUrl") && stateChangeEvent.hasPropertyChanged("tileLayerOptions")) {
            this.getWidget().initialize(this.getState());
        }
    }

    private void updateNodes() {
        List<MapNode> nodes = this.getState().nodes;
        this.LOG.info("NodeMapConnector.onStateChanged(): nodes list is now: " + nodes);
        ArrayList<JSNodeMarker> featureCollection = new ArrayList<JSNodeMarker>();
        if (nodes.isEmpty()) {
            this.getWidget().setMarkers(featureCollection);
            return;
        }
        for (MapNode node : nodes) {
            JSNodeMarker marker = new JSNodeMarker(new LatLng(node.getLatitude(), node.getLongitude()));
            marker.putProperty("nodeId", node.getNodeId());
            marker.putProperty("nodeLabel", node.getNodeLabel());
            marker.putProperty("foreignSource", node.getForeignSource());
            marker.putProperty("foreignId", node.getForeignId());
            marker.putProperty("description", node.getDescription());
            marker.putProperty("maintcontract", node.getMaintcontract());
            marker.putProperty("ipAddress", node.getIpAddress());
            marker.putProperty("severity", node.getSeverity());
            marker.putProperty("severityLabel", node.getSeverityLabel());
            List<String> categories = node.getCategories();
            if (categories != null) {
                marker.setCategories(categories.toArray(new String[0]));
            }
            if (this.m_icons.containsKey(marker.getSeverityLabel())) {
                marker.setIcon(this.m_icons.get(marker.getSeverityLabel()));
            } else {
                marker.setIcon(this.m_icons.get("Normal"));
            }
            marker.bindPopup(NodeMarkerClusterCallback.getPopupTextForMarker(marker));
            featureCollection.add(marker);
        }
        this.getWidget().setMarkers(featureCollection);
        this.getConnection().getLoadingIndicator().hide();
    }

    public NodeMapState getState() {
        return (NodeMapState)super.getState();
    }

    protected Widget createWidget() {
        NodeMapWidget widget = (NodeMapWidget)GWT.create(NodeMapWidget.class);
        widget.setRpc(this.m_rpc);
        return widget;
    }

    public NodeMapWidget getWidget() {
        return (NodeMapWidget)super.getWidget();
    }

    private void initializeIcons() {
        if (this.m_icons == null) {
            this.m_icons = new HashMap<String, Icon>();
            for (String severity : new String[]{"Normal", "Warning", "Minor", "Major", "Critical"}) {
                IconOptions options = new IconOptions();
                options.setIconSize(new Point(25.0, 41.0));
                options.setIconAnchor(new Point(12.0, 41.0));
                options.setPopupAnchor(new Point(1.0, -34.0));
                options.setShadowUrl(new Point(41.0, 41.0));
                String basePath = GWT.getModuleBaseForStaticFiles() + "images/";
                if (NodeMapConnector.isRetina()) {
                    options.setIconUrl(basePath + severity + "@2x.png");
                } else {
                    options.setIconUrl(basePath + severity + ".png");
                }
                Icon icon = new Icon(options);
                this.m_icons.put(severity, icon);
            }
        }
    }

    private OpenNMSEventManager getEventManager() {
        return this.getWidget().getEventManager();
    }
}

