/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.vaadin.nodemaps.internal.gwt.client.ui.controls.search;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.NativeEvent;
import java.util.logging.Logger;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.OpenNMSEventManager;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.event.ComponentInitializedEvent;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.event.SearchStringSetEvent;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.ui.controls.search.ValueItem;

public abstract class SearchStateManager {
    private static final Logger LOG = Logger.getLogger(SearchStateManager.class.getName());
    private SearchState m_state;
    private ValueItem m_valueItem;
    private ValueItem m_history;
    private OpenNMSEventManager m_eventManager;

    public SearchStateManager(ValueItem valueItem, ValueItem history, OpenNMSEventManager eventManager) {
        this.m_valueItem = valueItem;
        this.m_history = history;
        this.m_eventManager = eventManager;
        String valueSearchString = this.m_valueItem.getValue();
        String historySearchString = this.getHistorySearchString();
        if (historySearchString != null) {
            this.m_valueItem.setValue(historySearchString);
            this.m_state = State.SEARCHING_FINISHED;
        } else {
            this.m_state = valueSearchString != null && !"".equals(valueSearchString) ? State.SEARCHING_FINISHED : State.NOT_SEARCHING;
        }
        this.m_state.initialize(this);
        this.m_eventManager.fireEvent(new ComponentInitializedEvent(SearchStateManager.class.getName()));
    }

    SearchState getState() {
        return this.m_state;
    }

    protected ValueItem getValueItem() {
        return this.m_valueItem;
    }

    public void updateMatchCount(int matchCount) {
        this.m_state = this.m_state.updateMatchCount(this, matchCount);
    }

    public boolean handleAutocompleteEvent(NativeEvent event) {
        String eventType = event.getType();
        int eventKeyCode = event.getKeyCode();
        LOG.info("handleAutocompleteEvent(" + this.m_state + "): received " + eventType + " (keyCode = " + eventKeyCode + ")");
        if ("keydown".equals(eventType)) {
            switch (eventKeyCode) {
                case 27: {
                    Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                        public void execute() {
                            SearchStateManager.this.m_state = SearchStateManager.this.m_state.cancelSearching(SearchStateManager.this);
                        }
                    });
                    event.stopPropagation();
                    break;
                }
                case 13: {
                    Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                        public void execute() {
                            SearchStateManager.this.m_state = SearchStateManager.this.m_state.currentEntrySelected(SearchStateManager.this);
                        }
                    });
                    event.stopPropagation();
                }
            }
        } else {
            if ("click".equals(eventType) || "touchstart".equals(eventType)) {
                Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                    public void execute() {
                        SearchStateManager.this.m_state = SearchStateManager.this.m_state.currentEntrySelected(SearchStateManager.this);
                    }
                });
                event.stopPropagation();
                return true;
            }
            LOG.info("handleAutocompleteEvent(" + this.m_state + "): unhandled event: " + eventType);
            return true;
        }
        return false;
    }

    public void handleSearchIconEvent(NativeEvent event) {
        String eventType = event.getType();
        LOG.info("handleSearchIconEvent(" + this.m_state + "): received " + eventType + " (keyCode = " + event.getKeyCode() + ")");
        if ("click".equals(eventType) || "touchstart".equals(eventType)) {
            Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                public void execute() {
                    SearchStateManager.this.m_state = SearchStateManager.this.m_state.finishedSearching(SearchStateManager.this);
                }
            });
        } else {
            LOG.info("handleSearchIconEvent(" + this.m_state + "): unhandled event: " + eventType);
        }
    }

    public void handleInputEvent(NativeEvent event) {
        String eventType = event.getType();
        LOG.info("handleInputEvent(" + this.m_state + "): received " + eventType + " (keyCode = " + event.getKeyCode() + ")");
        if ("keydown".equals(eventType)) {
            switch (event.getKeyCode()) {
                case 27: {
                    Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                        public void execute() {
                            SearchStateManager.this.m_state = SearchStateManager.this.m_state.cancelSearching(SearchStateManager.this);
                        }
                    });
                    event.stopPropagation();
                    break;
                }
                case 40: {
                    Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                        public void execute() {
                            SearchStateManager.this.m_state = SearchStateManager.this.m_state.goDown(SearchStateManager.this);
                        }
                    });
                    event.stopPropagation();
                    break;
                }
                case 13: {
                    Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                        public void execute() {
                            SearchStateManager.this.m_state = SearchStateManager.this.m_state.finishedSearching(SearchStateManager.this);
                        }
                    });
                    event.stopPropagation();
                    break;
                }
                default: {
                    Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                        public void execute() {
                            String value = SearchStateManager.this.m_valueItem.getValue();
                            if (value == null || "".equals(value)) {
                                SearchStateManager.this.m_state = SearchStateManager.this.m_state.cancelSearching(SearchStateManager.this);
                            } else {
                                SearchStateManager.this.m_state = SearchStateManager.this.m_state.searchInputReceived(SearchStateManager.this);
                                SearchStateManager.this.sendSearchStringSetEvent(value);
                            }
                        }
                    });
                    break;
                }
            }
        } else if ("search".equals(eventType) || "change".equals(eventType)) {
            final String searchString = this.m_valueItem.getValue();
            LOG.info("SearchStateManager.handleInputEvent(): searchString = " + searchString);
            if ("".equals(searchString)) {
                Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                    public void execute() {
                        SearchStateManager.this.m_state = SearchStateManager.this.m_state.cancelSearching(SearchStateManager.this);
                    }
                });
            } else {
                Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                    public void execute() {
                        if (searchString == null || "".equals(searchString)) {
                            SearchStateManager.this.m_state = SearchStateManager.this.m_state.cancelSearching(SearchStateManager.this);
                        } else {
                            SearchStateManager.this.m_state = SearchStateManager.this.m_state.searchInputReceived(SearchStateManager.this);
                            SearchStateManager.this.sendSearchStringSetEvent(searchString);
                        }
                    }
                });
            }
        } else {
            LOG.info("SearchStateManager.handleInputEvent(" + this.m_state + "): unhandled event: " + eventType);
        }
    }

    protected void sendSearchStringSetEvent(String value) {
        this.m_eventManager.fireEvent(new SearchStringSetEvent(value));
    }

    public void reset() {
        this.m_state = this.m_state.cancelSearching(this);
    }

    private String getHistorySearchString() {
        String value = this.m_history.getValue();
        if (value != null && value.startsWith("search/")) {
            return value.replaceFirst("^search\\/", "");
        }
        return null;
    }

    protected void updateHistorySearchString() {
        String newToken;
        String token = this.m_history.getValue();
        String value = this.m_valueItem.getValue();
        String string = newToken = value == null || "".equals(value) ? "" : "search/" + value;
        if (!newToken.equals(token)) {
            this.m_history.setValue(newToken);
        }
    }

    public abstract void refresh();

    public abstract void entrySelected();

    public abstract void clearSearchInput();

    public abstract void focusInput();

    public abstract void focusAutocompleteWidget();

    public abstract void showAutocomplete();

    public abstract void hideAutocomplete();

    static enum State implements SearchState
    {
        NOT_SEARCHING{

            @Override
            public SearchState initialize(SearchStateManager manager) {
                manager.hideAutocomplete();
                manager.focusInput();
                return this;
            }

            @Override
            public SearchState cancelSearching(SearchStateManager manager) {
                manager.clearSearchInput();
                manager.focusInput();
                return this;
            }

            @Override
            public SearchState goDown(SearchStateManager manager) {
                LOG.info("WARNING: attempting to go down, but we're not searching!");
                return this;
            }

            @Override
            public SearchState goUp(SearchStateManager manager) {
                LOG.info("WARNING: attempting to go up, but we're not searching!");
                return this;
            }

            @Override
            public SearchState searchInputReceived(SearchStateManager manager) {
                manager.refresh();
                manager.showAutocomplete();
                return SEARCHING_AUTOCOMPLETE_VISIBLE;
            }

            @Override
            public SearchState finishedSearching(SearchStateManager manager) {
                LOG.info("WARNING: attempting to finish, but we're not searching!");
                return this;
            }

            @Override
            public SearchState currentEntrySelected(SearchStateManager manager) {
                LOG.info("WARNING: attempting to finish, but we're not searching!");
                return this;
            }

            @Override
            public SearchState updateMatchCount(SearchStateManager manager, int matchCount) {
                LOG.info("WARNING: match count updated, but we're not searching!");
                return this;
            }
        }
        ,
        SEARCHING_AUTOCOMPLETE_VISIBLE{

            @Override
            public SearchState initialize(SearchStateManager manager) {
                manager.showAutocomplete();
                manager.focusInput();
                manager.refresh();
                return this;
            }

            @Override
            public SearchState cancelSearching(SearchStateManager manager) {
                manager.hideAutocomplete();
                manager.clearSearchInput();
                manager.updateHistorySearchString();
                manager.refresh();
                return NOT_SEARCHING;
            }

            @Override
            public SearchState goDown(SearchStateManager manager) {
                manager.focusAutocompleteWidget();
                return SEARCHING_AUTOCOMPLETE_ACTIVE;
            }

            @Override
            public SearchState goUp(SearchStateManager manager) {
                manager.focusAutocompleteWidget();
                return SEARCHING_AUTOCOMPLETE_VISIBLE;
            }

            @Override
            public SearchState searchInputReceived(SearchStateManager manager) {
                manager.refresh();
                return this;
            }

            @Override
            public SearchState finishedSearching(SearchStateManager manager) {
                manager.hideAutocomplete();
                manager.updateHistorySearchString();
                manager.refresh();
                return SEARCHING_FINISHED;
            }

            @Override
            public SearchState currentEntrySelected(SearchStateManager manager) {
                manager.entrySelected();
                manager.hideAutocomplete();
                manager.updateHistorySearchString();
                manager.refresh();
                return SEARCHING_FINISHED;
            }

            @Override
            public SearchState updateMatchCount(SearchStateManager manager, int matchCount) {
                if (matchCount == 0) {
                    manager.hideAutocomplete();
                    return SEARCHING_AUTOCOMPLETE_HIDDEN;
                }
                return this;
            }
        }
        ,
        SEARCHING_AUTOCOMPLETE_ACTIVE{

            @Override
            public SearchState initialize(SearchStateManager manager) {
                manager.showAutocomplete();
                manager.focusAutocompleteWidget();
                manager.refresh();
                return this;
            }

            @Override
            public SearchState cancelSearching(SearchStateManager manager) {
                manager.hideAutocomplete();
                manager.clearSearchInput();
                manager.updateHistorySearchString();
                manager.refresh();
                return NOT_SEARCHING;
            }

            @Override
            public SearchState finishedSearching(SearchStateManager manager) {
                manager.hideAutocomplete();
                manager.focusInput();
                manager.updateHistorySearchString();
                manager.refresh();
                return SEARCHING_FINISHED;
            }

            @Override
            public SearchState searchInputReceived(SearchStateManager manager) {
                manager.focusInput();
                return SEARCHING_AUTOCOMPLETE_VISIBLE.searchInputReceived(manager);
            }

            @Override
            public SearchState goDown(SearchStateManager manager) {
                LOG.warning("Somehow we got a \"down\" event, but the autocomplete listbox should be handling this.  Weird.");
                return this;
            }

            @Override
            public SearchState goUp(SearchStateManager manager) {
                LOG.warning("Somehow we got an \"up\" event, but the autocomplete listbox should be handling this.  Weird.");
                return this;
            }

            @Override
            public SearchState currentEntrySelected(SearchStateManager manager) {
                LOG.info("currentEntrySelected()");
                manager.entrySelected();
                manager.hideAutocomplete();
                manager.focusInput();
                manager.updateHistorySearchString();
                manager.refresh();
                return SEARCHING_FINISHED;
            }

            @Override
            public SearchState updateMatchCount(SearchStateManager manager, int matchCount) {
                if (matchCount == 0) {
                    manager.hideAutocomplete();
                    return SEARCHING_AUTOCOMPLETE_HIDDEN;
                }
                return this;
            }
        }
        ,
        SEARCHING_AUTOCOMPLETE_HIDDEN{

            @Override
            public SearchState initialize(SearchStateManager manager) {
                manager.focusInput();
                manager.hideAutocomplete();
                manager.refresh();
                return this;
            }

            @Override
            public SearchState cancelSearching(SearchStateManager manager) {
                manager.clearSearchInput();
                manager.focusInput();
                manager.updateHistorySearchString();
                manager.refresh();
                return NOT_SEARCHING;
            }

            @Override
            public SearchState finishedSearching(SearchStateManager manager) {
                manager.updateHistorySearchString();
                manager.refresh();
                return SEARCHING_FINISHED;
            }

            @Override
            public SearchState currentEntrySelected(SearchStateManager manager) {
                LOG.info("SearchStateManager.currentEntrySelected(): Current entry got selected, but there is no current entry visible!");
                return this;
            }

            @Override
            public SearchState searchInputReceived(SearchStateManager manager) {
                manager.refresh();
                return this;
            }

            @Override
            public SearchState goDown(SearchStateManager manager) {
                LOG.info("SearchStateManager.goDown(): Autocomplete is already hidden because of a previous match count update, this doesn't make sense!");
                return this;
            }

            @Override
            public SearchState goUp(SearchStateManager manager) {
                LOG.info("SearchStateManager.goUp(): Autocomplete is already hidden because of a previous match count update, this doesn't make sense!");
                return this;
            }

            @Override
            public SearchState updateMatchCount(SearchStateManager manager, int matchCount) {
                if (matchCount > 0) {
                    manager.showAutocomplete();
                    return SEARCHING_AUTOCOMPLETE_VISIBLE;
                }
                return this;
            }
        }
        ,
        SEARCHING_FINISHED{

            @Override
            public SearchState initialize(SearchStateManager manager) {
                manager.focusInput();
                manager.hideAutocomplete();
                manager.refresh();
                return this;
            }

            @Override
            public SearchState cancelSearching(SearchStateManager manager) {
                manager.clearSearchInput();
                manager.focusInput();
                manager.hideAutocomplete();
                manager.updateHistorySearchString();
                manager.refresh();
                return NOT_SEARCHING;
            }

            @Override
            public SearchState goDown(SearchStateManager manager) {
                manager.showAutocomplete();
                manager.focusAutocompleteWidget();
                manager.refresh();
                return SEARCHING_AUTOCOMPLETE_ACTIVE;
            }

            @Override
            public SearchState goUp(SearchStateManager manager) {
                LOG.warning("Somehow we got an \"up\" event, but the autocomplete listbox should be handling this.  Weird.");
                return this;
            }

            @Override
            public SearchState searchInputReceived(SearchStateManager manager) {
                manager.refresh();
                manager.showAutocomplete();
                return SEARCHING_AUTOCOMPLETE_VISIBLE;
            }

            @Override
            public SearchState finishedSearching(SearchStateManager manager) {
                LOG.info("WARNING: attempting to finish search, but we're already finished!");
                return this;
            }

            @Override
            public SearchState currentEntrySelected(SearchStateManager manager) {
                LOG.info("WARNING: attempting to select an entry, but we're already finished!");
                return this;
            }

            @Override
            public SearchState updateMatchCount(SearchStateManager manager, int matchCount) {
                return this;
            }
        };

    }

    static interface SearchState {
        public SearchState initialize(SearchStateManager var1);

        public SearchState cancelSearching(SearchStateManager var1);

        public SearchState finishedSearching(SearchStateManager var1);

        public SearchState currentEntrySelected(SearchStateManager var1);

        public SearchState searchInputReceived(SearchStateManager var1);

        public SearchState goDown(SearchStateManager var1);

        public SearchState goUp(SearchStateManager var1);

        public SearchState updateMatchCount(SearchStateManager var1, int var2);
    }
}

