/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.vaadin.nodemaps.internal.gwt.client.ui.controls.search;

import com.google.gwt.cell.client.AbstractSafeHtmlCell;
import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.ValueUpdater;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.DomEvent;
import com.google.gwt.event.dom.client.KeyDownEvent;
import com.google.gwt.event.dom.client.KeyDownHandler;
import com.google.gwt.event.logical.shared.AttachEvent;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HasHandlers;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.text.shared.AbstractSafeHtmlRenderer;
import com.google.gwt.text.shared.SafeHtmlRenderer;
import com.google.gwt.user.cellview.client.CellList;
import com.google.gwt.user.cellview.client.HasKeyboardSelectionPolicy;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.ui.AbsolutePanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.SingleSelectionModel;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.JSNodeMarker;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.NodeMarker;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.OpenNMSEventManager;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.event.ComponentInitializedEvent;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.event.CutEvent;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.event.FilteredMarkersUpdatedEvent;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.event.FilteredMarkersUpdatedEventHandler;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.event.PasteEvent;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.event.SearchEvent;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.event.SearchEventHandler;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.event.SearchStringSetEvent;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.event.SearchStringSetEventHandler;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.ui.MarkerContainer;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.ui.controls.alarm.AlarmControl;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.ui.controls.search.SearchStateManager;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.ui.controls.search.SearchTextBox;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.ui.controls.search.ValueItem;
import org.opennms.features.vaadin.nodemaps.internal.gwt.shared.Util;

public class SearchControl
extends AbsolutePanel
implements FilteredMarkersUpdatedEventHandler,
SearchStringSetEventHandler {
    private Logger LOG = Logger.getLogger(this.getClass().getName());
    private static final HashMap<String, String> m_labels = new HashMap();
    private SearchTextBox m_inputBox;
    private HistoryWrapper m_historyWrapper;
    private MarkerContainer m_markerContainer;
    private CellList<NodeMarker> m_autoComplete;
    private SearchStateManager m_stateManager;
    private SingleSelectionModel<NodeMarker> m_selectionModel;
    private Set<Widget> m_updated = new HashSet<Widget>();
    private OpenNMSEventManager m_eventManager;

    public SearchControl(MarkerContainer markerContainer, Widget root, OpenNMSEventManager eventManager) {
        this.LOG.info("new SearchControl()");
        this.m_eventManager = eventManager;
        this.m_markerContainer = markerContainer;
        this.m_selectionModel = new SingleSelectionModel();
        this.m_historyWrapper = new HistoryWrapper();
        this.initializeContainerWidget();
        this.initializeInputWidget();
        this.initializeCellAutocompleteWidget();
        this.initializeSearchStateManager();
        this.addAttachHandler(new AttachEvent.Handler(){

            public void onAttachOrDetach(AttachEvent event) {
                if (event.isAttached()) {
                    SearchControl.this.doOnAdd();
                } else {
                    SearchControl.this.doOnRemove();
                }
            }
        });
    }

    public com.google.gwt.user.client.Element doOnAdd() {
        this.LOG.info("SearchControl.onAdd() called");
        this.add((Widget)this.m_inputBox);
        this.add((Widget)this.m_autoComplete);
        this.m_eventManager.addHandler(SearchStringSetEvent.TYPE, this);
        this.m_eventManager.addHandler(FilteredMarkersUpdatedEvent.TYPE, this);
        SearchEventHandler searchEventHandler = new SearchEventHandler(){

            @Override
            protected void onEvent(DomEvent<? extends EventHandler> event) {
                SearchControl.this.m_stateManager.handleInputEvent(event.getNativeEvent());
            }
        };
        this.m_autoComplete.addHandler((EventHandler)new KeyDownHandler(){

            public void onKeyDown(KeyDownEvent event) {
                SearchControl.this.m_stateManager.handleAutocompleteEvent(event.getNativeEvent());
            }
        }, (GwtEvent.Type)KeyDownEvent.getType());
        this.m_inputBox.addKeyDownHandler(searchEventHandler);
        this.m_inputBox.addChangeHandler(searchEventHandler);
        this.m_inputBox.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                SearchEvent.fireNativeEvent((NativeEvent)Document.get().createChangeEvent(), (HasHandlers)SearchControl.this.m_inputBox);
            }
        });
        this.m_inputBox.addHandler(searchEventHandler, (GwtEvent.Type)CutEvent.getType());
        this.m_inputBox.addHandler(searchEventHandler, (GwtEvent.Type)PasteEvent.getType());
        this.m_inputBox.addHandler(searchEventHandler, (GwtEvent.Type)SearchEvent.getType());
        this.m_eventManager.fireEvent(new ComponentInitializedEvent(AlarmControl.class.getName()));
        return this.getElement();
    }

    public SearchControl doOnRemove() {
        this.LOG.info("SearchControl.onRemove() called");
        this.m_eventManager.removeHandler(SearchStringSetEvent.TYPE, this);
        this.m_eventManager.removeHandler(FilteredMarkersUpdatedEvent.TYPE, this);
        return this;
    }

    public void refresh() {
        this.m_autoComplete.setRowData(this.m_markerContainer.getMarkers());
    }

    protected void updateAutocompleteStyle(Widget widget) {
        if (this.m_updated.contains(widget)) {
            return;
        }
        Style style = widget.getElement().getStyle();
        style.setPosition(Style.Position.ABSOLUTE);
        style.setLeft(5.0, Style.Unit.PX);
        style.setTop(25.0, Style.Unit.PX);
        this.m_updated.add(widget);
    }

    private void initializeSearchStateManager() {
        this.m_stateManager = new SearchStateManager(this.m_inputBox, this.m_historyWrapper, this.m_eventManager){

            @Override
            public void refresh() {
                SearchControl.this.LOG.info("SearchControl.SearchStateManager.refresh()");
                this.sendSearchStringSetEvent(SearchControl.this.m_inputBox.getValue());
                List<JSNodeMarker> markers = SearchControl.this.m_markerContainer.getMarkers();
                NodeMarker selected = (NodeMarker)SearchControl.this.m_selectionModel.getSelectedObject();
                if (selected != null && markers.contains(selected)) {
                    SearchControl.this.m_selectionModel.setSelected((Object)selected, true);
                }
                this.updateMatchCount(markers.size());
                SearchControl.this.m_eventManager.fireEvent(new FilteredMarkersUpdatedEvent());
            }

            @Override
            public void clearSearchInput() {
                SearchControl.this.LOG.info("SearchControl.SearchStateManager.clearSearchInput()");
                SearchControl.this.m_inputBox.setValue("");
                this.sendSearchStringSetEvent("");
            }

            @Override
            public void focusAutocompleteWidget() {
                List<JSNodeMarker> markers;
                SearchControl.this.LOG.info("SearchControl.SearchStateManager.focusAutocomplete()");
                NodeMarker selected = (NodeMarker)SearchControl.this.m_selectionModel.getSelectedObject();
                if (selected == null && (markers = SearchControl.this.m_markerContainer.getMarkers()).size() > 0) {
                    SearchControl.this.m_selectionModel.setSelected((Object)markers.get(0), true);
                }
                SearchControl.this.m_autoComplete.setFocus(true);
            }

            @Override
            public void showAutocomplete() {
                SearchControl.this.LOG.info("SearchControl.SearchStateManager.showAutocomplete()");
                SearchControl.this.m_autoComplete.setVisible(true);
                SearchControl.this.updateAutocompleteStyle((Widget)SearchControl.this.m_autoComplete);
            }

            @Override
            public void hideAutocomplete() {
                SearchControl.this.LOG.info("SearchControl.SearchStateManager.hideAutocomplete()");
                SearchControl.this.m_autoComplete.setVisible(false);
            }

            @Override
            public void entrySelected() {
                SearchControl.this.LOG.info("SearchControl.SearchStateManager.entrySelected()");
                NodeMarker selected = (NodeMarker)SearchControl.this.m_selectionModel.getSelectedObject();
                if (selected != null) {
                    String newSearchString = "nodeLabel=" + selected.getNodeLabel();
                    SearchControl.this.m_inputBox.setValue(newSearchString);
                    SearchControl.this.m_selectionModel.setSelected((Object)selected, false);
                    SearchControl.this.m_inputBox.setFocus(true);
                    this.sendSearchStringSetEvent(newSearchString);
                } else {
                    SearchControl.this.LOG.warning("entrySelected() but nothing in the selection model.");
                }
            }

            @Override
            public void focusInput() {
                SearchControl.this.LOG.info("SearchControl.SearchStateManager.focusInput()");
                SearchControl.this.m_inputBox.setFocus(true);
            }
        };
    }

    private void setIdIfMissing(Widget widget, String id) {
        String existingId;
        if (widget.getElement() != null && ((existingId = widget.getElement().getId()) == null || "".equals(existingId))) {
            widget.getElement().setId(id);
        }
    }

    private void initializeContainerWidget() {
        this.setStylePrimaryName("leaflet-control-search");
        this.addStyleName("leaflet-control");
        this.getElement().getStyle().setOverflow(Style.Overflow.VISIBLE);
    }

    private void initializeInputWidget() {
        this.m_inputBox = new SearchTextBox();
        this.m_inputBox.addStyleName("search-input");
        this.m_inputBox.getElement().setAttribute("placeholder", "Search...");
        this.m_inputBox.getElement().setAttribute("type", "search");
        this.m_inputBox.setMaxLength(40);
        this.m_inputBox.setVisibleLength(40);
        this.m_inputBox.setValue("");
        this.setIdIfMissing((Widget)this.m_inputBox, "searchControl.searchInput");
    }

    private void initializeCellAutocompleteWidget() {
        AbstractSafeHtmlRenderer<NodeMarker> renderer = new AbstractSafeHtmlRenderer<NodeMarker>(){

            public SafeHtml render(NodeMarker marker) {
                SafeHtmlBuilder builder = new SafeHtmlBuilder();
                String search = SearchControl.this.m_inputBox.getValue();
                builder.appendHtmlConstant("<div class=\"autocomplete-label\">");
                builder.appendHtmlConstant(marker.getNodeLabel());
                builder.appendHtmlConstant("</div>");
                String additionalSearchInfo = null;
                if (search != null && (search.contains(":") || search.contains("="))) {
                    String catString;
                    String searchKey = search.replaceAll("[\\:\\=].*$", "").toLowerCase();
                    SearchControl.this.LOG.info("searchKey = " + searchKey);
                    Map<String, String> props = marker.getProperties();
                    if (("category".equals(searchKey) || "categories".equals(searchKey)) && (catString = props.get("categories")) != null) {
                        additionalSearchInfo = catString;
                    }
                    for (Map.Entry<String, String> entry : props.entrySet()) {
                        String key = entry.getKey().toLowerCase();
                        String value = entry.getValue();
                        if (!key.equals(searchKey) || !m_labels.containsKey(key)) continue;
                        additionalSearchInfo = (String)m_labels.get(key) + ": " + value;
                        break;
                    }
                }
                if (additionalSearchInfo != null) {
                    builder.appendHtmlConstant("<div class=\"autocomplete-additional-info\">").appendHtmlConstant(additionalSearchInfo).appendHtmlConstant("</div>");
                }
                return builder.toSafeHtml();
            }
        };
        AbstractSafeHtmlCell<NodeMarker> cell = new AbstractSafeHtmlCell<NodeMarker>((SafeHtmlRenderer)renderer, new String[]{"keydown", "click", "dblclick", "touchstart"}){

            public void onBrowserEvent(Cell.Context context, Element parent, NodeMarker value, NativeEvent event, ValueUpdater<NodeMarker> valueUpdater) {
                SearchControl.this.LOG.info("SearchControl.AutocompleteCell.onBrowserEvent(): context = " + context + ", parent = " + parent + ", value = " + value + ", event = " + event);
                if (SearchControl.this.m_stateManager.handleAutocompleteEvent(event)) {
                    super.onBrowserEvent(context, parent, (Object)value, event, valueUpdater);
                }
            }

            protected void render(Cell.Context context, SafeHtml data, SafeHtmlBuilder builder) {
                builder.appendHtmlConstant("<div class=\"autocomplete-entry\">");
                if (data != null) {
                    builder.append(data);
                }
                builder.appendHtmlConstant("</div>");
            }
        };
        this.m_autoComplete = new CellList((Cell)cell);
        this.m_autoComplete.setSelectionModel(this.m_selectionModel);
        this.m_autoComplete.setKeyboardSelectionPolicy(HasKeyboardSelectionPolicy.KeyboardSelectionPolicy.BOUND_TO_SELECTION);
        this.m_autoComplete.setVisible(false);
        this.m_autoComplete.addStyleName("search-autocomplete");
        this.setIdIfMissing((Widget)this.m_autoComplete, "searchControl.autoComplete");
    }

    public void replaceSearchWith(String newSearchString) {
        String existingSearchString;
        if (this.m_inputBox != null && Util.hasChanged(existingSearchString = this.m_inputBox.getValue(), newSearchString)) {
            this.LOG.info("SearchControl.replaceSearchWith(" + newSearchString + "): updated.");
            this.m_inputBox.setValue(newSearchString, false);
            return;
        }
        this.LOG.info("SearchControl.replaceSearchWith(" + newSearchString + "): unmodified.");
    }

    @Override
    public void onFilteredMarkersUpdatedEvent(FilteredMarkersUpdatedEvent event) {
        this.LOG.info("SearchControl.onFilteredMarkersUpdated()");
        this.refresh();
    }

    @Override
    public void onSearchStringSet(SearchStringSetEvent event) {
        this.replaceSearchWith(event.getSearchString());
    }

    public void focusInput() {
        this.m_inputBox.setFocus(true);
    }

    static {
        m_labels.put("nodeid", "Node&nbsp;ID");
        m_labels.put("description", "Description");
        m_labels.put("ipaddress", "IP&nbsp;Address");
        m_labels.put("maintcontract", "Maint.&nbsp;Contract");
        m_labels.put("foreignsource", "Foreign&nbsp;Source");
        m_labels.put("foreignid", "Foreign&nbsp;ID");
    }

    private class HistoryWrapper
    implements ValueItem {
        private HistoryWrapper() {
        }

        @Override
        public String getValue() {
            return History.getToken();
        }

        @Override
        public void setValue(String value) {
            History.newItem((String)value);
        }
    }
}

