/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.vaadin.nodemaps.internal.gwt.client.ui;

import com.google.gwt.regexp.shared.MatchResult;
import com.google.gwt.regexp.shared.RegExp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.NodeMarker;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.OpenNMSEventManager;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.event.AlarmSeverityUpdatedEvent;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.event.AlarmSeverityUpdatedEventHandler;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.event.ComponentInitializedEvent;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.event.FilterUpdatedEvent;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.event.SearchStringSetEvent;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.event.SearchStringSetEventHandler;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.ui.MarkerFilter;
import org.opennms.features.vaadin.nodemaps.internal.gwt.shared.Util;

public class MarkerFilterImpl
implements MarkerFilter,
AlarmSeverityUpdatedEventHandler,
SearchStringSetEventHandler {
    private static final Logger LOG = Logger.getLogger(MarkerFilterImpl.class.getName());
    private static final RegExp m_searchPattern = RegExp.compile((String)"^\\s*(.*?)\\s*( in |\\=|\\:)\\s*(.*)\\s*$");
    private OpenNMSEventManager m_eventManager;
    String m_searchString = null;
    int m_minimumSeverity = 0;

    public MarkerFilterImpl(String searchString, int minimumSeverity, OpenNMSEventManager openNMSEventManager) {
        this.m_searchString = searchString;
        this.m_minimumSeverity = minimumSeverity;
        this.m_eventManager = openNMSEventManager;
    }

    public void onLoad() {
        this.m_eventManager.addHandler(SearchStringSetEvent.TYPE, this);
        this.m_eventManager.addHandler(AlarmSeverityUpdatedEvent.TYPE, this);
        this.m_eventManager.fireEvent(new ComponentInitializedEvent(MarkerFilterImpl.class.getName()));
    }

    public void onUnload() {
        this.m_eventManager.removeHandler(AlarmSeverityUpdatedEvent.TYPE, this);
        this.m_eventManager.removeHandler(SearchStringSetEvent.TYPE, this);
    }

    public void setSearchString(String searchString) {
        if (Util.hasChanged(this.m_searchString, searchString)) {
            LOG.info("MarkerFilterImpl.setSearchString(" + searchString + "): search string modified (old = '" + this.m_searchString + "')");
            this.m_searchString = searchString;
            this.sendFilterUpdatedEvent();
        } else {
            LOG.info("MarkerFilterImpl.setSearchString(" + searchString + "): search string unmodified.");
        }
    }

    public void setMinimumSeverity(int minimumSeverity) {
        if (Util.hasChanged(this.m_minimumSeverity, minimumSeverity)) {
            LOG.info("MarkerFilterImpl.setMinimumSeverity(" + minimumSeverity + "): minimum severity modified (old = '" + this.m_minimumSeverity + "'");
            this.m_minimumSeverity = minimumSeverity;
            this.sendFilterUpdatedEvent();
        } else {
            LOG.info("MarkerFilterImpl.setMinimumSeverity(" + minimumSeverity + "): minimum severity unmodified.");
        }
    }

    void sendFilterUpdatedEvent() {
        this.m_eventManager.fireEvent(new FilterUpdatedEvent());
    }

    @Override
    public boolean matches(NodeMarker marker) {
        MarkerFilter.MatchType matchType;
        String searchProperty;
        if (marker.getSeverity() != null && marker.getSeverity() < this.m_minimumSeverity) {
            return false;
        }
        if (this.m_searchString == null || "".equals(this.m_searchString)) {
            return true;
        }
        ArrayList<String> searchFor = new ArrayList<String>();
        MatchResult m = m_searchPattern.exec(this.m_searchString);
        if (m != null) {
            searchProperty = m.getGroup(1);
            matchType = MarkerFilter.MatchType.fromToken(m.getGroup(2));
            String searchCriteria = m.getGroup(3);
            if (matchType == MarkerFilter.MatchType.IN) {
                String ignoreParens = searchCriteria.replaceAll("^\\s*\\(\\s*(.*)\\s*\\)\\s*$", "$1");
                for (String s : ignoreParens.split("\\s*,\\s*")) {
                    searchFor.add(s);
                }
            } else {
                searchFor.add(searchCriteria);
            }
        } else {
            searchProperty = null;
            matchType = MarkerFilter.MatchType.SUBSTRING;
            searchFor.add(this.m_searchString);
        }
        Map<String, String> markerProperties = marker.getProperties();
        if (searchProperty != null) {
            return this.matchProperty(matchType, searchProperty, searchFor, markerProperties);
        }
        for (String key : markerProperties.keySet()) {
            if (!this.matchProperty(matchType, key, searchFor, markerProperties)) continue;
            return true;
        }
        return false;
    }

    boolean matchProperty(MarkerFilter.MatchType matchType, String searchProperty, List<String> searchFor, Map<String, String> searchIn) {
        String lowerSearchProperty = searchProperty.toLowerCase();
        if ("category".equals(lowerSearchProperty) || "categories".equals(lowerSearchProperty)) {
            return this.matchCategory(searchIn.get("categories"), matchType, searchFor);
        }
        String value = searchIn.get(lowerSearchProperty);
        if (value == null) {
            return false;
        }
        for (String searchEntry : searchFor) {
            if (!(matchType == MarkerFilter.MatchType.EXACT || matchType == MarkerFilter.MatchType.IN ? value.toLowerCase().equals(searchEntry) : matchType == MarkerFilter.MatchType.SUBSTRING && value.toLowerCase().contains(searchEntry))) continue;
            return true;
        }
        return false;
    }

    boolean matchCategory(String categories, MarkerFilter.MatchType matchType, List<String> searchFor) {
        if (categories == null) {
            return false;
        }
        for (String category : categories.split("\\s*,\\s*")) {
            String categoryLower = category.toLowerCase();
            for (String searchEntry : searchFor) {
                if (!(matchType == MarkerFilter.MatchType.EXACT || matchType == MarkerFilter.MatchType.IN ? category.equalsIgnoreCase(searchEntry) : matchType == MarkerFilter.MatchType.SUBSTRING && categoryLower.contains(searchEntry.toLowerCase()))) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void onAlarmSeverityUpdated(AlarmSeverityUpdatedEvent event) {
        LOG.info("MarkerFilterImpl.onAlarmSeverityUpdated(" + event.getSeverity() + ")");
        this.setMinimumSeverity(event.getSeverity());
    }

    @Override
    public void onSearchStringSet(SearchStringSetEvent event) {
        LOG.info("MarkerFilterImpl.onSearchStringSet(" + event.getSearchString() + ")");
        this.setSearchString(event.getSearchString());
    }
}

