/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.vaadin.nodemaps.internal.gwt.client.event;

import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.discotools.gwt.leaflet.client.jsobject.JSObject;
import org.discotools.gwt.leaflet.client.jsobject.JSObjectWrapper;
import org.discotools.gwt.leaflet.client.types.LatLng;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.JSNodeMarker;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.SearchResults;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.ui.MarkerProvider;

public abstract class NodeMarkerSearchCallback
extends JSObjectWrapper {
    Logger logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    private MarkerProvider m_markerProvider;

    protected NodeMarkerSearchCallback(JSObject jsObject) {
        super(jsObject);
    }

    public NodeMarkerSearchCallback(MarkerProvider provider) {
        super(JSObject.createJSFunction());
        this.setJSObject(this.getCallbackFunction());
        this.m_markerProvider = provider;
    }

    public abstract Collection<JSNodeMarker> search(Collection<JSNodeMarker> var1, String var2);

    protected JSObject doSearch(String text) {
        this.logger.log(Level.INFO, "doSearch(" + text + ")");
        Collection<JSNodeMarker> markers = this.search(this.m_markerProvider.getMarkers(), text);
        this.logger.log(Level.INFO, markers.size() + " markers returned.");
        SearchResults results = SearchResults.create();
        for (JSNodeMarker marker : markers) {
            LatLng latLng = JSNodeMarker.coordinatesToLatLng(marker.getCoordinates());
            results.setProperty(marker.getNodeLabel(), latLng.getJSObject());
        }
        return results;
    }

    private final native JSObject getCallbackFunction();
}

