/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.vaadin.nodemaps.internal.gwt.client;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.event.OpenNMSEvent;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.event.OpenNMSEventHandler;

public class OpenNMSEventManager {
    private static final Logger LOG = Logger.getLogger(OpenNMSEventManager.class.getName());
    private Map<OpenNMSEvent.Type<? extends OpenNMSEventHandler>, Set<? extends OpenNMSEventHandler>> m_handlers = new HashMap<OpenNMSEvent.Type<? extends OpenNMSEventHandler>, Set<? extends OpenNMSEventHandler>>();

    protected <T extends OpenNMSEventHandler> Set<T> getHandlersForEvent(OpenNMSEvent<T> event) {
        return this.m_handlers.get(event.getAssociatedType());
    }

    public <T extends OpenNMSEventHandler> void fireEvent(OpenNMSEvent<T> event) {
        LOG.info("OpenNMSEventManager.fireEvent(" + event.toDebugString() + ")");
        Set<T> handlers = this.getHandlersForEvent(event);
        if (handlers != null) {
            for (OpenNMSEventHandler handler : handlers) {
                event.dispatch((T)handler);
            }
        }
    }

    public <H extends OpenNMSEventHandler> void addHandler(OpenNMSEvent.Type<H> type, H handler) {
        Set<? extends OpenNMSEventHandler> handlers = this.m_handlers.get(type);
        if (handlers == null) {
            handlers = new HashSet<OpenNMSEventHandler>();
            this.m_handlers.put(type, handlers);
        }
        handlers.add(handler);
    }

    public <H extends OpenNMSEventHandler> void removeHandler(OpenNMSEvent.Type<H> type, H handler) {
        Set<? extends OpenNMSEventHandler> handlers = this.m_handlers.get(type);
        if (handlers != null) {
            handlers.remove(handler);
        }
    }
}

