/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.vaadin.nodemaps.internal.gwt.client.ui.controls.alarm;

import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.logical.shared.AttachEvent;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.AbsolutePanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Widget;
import java.util.logging.Logger;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.OpenNMSEventManager;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.event.AlarmSeverityUpdatedEvent;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.event.AlarmSeverityUpdatedEventHandler;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.event.ComponentInitializedEvent;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.ui.controls.alarm.AlarmControlBundle;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.ui.controls.alarm.AlarmControlCss;

public class AlarmControl
extends AbsolutePanel
implements AlarmSeverityUpdatedEventHandler {
    private static final Logger LOG = Logger.getLogger(AlarmControl.class.getName());
    private ListBox m_severityBox;
    private OpenNMSEventManager m_eventManager;

    public AlarmControl(OpenNMSEventManager eventManager) {
        this.m_eventManager = eventManager;
        this.addAttachHandler(new AttachEvent.Handler(){

            public void onAttachOrDetach(AttachEvent event) {
                if (event.isAttached()) {
                    AlarmControl.this.doOnAdd();
                } else {
                    AlarmControl.this.doOnRemove();
                }
            }
        });
    }

    public Element doOnAdd() {
        LOG.info("AlarmControl.doOnAdd()");
        AlarmControlCss css = AlarmControlBundle.INSTANCE.css();
        css.ensureInjected();
        this.m_eventManager.addHandler(AlarmSeverityUpdatedEvent.TYPE, this);
        this.setStylePrimaryName("leaflet-control-alarm");
        this.addStyleName("leaflet-bar");
        this.addStyleName("leaflet-control");
        Label label = new Label("Show Severity >=");
        label.getElement().setAttribute("for", "alarmControl");
        label.addStyleName(css.label());
        this.m_severityBox = new ListBox(false);
        this.m_severityBox.getElement().setId("alarmControl");
        this.m_severityBox.addItem("Normal", "0");
        this.m_severityBox.addItem("Warning", "4");
        this.m_severityBox.addItem("Minor", "5");
        this.m_severityBox.addItem("Major", "6");
        this.m_severityBox.addItem("Critical", "7");
        this.m_severityBox.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                int selected = AlarmControl.this.m_severityBox.getSelectedIndex();
                LOG.info("new selection index = " + selected);
                String value = AlarmControl.this.m_severityBox.getValue(selected);
                LOG.info("new severity = " + value);
                int intValue = value == null ? 0 : Integer.valueOf(value);
                AlarmControl.this.m_eventManager.fireEvent(new AlarmSeverityUpdatedEvent(intValue));
                event.stopPropagation();
            }
        });
        this.m_severityBox.addStyleName(css.label());
        this.add((Widget)label);
        this.add((Widget)this.m_severityBox);
        LOG.info("AlarmControl.doOnAdd(): finished, returning: " + this.getElement());
        this.m_eventManager.fireEvent(new ComponentInitializedEvent(AlarmControl.class.getName()));
        return this.getElement();
    }

    public void doOnRemove() {
        LOG.info("doOnRemove() called");
        this.m_eventManager.removeHandler(AlarmSeverityUpdatedEvent.TYPE, this);
        this.m_eventManager.fireEvent(new AlarmSeverityUpdatedEvent(0));
    }

    @Override
    public void onAlarmSeverityUpdated(AlarmSeverityUpdatedEvent event) {
        this.m_severityBox.setItemSelected(event.getSeverity(), true);
    }
}

