/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.vaadin.nodemaps.internal.gwt.client.ui;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.DivElement;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.logical.shared.AttachEvent;
import com.google.gwt.user.client.ui.AbsolutePanel;
import com.google.gwt.user.client.ui.HTMLPanel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.discotools.gwt.leaflet.client.Options;
import org.discotools.gwt.leaflet.client.controls.IControl;
import org.discotools.gwt.leaflet.client.controls.zoom.Zoom;
import org.discotools.gwt.leaflet.client.controls.zoom.ZoomOptions;
import org.discotools.gwt.leaflet.client.crs.epsg.EPSG3857;
import org.discotools.gwt.leaflet.client.jsobject.JSObjectWrapper;
import org.discotools.gwt.leaflet.client.layers.ILayer;
import org.discotools.gwt.leaflet.client.layers.raster.TileLayer;
import org.discotools.gwt.leaflet.client.map.MapOptions;
import org.discotools.gwt.leaflet.client.types.LatLng;
import org.discotools.gwt.leaflet.client.types.LatLngBounds;
import org.opennms.features.geocoder.Coordinates;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.JSNodeMarker;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.Map;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.OpenNMSEventManager;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.event.ComponentInitializedEvent;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.event.FilteredMarkersUpdatedEvent;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.event.FilteredMarkersUpdatedEventHandler;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.event.IconCreateCallback;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.event.NodeMarkerClusterCallback;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.ui.GoogleLayer;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.ui.MarkerClusterGroup;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.ui.MarkerContainer;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.ui.MarkerFilterImpl;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.ui.MarkerProvider;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.ui.NodeIdSelectionRpc;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.ui.NodeMapConnector;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.ui.StatesData;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.ui.controls.alarm.AlarmControl;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.ui.controls.search.SearchControl;

public class NodeMapWidget
extends AbsolutePanel
implements MarkerProvider,
FilteredMarkersUpdatedEventHandler {
    private static final Logger LOG = Logger.getLogger(NodeMapWidget.class.getName());
    private final DivElement m_div;
    private Map m_map;
    private ILayer m_layer;
    private MarkerContainer m_markerContainer;
    private MarkerClusterGroup m_markerClusterGroup;
    private MarkerClusterGroup[] m_stateClusterGroups;
    private boolean m_firstUpdate = true;
    private SearchControl m_searchControl;
    private MarkerFilterImpl m_filter;
    private NodeIdSelectionRpc m_clientToServerRpc;
    private boolean m_groupByState;
    private OpenNMSEventManager m_eventManager;
    private SimplePanel m_mapPanel = new SimplePanel();

    public NodeMapWidget() {
        this.m_eventManager = new OpenNMSEventManager();
        this.m_eventManager.addHandler(FilteredMarkersUpdatedEvent.TYPE, this);
        this.m_mapPanel.setWidth("100%");
        this.m_mapPanel.setHeight("100%");
        Style mapStyle = this.m_mapPanel.getElement().getStyle();
        mapStyle.setPosition(Style.Position.ABSOLUTE);
        mapStyle.setTop(0.0, Style.Unit.PX);
        mapStyle.setLeft(0.0, Style.Unit.PX);
        this.setWidth("100%");
        this.setHeight("100%");
        this.add((Widget)this.m_mapPanel);
        this.m_div = (DivElement)this.m_mapPanel.getElement().cast();
        this.m_div.setId("gwt-map");
        this.setStyleName("v-openlayers");
        LOG.info("NodeMapWidget(): div ID = " + this.m_div.getId());
        this.addAttachHandler(new AttachEvent.Handler(){

            public void onAttachOrDetach(AttachEvent event) {
                if (event.isAttached()) {
                    LOG.info("NodeMapWidget.onAttach()");
                    NodeMapWidget.this.m_filter = new MarkerFilterImpl("", 0, NodeMapWidget.this.m_eventManager);
                    NodeMapWidget.this.m_markerContainer = new MarkerContainer(NodeMapWidget.this.m_filter, NodeMapWidget.this.m_eventManager);
                    NodeMapWidget.this.m_filter.onLoad();
                    NodeMapWidget.this.m_markerContainer.onLoad();
                    Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                        public void execute() {
                            NodeMapWidget.this.initializeMap(NodeMapWidget.this.m_div.getId());
                        }
                    });
                } else {
                    LOG.info("NodeMapwidget.onDetach()");
                    if (NodeMapWidget.this.m_markerContainer != null) {
                        NodeMapWidget.this.m_markerContainer.onUnload();
                    }
                    if (NodeMapWidget.this.m_filter != null) {
                        NodeMapWidget.this.m_filter.onUnload();
                    }
                    NodeMapWidget.this.destroyMap();
                }
            }
        });
        LOG.info("NodeMapWidget(): initialized");
    }

    private void initializeMap(String divId) {
        LOG.info("NodeMapWidget.initializeMap()");
        this.createMap(divId);
        this.addTileLayer();
        this.addMarkerLayer();
        this.addSearchControl();
        this.addAlarmControl();
        this.addZoomControl();
        this.m_searchControl.focusInput();
        this.m_eventManager.fireEvent(new ComponentInitializedEvent(NodeMapConnector.class.getName()));
        LOG.info("NodeMapWidget.initializeMap(): finished");
    }

    private void createGoogleLayer() {
        EPSG3857 projection = new EPSG3857();
        Options googleOptions = new Options();
        googleOptions.setProperty("crs", (JSObjectWrapper)projection);
        LOG.info("NodeMapWidget.createGoogleLayer(): adding Google layer");
        this.m_layer = new GoogleLayer("SATELLITE", googleOptions);
        this.m_map.addLayer(this.m_layer, true);
    }

    private void createMap(String divId) {
        MapOptions options = new MapOptions();
        options.setCenter(new LatLng(0.0, 0.0));
        options.setProperty("zoomControl", false);
        options.setZoom(1);
        options.setMaxZoom(15);
        this.m_map = new Map(divId, options);
    }

    private void addTileLayer() {
        LOG.info("NodeMapWidget.addTileLayer()");
        String attribution = "Map data &copy; <a tabindex=\"-1\" href=\"http://openstreetmap.org\">OpenStreetMap</a> contributors, <a tabindex=\"-1\" href=\"http://creativecommons.org/licenses/by-sa/2.0/\">CC-BY-SA</a>, Tiles &copy; <a tabindex=\"-1\" href=\"http://www.mapquest.com/\" target=\"_blank\">MapQuest</a> <img src=\"http://developer.mapquest.com/content/osm/mq_logo.png\" />";
        String url = "http://otile{s}.mqcdn.com/tiles/1.0.0/{type}/{z}/{x}/{y}.png";
        Options tileOptions = new Options();
        tileOptions.setProperty("attribution", "Map data &copy; <a tabindex=\"-1\" href=\"http://openstreetmap.org\">OpenStreetMap</a> contributors, <a tabindex=\"-1\" href=\"http://creativecommons.org/licenses/by-sa/2.0/\">CC-BY-SA</a>, Tiles &copy; <a tabindex=\"-1\" href=\"http://www.mapquest.com/\" target=\"_blank\">MapQuest</a> <img src=\"http://developer.mapquest.com/content/osm/mq_logo.png\" />");
        tileOptions.setProperty("subdomains", "1234");
        tileOptions.setProperty("type", "osm");
        this.m_layer = new TileLayer("http://otile{s}.mqcdn.com/tiles/1.0.0/{type}/{z}/{x}/{y}.png", tileOptions);
        this.m_map.addLayer(this.m_layer, true);
    }

    private void addMarkerLayer() {
        LOG.info("NodeMapWidget.addMarkerLayer()");
        Options markerClusterOptions = new Options();
        markerClusterOptions.setProperty("zoomToBoundsOnClick", false);
        markerClusterOptions.setProperty("iconCreateFunction", (JSObjectWrapper)new IconCreateCallback());
        this.m_markerClusterGroup = new MarkerClusterGroup(markerClusterOptions);
        NodeMarkerClusterCallback callback = new NodeMarkerClusterCallback();
        this.m_markerClusterGroup.on("clusterclick", callback);
        this.m_markerClusterGroup.on("clustertouchend", callback);
        this.m_map.addLayer((ILayer)this.m_markerClusterGroup);
        this.m_stateClusterGroups = new MarkerClusterGroup[52];
        Options[] stateClusterOptions = new Options[this.m_stateClusterGroups.length];
        for (int i = 0; i < this.m_stateClusterGroups.length; ++i) {
            stateClusterOptions[i] = markerClusterOptions;
            stateClusterOptions[i].setProperty("maxClusterRadius", 350);
            stateClusterOptions[i].setProperty("inUs", true);
            stateClusterOptions[i].setProperty("stateID", i);
            stateClusterOptions[i].setProperty("stateData", StatesData.getPolygonInfo(i, StatesData.getInstance()));
            this.m_stateClusterGroups[i] = new MarkerClusterGroup(stateClusterOptions[i]);
            this.m_stateClusterGroups[i].on("clusterclick", callback);
            this.m_stateClusterGroups[i].on("clustertouchend", callback);
            this.m_map.addLayer((ILayer)this.m_stateClusterGroups[i]);
        }
    }

    private void addSearchControl() {
        LOG.info("NodeMapWidget.addSearchControl()");
        this.m_searchControl = new SearchControl(this.m_markerContainer, (Widget)this, this.m_eventManager);
        String id = this.m_searchControl.getElement().getId();
        if (id == null || "".equals(id)) {
            this.m_searchControl.getElement().setId("search-control");
        } else {
            LOG.info("NodeMapWidget.addSearchControl(): id = " + id);
        }
        HTMLPanel mapParent = HTMLPanel.wrap((Element)this.m_mapPanel.getParent().getElement());
        Style searchStyle = this.m_searchControl.getElement().getStyle();
        searchStyle.setPosition(Style.Position.ABSOLUTE);
        searchStyle.setTop(5.0, Style.Unit.PX);
        searchStyle.setLeft(5.0, Style.Unit.PX);
        searchStyle.setZIndex(2000);
        mapParent.add((Widget)this.m_searchControl);
    }

    private void addAlarmControl() {
        LOG.info("NodeMapWidget.addAlarmControl()");
        AlarmControl alarmControl = new AlarmControl(this.m_eventManager);
        String id = alarmControl.getElement().getId();
        if (id == null || "".equals(id)) {
            alarmControl.getElement().setId("alarm-control");
        } else {
            LOG.info("NodeMapWidget.addAlarmControl(): id = " + id);
        }
        HTMLPanel mapParent = HTMLPanel.wrap((Element)this.m_mapPanel.getParent().getElement());
        Style searchStyle = alarmControl.getElement().getStyle();
        searchStyle.setPosition(Style.Position.ABSOLUTE);
        searchStyle.setTop(5.0, Style.Unit.PX);
        searchStyle.setRight(5.0, Style.Unit.PX);
        searchStyle.setZIndex(2000);
        mapParent.add((Widget)alarmControl);
    }

    private void addZoomControl() {
        LOG.info("NodeMapWidget.addZoomControl()");
        ZoomOptions options = new ZoomOptions();
        options.setPosition("topright");
        this.m_map.addControl((IControl)new Zoom((Options)options));
    }

    public boolean markerShouldBeVisible(JSNodeMarker marker) {
        return this.m_filter.matches(marker);
    }

    public void updateMarkerClusterLayer() {
        if (this.m_markerContainer == null || this.m_markerClusterGroup == null) {
            LOG.info("NodeMapWidget.updateMarkerClusterLayout(): markers or marker clusters not initialized yet, deferring refresh");
            Scheduler.get().scheduleFixedDelay(new Scheduler.RepeatingCommand(){

                public boolean execute() {
                    NodeMapWidget.this.updateMarkerClusterLayer();
                    return false;
                }
            }, 1000);
            return;
        }
        this.clearExistingMarkers();
        this.addNewMarkers();
        this.removeDisabledMarkers();
        this.zoomToFit();
        this.sendSelectionToBackend();
    }

    private void clearExistingMarkers() {
        LOG.info("NodeMapWidget.clearExistingMarkers()");
        this.m_markerClusterGroup.clearLayers();
        for (int i = 0; i < this.m_stateClusterGroups.length; ++i) {
            this.m_stateClusterGroups[i].clearLayers();
        }
    }

    private void addNewMarkers() {
        LOG.info("NodeMapWidget.addNewMarkers(): adding " + this.m_markerContainer.size() + " markers to the map.");
        Scheduler.get().scheduleIncremental(new Scheduler.RepeatingCommand(){
            final ListIterator<JSNodeMarker> m_markerIterator;
            {
                this.m_markerIterator = NodeMapWidget.this.m_markerContainer.listIterator();
            }

            public boolean execute() {
                if (this.m_markerIterator.hasNext()) {
                    JSNodeMarker marker = this.m_markerIterator.next();
                    Coordinates coordinates = marker.getCoordinates();
                    if (coordinates == null) {
                        LOG.log(Level.WARNING, "NodeMapWidget.addNewMarkers(): no coordinates found for marker! " + marker);
                        return true;
                    }
                    if (NodeMapWidget.this.m_groupByState && StatesData.inUs(coordinates.getLatitudeAsDouble(), coordinates.getLongitudeAsDouble(), StatesData.getUsShape())) {
                        int stateId = StatesData.getStateId(marker.getLatLng().lat(), marker.getLatLng().lng(), StatesData.getInstance());
                        if (!NodeMapWidget.this.m_stateClusterGroups[stateId].hasLayer((ILayer)marker)) {
                            NodeMapWidget.this.m_stateClusterGroups[stateId].addLayer((ILayer)marker);
                        }
                    } else if (!NodeMapWidget.this.m_markerClusterGroup.hasLayer((ILayer)marker)) {
                        NodeMapWidget.this.m_markerClusterGroup.addLayer((ILayer)marker);
                    }
                    return true;
                }
                LOG.info("NodeMapWidget.addNewMarkers(): finished adding visible markers (" + NodeMapWidget.this.m_markerContainer.size() + " entries)");
                return false;
            }
        });
    }

    private void removeDisabledMarkers() {
        final List<JSNodeMarker> disabledMarkers = this.m_markerContainer.getDisabledMarkers();
        LOG.info("NodeMapWidget.removeDisabledMarkers(): removing " + disabledMarkers.size() + " disabled markers from the map.");
        Scheduler.get().scheduleIncremental(new Scheduler.RepeatingCommand(){
            final ListIterator<JSNodeMarker> m_markerIterator;
            {
                this.m_markerIterator = disabledMarkers.listIterator();
            }

            public boolean execute() {
                if (this.m_markerIterator.hasNext()) {
                    JSNodeMarker marker = this.m_markerIterator.next();
                    marker.closePopup();
                    Coordinates coordinates = marker.getCoordinates();
                    if (coordinates == null) {
                        LOG.log(Level.WARNING, "NodeMapWidget.removeDisabledMarkers(): no coordinates found for marker! " + marker);
                        return true;
                    }
                    if (NodeMapWidget.this.m_groupByState && StatesData.inUs(marker.getLatLng().lat(), marker.getLatLng().lng(), StatesData.getUsShape())) {
                        int stateId = StatesData.getStateId(marker.getLatLng().lat(), marker.getLatLng().lng(), StatesData.getInstance());
                        NodeMapWidget.this.m_stateClusterGroups[stateId].removeLayer((ILayer)marker);
                    } else {
                        NodeMapWidget.this.m_markerClusterGroup.removeLayer((ILayer)marker);
                    }
                    return true;
                }
                LOG.info("NodeMapWidget.removeDisabledMarkers(): finished removing filtered markers (" + disabledMarkers.size() + " entries)");
                return false;
            }
        });
    }

    private void zoomToFit() {
        if (this.m_firstUpdate) {
            LOG.info("NodeMapWidget.zoomToFit(): first update, zooming to bounds.");
            Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                public void execute() {
                    if (NodeMapWidget.this.m_firstUpdate) {
                        List<JSNodeMarker> allMarkers = NodeMapWidget.this.m_markerContainer.getAllMarkers();
                        if (allMarkers.size() == 0) {
                            LOG.info("NodeMapWidget.zoomToFit(): no bounds yet, skipping.");
                        } else {
                            LatLngBounds bounds = new LatLngBounds();
                            for (JSNodeMarker marker : allMarkers) {
                                LOG.info("NodeMapWidget.zoomToFit(): processing marker: " + marker);
                                Coordinates coordinates = marker.getCoordinates();
                                if (coordinates == null) {
                                    LOG.log(Level.WARNING, "NodeMapWidget.zoomToFit(): no coordinates found for marker! " + marker);
                                    continue;
                                }
                                bounds.extend(JSNodeMarker.coordinatesToLatLng(coordinates));
                            }
                            LOG.info("NodeMapWidget.zoomToFit(): setting boundary to " + bounds.toBBoxString() + ".");
                            NodeMapWidget.this.m_map.fitBounds(bounds);
                            NodeMapWidget.this.m_firstUpdate = false;
                        }
                    }
                }
            });
        }
    }

    private void sendSelectionToBackend() {
        Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                ArrayList<Integer> nodeIds = new ArrayList<Integer>();
                for (JSNodeMarker marker : NodeMapWidget.this.m_markerContainer.getMarkers()) {
                    Integer nodeId = marker.getNodeId();
                    if (nodeId == null) continue;
                    nodeIds.add(nodeId);
                }
                NodeMapWidget.this.m_clientToServerRpc.setSelectedNodes(nodeIds);
                LOG.info("NodeMapWidget.sendSelectionToBackend(): sent " + nodeIds.size() + " nodes to backend.");
            }
        });
    }

    @Override
    public List<JSNodeMarker> getMarkers() {
        return this.m_markerContainer.getMarkers();
    }

    public void setMarkers(List<JSNodeMarker> markers) {
        if (markers != null) {
            this.m_markerContainer.setMarkers(markers);
        } else {
            this.m_markerContainer.setMarkers(new ArrayList<JSNodeMarker>());
        }
    }

    private final void destroyMap() {
        if (this.m_markerClusterGroup != null) {
            this.m_markerClusterGroup.clearLayers();
            for (int i = 0; i < this.m_stateClusterGroups.length; ++i) {
                this.m_stateClusterGroups[i].clearLayers();
            }
        }
        if (this.m_map != null) {
            this.m_map.removeLayer((ILayer)this.m_markerClusterGroup);
            this.m_map.removeLayer(this.m_layer);
            this.m_map = null;
        }
    }

    public void setRpc(NodeIdSelectionRpc rpc) {
        this.m_clientToServerRpc = rpc;
    }

    @Override
    public void onFilteredMarkersUpdatedEvent(FilteredMarkersUpdatedEvent event) {
        LOG.info("NodeMapWidget.onFilteredMarkersUpdated(), refreshing node map widgets");
        this.updateMarkerClusterLayer();
    }

    public OpenNMSEventManager getEventManager() {
        return this.m_eventManager;
    }

    public void setGroupByState(boolean groupByState) {
        this.m_groupByState = groupByState;
        LOG.info("NodeMapWidget.setGroupByState(): group by state: " + (groupByState ? "yes" : "no"));
    }
}

