/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.vaadin.nodemaps.internal.gwt.client;

import com.google.gwt.core.client.JsArrayString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.discotools.gwt.leaflet.client.Options;
import org.discotools.gwt.leaflet.client.jsobject.JSObject;
import org.discotools.gwt.leaflet.client.marker.Marker;
import org.discotools.gwt.leaflet.client.types.LatLng;
import org.opennms.features.geocoder.Coordinates;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.NodeMarker;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.SearchResult;

public class JSNodeMarker
extends Marker
implements NodeMarker {
    public JSNodeMarker(LatLng latLng) {
        super(latLng, new Options());
    }

    public JSNodeMarker(JSObject element) {
        super(element);
    }

    public void putProperty(String key, String value) {
        this.getJSObject().setProperty(key, value);
    }

    public String getProperty(String key) {
        return this.getJSObject().getPropertyAsString(key);
    }

    public List<String> getTextPropertyNames() {
        JsArrayString nativeNames = this.getNativePropertyNames(this.getJSObject());
        ArrayList<String> names = new ArrayList<String>();
        for (int i = 0; i < nativeNames.length(); ++i) {
            names.add(nativeNames.get(i));
        }
        return names;
    }

    private native JsArrayString getNativePropertyNames(JSObject var1);

    @Override
    public List<String> getCategoryList() {
        ArrayList<String> categories = new ArrayList<String>();
        JsArrayString jsCategories = this.getCategories();
        for (int i = 0; i < jsCategories.length(); ++i) {
            categories.add(jsCategories.get(i));
        }
        return categories;
    }

    public JsArrayString getCategories() {
        JSObject property = this.getJSObject().getProperty("categories");
        if (property == null) {
            return (JsArrayString)JsArrayString.createArray().cast();
        }
        return (JsArrayString)property.cast();
    }

    public String getCategoriesAsString() {
        StringBuilder catBuilder = new StringBuilder();
        JsArrayString categories = this.getCategories();
        if (categories.length() > 0) {
            if (categories.length() == 1) {
                catBuilder.append("Category: ");
            } else {
                catBuilder.append("Categories: ");
            }
            for (int i = 0; i < categories.length(); ++i) {
                catBuilder.append(categories.get(i));
                if (i == categories.length() - 1) continue;
                catBuilder.append(", ");
            }
        }
        return catBuilder.toString();
    }

    public void setCategories(String[] categories) {
        JsArrayString array = (JsArrayString)JsArrayString.createArray().cast();
        for (String category : categories) {
            array.push(category);
        }
        JSObject jsObject = (JSObject)array.cast();
        this.getJSObject().setProperty("categories", jsObject);
    }

    @Override
    public Integer getNodeId() {
        String id = this.getProperty("nodeId");
        return id == null ? null : Integer.valueOf(id);
    }

    @Override
    public String getNodeLabel() {
        return this.getProperty("nodeLabel");
    }

    @Override
    public String getForeignSource() {
        return this.getProperty("foreignSource");
    }

    @Override
    public String getForeignId() {
        return this.getProperty("foreignId");
    }

    @Override
    public String getIpAddress() {
        return this.getProperty("ipAddress");
    }

    @Override
    public String getSeverityLabel() {
        return this.getProperty("severityLabel");
    }

    @Override
    public String getDescription() {
        return this.getProperty("description");
    }

    @Override
    public String getMaintContract() {
        return this.getProperty("maintcontract");
    }

    @Override
    public Coordinates getCoordinates() {
        LatLng latLng = this.getLatLng();
        if (latLng == null || latLng.lat() == Double.NaN || latLng.lng() == Double.NaN) {
            return null;
        }
        return new Coordinates(Double.valueOf(latLng.lng()).floatValue(), Double.valueOf(latLng.lat()).floatValue());
    }

    @Override
    public Integer getSeverity() {
        String severity = this.getProperty("severity");
        return severity == null ? 0 : Integer.valueOf(severity);
    }

    @Override
    public Integer getUnackedCount() {
        String count = this.getProperty("unackedCount");
        return count == null ? 0 : Integer.valueOf(count);
    }

    @Override
    public Map<String, String> getProperties() {
        Coordinates coordinates;
        Integer unackedCount;
        Integer severity;
        Integer nodeId;
        HashMap<String, String> props = new HashMap<String, String>();
        for (String k : this.getTextPropertyNames()) {
            String value = this.getProperty(k);
            if (k == null || value == null) continue;
            String key = k.toLowerCase();
            props.put(key, value);
        }
        String cats = this.getCategoriesAsString();
        if (cats != null && cats.length() > 0) {
            props.put("categories", cats);
        }
        if ((nodeId = this.getNodeId()) != null) {
            props.put("nodeid", nodeId.toString());
        }
        if ((severity = this.getSeverity()) != null) {
            props.put("severity", severity.toString());
        }
        if ((unackedCount = this.getUnackedCount()) != null) {
            props.put("unackedcount", unackedCount.toString());
        }
        if ((coordinates = this.getCoordinates()) != null) {
            props.put("coordinates", coordinates.toString());
        }
        return props;
    }

    public final String toString() {
        return "Feature[lat=" + this.getLatLng().lat() + ",lon=" + this.getLatLng().lng() + ",label=" + this.getNodeLabel() + "]";
    }

    public JSObject toSearchResult() {
        return SearchResult.create(this.getNodeLabel(), this.getLatLng());
    }

    public static LatLng coordinatesToLatLng(Coordinates coordinates) {
        return new LatLng(coordinates.getLatitudeAsDouble(), coordinates.getLongitudeAsDouble());
    }

    public static class Property {
        public static final String CATEGORIES = "categories";
        public static final String NODE_ID = "nodeId";
        public static final String NODE_LABEL = "nodeLabel";
        public static final String FOREIGN_SOURCE = "foreignSource";
        public static final String FOREIGN_ID = "foreignId";
        public static final String IP_ADDRESS = "ipAddress";
        public static final String SEVERITY_LABEL = "severityLabel";
        public static final String DESCRIPTION = "description";
        public static final String MAINTCONTRACT = "maintcontract";
        public static final String SEVERITY = "severity";
        public static final String UNACKED_COUNT = "unackedCount";
    }
}

