/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.vaadin.nodemaps.internal.gwt.client.ui.controls.search;

import com.google.gwt.cell.client.AbstractSafeHtmlCell;
import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.ValueUpdater;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.dom.client.Style;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.text.shared.AbstractSafeHtmlRenderer;
import com.google.gwt.text.shared.SafeHtmlRenderer;
import com.google.gwt.user.cellview.client.CellList;
import com.google.gwt.user.cellview.client.HasKeyboardSelectionPolicy;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HTMLPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.SingleSelectionModel;
import com.vaadin.terminal.gwt.client.VConsole;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.discotools.gwt.leaflet.client.controls.Control;
import org.discotools.gwt.leaflet.client.jsobject.JSObject;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.NodeMarker;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.SearchConsumer;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.SearchOptions;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.event.DomEvent;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.event.DomEventCallback;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.event.SearchEventCallback;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.ui.MarkerContainer;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.ui.controls.search.SearchControlImpl;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.ui.controls.search.SearchStateManager;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.ui.controls.search.SearchTextBox;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.ui.controls.search.ValueItem;

public class SearchControl
extends Control {
    private static final HashMap<String, String> m_labels = new HashMap();
    private HTMLPanel m_container;
    private SearchTextBox m_inputBox;
    private HistoryWrapper m_historyWrapper;
    private HTML m_submitIcon;
    private SearchConsumer m_searchConsumer;
    private MarkerContainer m_markerContainer;
    private SearchEventCallback m_changeCallback;
    private CellList<NodeMarker> m_autoComplete;
    private SearchStateManager m_stateManager;
    private SingleSelectionModel<NodeMarker> m_selectionModel;
    private Set<Widget> m_updated = new HashSet<Widget>();

    public SearchControl(SearchConsumer searchConsumer, MarkerContainer markerContainer) {
        this(searchConsumer, markerContainer, new SearchOptions());
    }

    public SearchControl(SearchConsumer searchConsumer, MarkerContainer markerContainer, SearchOptions options) {
        super(JSObject.createJSObject());
        this.setJSObject(SearchControlImpl.create(this, options.getJSObject()));
        VConsole.log((String)"new SearchControl()");
        this.m_searchConsumer = searchConsumer;
        this.m_markerContainer = markerContainer;
        this.m_selectionModel = new SingleSelectionModel();
        this.m_historyWrapper = new HistoryWrapper();
        this.initializeContainerWidget();
        this.initializeInputWidget();
        this.initializeSubmitWidget();
        this.initializeCellAutocompleteWidget();
        this.initializeSearchStateManager();
    }

    public void focus() {
        this.m_inputBox.setFocus(true);
    }

    public com.google.gwt.user.client.Element doOnAdd(JavaScriptObject map) {
        VConsole.log((String)"onAdd() called");
        this.m_container.add((Widget)this.m_inputBox);
        this.m_container.add((Widget)this.m_submitIcon);
        this.m_container.add(this.m_autoComplete);
        return this.m_container.getElement();
    }

    public SearchControl doOnRemove(JavaScriptObject map) {
        VConsole.log((String)"onRemove() called");
        if (this.m_changeCallback != null) {
            DomEvent.removeListener(this.m_changeCallback);
        }
        return this;
    }

    public void refresh() {
        List<NodeMarker> markers = this.m_markerContainer.getMarkers();
        this.m_autoComplete.setRowData(markers);
    }

    protected void updateAutocompleteStyle(Widget widget) {
        if (this.m_updated.contains(widget)) {
            return;
        }
        Style style = widget.getElement().getStyle();
        style.setPosition(Style.Position.ABSOLUTE);
        int left = 5;
        int top = this.m_container.getOffsetHeight() + 5;
        style.setLeft(5.0, Style.Unit.PX);
        style.setTop((double)top, Style.Unit.PX);
        DomEvent.stopEventPropagation(widget);
        this.m_updated.add(widget);
    }

    private void initializeSearchStateManager() {
        this.m_stateManager = new SearchStateManager(this.m_inputBox, this.m_historyWrapper){

            @Override
            public void refresh() {
                NodeMarker firstMarker;
                SearchControl.this.m_searchConsumer.setSearchString(SearchControl.this.m_inputBox.getValue());
                SearchControl.this.m_searchConsumer.refresh();
                List<NodeMarker> markers = SearchControl.this.m_markerContainer.getMarkers();
                NodeMarker selected = (NodeMarker)((Object)SearchControl.this.m_selectionModel.getSelectedObject());
                NodeMarker nodeMarker = firstMarker = markers.size() > 0 ? markers.get(0) : null;
                if (selected == null) {
                    if (firstMarker != null) {
                        SearchControl.this.m_selectionModel.setSelected((Object)firstMarker, true);
                    }
                } else if (!markers.contains((Object)selected)) {
                    if (firstMarker != null) {
                        SearchControl.this.m_selectionModel.setSelected((Object)firstMarker, true);
                    } else {
                        SearchControl.this.m_selectionModel.setSelected((Object)selected, false);
                    }
                }
            }

            @Override
            public void clearSearchInput() {
                SearchControl.this.m_inputBox.setValue("");
            }

            @Override
            public void focusAutocomplete() {
                List<NodeMarker> markers;
                SearchControl.this.m_autoComplete.setFocus(true);
                if (SearchControl.this.m_selectionModel.getSelectedObject() == null && (markers = SearchControl.this.m_markerContainer.getMarkers()).size() > 0) {
                    SearchControl.this.m_selectionModel.setSelected((Object)markers.get(0), true);
                }
            }

            @Override
            public void showAutocomplete() {
                List<NodeMarker> markers = SearchControl.this.m_markerContainer.getMarkers();
                if (markers.size() > 0) {
                    SearchControl.this.m_selectionModel.setSelected((Object)markers.get(0), true);
                }
                SearchControl.this.m_autoComplete.setVisible(true);
                SearchControl.this.updateAutocompleteStyle((Widget)SearchControl.this.m_autoComplete);
            }

            @Override
            public void hideAutocomplete() {
                SearchControl.this.m_autoComplete.setVisible(false);
            }

            @Override
            public void entrySelected() {
                NodeMarker selected = (NodeMarker)((Object)SearchControl.this.m_selectionModel.getSelectedObject());
                if (selected != null) {
                    SearchControl.this.m_inputBox.setValue("nodeLabel=" + selected.getNodeLabel());
                }
            }

            @Override
            public void focusInput() {
                SearchControl.this.m_inputBox.setFocus(true);
            }
        };
    }

    private void initializeContainerWidget() {
        this.m_container = HTMLPanel.wrap((Element)SearchControlImpl.createElement("leaflet-control-search"));
        this.m_container.addStyleName("leaflet-control");
    }

    private void initializeInputWidget() {
        this.m_inputBox = new SearchTextBox();
        this.m_inputBox.addStyleName("search-input");
        this.m_inputBox.getElement().setAttribute("placeholder", "Search...");
        this.m_inputBox.getElement().setAttribute("type", "search");
        this.m_inputBox.setMaxLength(40);
        this.m_inputBox.setVisibleLength(40);
        this.m_inputBox.setValue(this.m_searchConsumer.getSearchString());
        DomEvent.stopEventPropagation((Widget)this.m_inputBox);
        this.m_changeCallback = new SearchEventCallback(new String[]{"keydown", "change", "cut", "paste", "search"}, (Widget)this.m_inputBox, this.m_searchConsumer){

            @Override
            protected void onEvent(NativeEvent event) {
                SearchControl.this.m_stateManager.handleInputEvent(event);
            }
        };
        DomEvent.addListener(this.m_changeCallback);
    }

    private void initializeSubmitWidget() {
        this.m_submitIcon = new HTML();
        this.m_submitIcon.addStyleName("search-button");
        this.m_submitIcon.setTitle("Search locations...");
        DomEvent.stopEventPropagation((Widget)this.m_submitIcon);
        DomEvent.addListener(new DomEventCallback("click", (Widget)this.m_submitIcon){

            @Override
            protected void onEvent(NativeEvent event) {
                SearchControl.this.m_inputBox.setFocus(true);
                SearchControl.this.m_stateManager.handleSearchIconEvent(event);
            }
        });
    }

    private void initializeCellAutocompleteWidget() {
        AbstractSafeHtmlRenderer<NodeMarker> renderer = new AbstractSafeHtmlRenderer<NodeMarker>(){

            public SafeHtml render(NodeMarker marker) {
                SafeHtmlBuilder builder = new SafeHtmlBuilder();
                String searchString = SearchControl.this.m_searchConsumer.getSearchString().toLowerCase();
                builder.appendHtmlConstant("<div class=\"autocomplete-label\">");
                builder.appendHtmlConstant(marker.getNodeLabel());
                builder.appendHtmlConstant("</div>");
                String additionalSearchInfo = null;
                if (searchString.contains(":") || searchString.contains("=")) {
                    String categoryString;
                    String searchKey = searchString.replaceAll("[\\:\\=].*$", "").toLowerCase();
                    VConsole.log((String)("searchKey = " + searchKey));
                    if (("category".equals(searchKey) || "categories".equals(searchKey)) && (categoryString = marker.getCategoriesAsString()).length() > 0) {
                        additionalSearchInfo = categoryString;
                    }
                    for (String key : marker.getTextPropertyNames()) {
                        String lowerKey = key.toLowerCase();
                        if (!lowerKey.equals(searchKey) || !m_labels.containsKey(lowerKey)) continue;
                        additionalSearchInfo = (String)m_labels.get(lowerKey) + ": " + marker.getProperty(key);
                        break;
                    }
                }
                if (additionalSearchInfo != null) {
                    builder.appendHtmlConstant("<div class=\"autocomplete-additional-info\">").appendHtmlConstant(additionalSearchInfo).appendHtmlConstant("</div>");
                }
                return builder.toSafeHtml();
            }
        };
        AbstractSafeHtmlCell<NodeMarker> cell = new AbstractSafeHtmlCell<NodeMarker>((SafeHtmlRenderer)renderer, new String[]{"keydown", "click", "dblclick", "touchstart"}){

            public void onBrowserEvent(Cell.Context context, Element parent, NodeMarker value, NativeEvent event, ValueUpdater<NodeMarker> valueUpdater) {
                if (SearchControl.this.m_stateManager.handleAutocompleteEvent(event)) {
                    super.onBrowserEvent(context, parent, (Object)value, event, valueUpdater);
                }
            }

            protected void render(Cell.Context context, SafeHtml data, SafeHtmlBuilder builder) {
                builder.appendHtmlConstant("<div class=\"autocomplete-entry\">");
                if (data != null) {
                    builder.append(data);
                }
                builder.appendHtmlConstant("</div>");
            }
        };
        this.m_autoComplete = new CellList((Cell)cell);
        this.m_autoComplete.setSelectionModel(this.m_selectionModel);
        this.m_autoComplete.setKeyboardSelectionPolicy(HasKeyboardSelectionPolicy.KeyboardSelectionPolicy.BOUND_TO_SELECTION);
        this.m_autoComplete.setVisible(false);
        this.m_autoComplete.addStyleName("search-autocomplete");
    }

    static {
        m_labels.put("nodeid", "Node&nbsp;ID");
        m_labels.put("description", "Description");
        m_labels.put("ipaddress", "IP&nbsp;Address");
        m_labels.put("maintcontract", "Maint.&nbsp;Contract");
        m_labels.put("foreignsource", "Foreign&nbsp;Source");
        m_labels.put("foreignid", "Foreign&nbsp;ID");
    }

    private class HistoryWrapper
    implements ValueItem {
        private HistoryWrapper() {
        }

        @Override
        public String getValue() {
            return History.getToken();
        }

        @Override
        public void setValue(String value) {
            History.newItem((String)value);
        }
    }
}

