/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.vaadin.nodemaps.internal.gwt.client.ui.controls.search;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.NativeEvent;
import com.vaadin.terminal.gwt.client.VConsole;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.ui.controls.search.ValueItem;

public abstract class SearchStateManager {
    private SearchState m_state;
    private ValueItem m_valueItem;
    private ValueItem m_history;

    public SearchStateManager(ValueItem valueItem, ValueItem history) {
        this.m_valueItem = valueItem;
        this.m_history = history;
        String valueSearchString = this.m_valueItem.getValue();
        String historySearchString = this.getHistorySearchString();
        if (historySearchString != null) {
            this.m_valueItem.setValue(historySearchString);
            this.m_state = State.SEARCHING_FINISHED;
        } else {
            this.m_state = valueSearchString != null && !"".equals(valueSearchString) ? State.SEARCHING_FINISHED : State.NOT_SEARCHING;
        }
        this.m_state.initialize(this);
    }

    SearchState getState() {
        return this.m_state;
    }

    protected ValueItem getValueItem() {
        return this.m_valueItem;
    }

    public void updateMatchCount(int matchCount) {
        this.m_state = this.m_state.updateMatchCount(this, matchCount);
    }

    public boolean handleAutocompleteEvent(NativeEvent event) {
        String eventType = event.getType();
        int eventKeyCode = event.getKeyCode();
        VConsole.log((String)("handleAutocompleteEvent(" + this.m_state + "): received " + eventType + " (keyCode = " + eventKeyCode + ")"));
        if ("keydown".equals(eventType)) {
            switch (eventKeyCode) {
                case 27: {
                    Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                        public void execute() {
                            SearchStateManager.this.m_state = SearchStateManager.this.m_state.cancelSearching(SearchStateManager.this);
                        }
                    });
                    break;
                }
                case 13: {
                    Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                        public void execute() {
                            SearchStateManager.this.m_state = SearchStateManager.this.m_state.currentEntrySelected(SearchStateManager.this);
                        }
                    });
                }
            }
        } else {
            if ("click".equals(eventType) || "touchstart".equals(eventType)) {
                Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                    public void execute() {
                        SearchStateManager.this.m_state = SearchStateManager.this.m_state.currentEntrySelected(SearchStateManager.this);
                    }
                });
                return true;
            }
            VConsole.log((String)("handleAutocompleteEvent(" + this.m_state + "): unhandled event: " + eventType));
            return true;
        }
        return false;
    }

    public void handleSearchIconEvent(NativeEvent event) {
        String eventType = event.getType();
        VConsole.log((String)("handleSearchIconEvent(" + this.m_state + "): received " + eventType + " (keyCode = " + event.getKeyCode() + ")"));
        if ("click".equals(eventType) || "touchstart".equals(eventType)) {
            Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                public void execute() {
                    SearchStateManager.this.m_state = SearchStateManager.this.m_state.finishedSearching(SearchStateManager.this);
                }
            });
        } else {
            VConsole.log((String)("handleSearchIconEvent(" + this.m_state + "): unhandled event: " + eventType));
        }
    }

    public void handleInputEvent(NativeEvent event) {
        String eventType = event.getType();
        VConsole.log((String)("handleInputEvent(" + this.m_state + "): received " + eventType + " (keyCode = " + event.getKeyCode() + ")"));
        if ("keydown".equals(eventType)) {
            switch (event.getKeyCode()) {
                case 27: {
                    Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                        public void execute() {
                            SearchStateManager.this.m_state = SearchStateManager.this.m_state.cancelSearching(SearchStateManager.this);
                        }
                    });
                    break;
                }
                case 40: {
                    Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                        public void execute() {
                            SearchStateManager.this.m_state = SearchStateManager.this.m_state.autocompleteStartNavigation(SearchStateManager.this);
                        }
                    });
                    break;
                }
                case 13: {
                    Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                        public void execute() {
                            SearchStateManager.this.m_state = SearchStateManager.this.m_state.finishedSearching(SearchStateManager.this);
                        }
                    });
                    break;
                }
                default: {
                    Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                        public void execute() {
                            String value = SearchStateManager.this.m_valueItem.getValue();
                            if (value == null || "".equals(value)) {
                                SearchStateManager.this.m_state = SearchStateManager.this.m_state.cancelSearching(SearchStateManager.this);
                            } else {
                                SearchStateManager.this.m_state = SearchStateManager.this.m_state.searchInputReceived(SearchStateManager.this);
                            }
                        }
                    });
                    break;
                }
            }
        } else if ("search".equals(eventType)) {
            String searchString = this.m_valueItem.getValue();
            if ("".equals(searchString)) {
                Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                    public void execute() {
                        SearchStateManager.this.m_state = SearchStateManager.this.m_state.cancelSearching(SearchStateManager.this);
                    }
                });
            }
        } else {
            VConsole.log((String)("handleInputEvent(" + this.m_state + "): unhandled event: " + eventType));
        }
    }

    public void reset() {
        this.m_state = this.m_state.cancelSearching(this);
    }

    private String getHistorySearchString() {
        String value = this.m_history.getValue();
        if (value != null && value.startsWith("search/")) {
            return value.replaceFirst("^search\\/", "");
        }
        return null;
    }

    protected void updateHistorySearchString() {
        String newToken;
        String token = this.m_history.getValue();
        String value = this.m_valueItem.getValue();
        String string = newToken = value == null || "".equals(value) ? "" : "search/" + value;
        if (!newToken.equals(token)) {
            this.m_history.setValue(newToken);
        }
    }

    public abstract void refresh();

    public abstract void entrySelected();

    public abstract void clearSearchInput();

    public abstract void focusInput();

    public abstract void focusAutocomplete();

    public abstract void showAutocomplete();

    public abstract void hideAutocomplete();

    static enum State implements SearchState
    {
        NOT_SEARCHING{

            @Override
            public SearchState initialize(SearchStateManager manager) {
                manager.focusInput();
                manager.hideAutocomplete();
                return this;
            }

            @Override
            public SearchState cancelSearching(SearchStateManager manager) {
                manager.focusInput();
                return this;
            }

            @Override
            public SearchState autocompleteStartNavigation(SearchStateManager manager) {
                VConsole.log((String)"WARNING: attempting to start autocomplete navigation, but we're not searching!");
                return this;
            }

            @Override
            public SearchState searchInputReceived(SearchStateManager manager) {
                manager.refresh();
                manager.showAutocomplete();
                return SEARCHING_AUTOCOMPLETE_VISIBLE;
            }

            @Override
            public SearchState finishedSearching(SearchStateManager manager) {
                VConsole.log((String)"WARNING: attempting to finish, but we're not searching!");
                return this;
            }

            @Override
            public SearchState currentEntrySelected(SearchStateManager manager) {
                VConsole.log((String)"WARNING: attempting to finish, but we're not searching!");
                return this;
            }

            @Override
            public SearchState updateMatchCount(SearchStateManager manager, int matchCount) {
                VConsole.log((String)"WARNING: match count updated, but we're not searching!");
                return this;
            }
        }
        ,
        SEARCHING_AUTOCOMPLETE_VISIBLE{

            @Override
            public SearchState initialize(SearchStateManager manager) {
                manager.focusInput();
                manager.showAutocomplete();
                manager.refresh();
                return this;
            }

            @Override
            public SearchState cancelSearching(SearchStateManager manager) {
                manager.clearSearchInput();
                manager.hideAutocomplete();
                manager.updateHistorySearchString();
                manager.refresh();
                return NOT_SEARCHING;
            }

            @Override
            public SearchState autocompleteStartNavigation(SearchStateManager manager) {
                manager.focusAutocomplete();
                return SEARCHING_AUTOCOMPLETE_ACTIVE;
            }

            @Override
            public SearchState searchInputReceived(SearchStateManager manager) {
                manager.refresh();
                return this;
            }

            @Override
            public SearchState finishedSearching(SearchStateManager manager) {
                manager.hideAutocomplete();
                manager.updateHistorySearchString();
                manager.refresh();
                return SEARCHING_FINISHED;
            }

            @Override
            public SearchState currentEntrySelected(SearchStateManager manager) {
                manager.hideAutocomplete();
                manager.entrySelected();
                manager.updateHistorySearchString();
                manager.refresh();
                return SEARCHING_FINISHED;
            }

            @Override
            public SearchState updateMatchCount(SearchStateManager manager, int matchCount) {
                if (matchCount == 0) {
                    manager.hideAutocomplete();
                    return SEARCHING_AUTOCOMPLETE_HIDDEN;
                }
                return this;
            }
        }
        ,
        SEARCHING_AUTOCOMPLETE_ACTIVE{

            @Override
            public SearchState initialize(SearchStateManager manager) {
                manager.showAutocomplete();
                manager.focusAutocomplete();
                manager.refresh();
                return this;
            }

            @Override
            public SearchState cancelSearching(SearchStateManager manager) {
                manager.clearSearchInput();
                manager.hideAutocomplete();
                manager.updateHistorySearchString();
                manager.refresh();
                return NOT_SEARCHING;
            }

            @Override
            public SearchState finishedSearching(SearchStateManager manager) {
                manager.hideAutocomplete();
                manager.focusInput();
                manager.updateHistorySearchString();
                manager.refresh();
                return SEARCHING_FINISHED;
            }

            @Override
            public SearchState searchInputReceived(SearchStateManager manager) {
                manager.focusInput();
                return SEARCHING_AUTOCOMPLETE_VISIBLE.searchInputReceived(manager);
            }

            @Override
            public SearchState autocompleteStartNavigation(SearchStateManager manager) {
                VConsole.log((String)"WARNING: attempting to start navigation when it has already started");
                return this;
            }

            @Override
            public SearchState currentEntrySelected(SearchStateManager manager) {
                manager.hideAutocomplete();
                manager.entrySelected();
                manager.focusInput();
                manager.updateHistorySearchString();
                manager.refresh();
                return SEARCHING_FINISHED;
            }

            @Override
            public SearchState updateMatchCount(SearchStateManager manager, int matchCount) {
                if (matchCount == 0) {
                    manager.hideAutocomplete();
                    return SEARCHING_AUTOCOMPLETE_HIDDEN;
                }
                return this;
            }
        }
        ,
        SEARCHING_AUTOCOMPLETE_HIDDEN{

            @Override
            public SearchState initialize(SearchStateManager manager) {
                manager.focusInput();
                manager.hideAutocomplete();
                manager.refresh();
                return this;
            }

            @Override
            public SearchState cancelSearching(SearchStateManager manager) {
                manager.clearSearchInput();
                manager.focusInput();
                manager.hideAutocomplete();
                manager.updateHistorySearchString();
                manager.refresh();
                return NOT_SEARCHING;
            }

            @Override
            public SearchState finishedSearching(SearchStateManager manager) {
                manager.hideAutocomplete();
                manager.focusInput();
                manager.updateHistorySearchString();
                manager.refresh();
                return SEARCHING_FINISHED;
            }

            @Override
            public SearchState currentEntrySelected(SearchStateManager manager) {
                VConsole.log((String)"Current entry got selected, but there is no current entry visible!");
                return this;
            }

            @Override
            public SearchState searchInputReceived(SearchStateManager manager) {
                manager.refresh();
                return this;
            }

            @Override
            public SearchState autocompleteStartNavigation(SearchStateManager manager) {
                VConsole.log((String)"Autocomplete is already hidden because of a previous match count update, this doesn't make sense!");
                return this;
            }

            @Override
            public SearchState updateMatchCount(SearchStateManager manager, int matchCount) {
                if (matchCount > 0) {
                    manager.showAutocomplete();
                    return SEARCHING_AUTOCOMPLETE_VISIBLE;
                }
                return this;
            }
        }
        ,
        SEARCHING_FINISHED{

            @Override
            public SearchState initialize(SearchStateManager manager) {
                manager.focusInput();
                manager.hideAutocomplete();
                manager.refresh();
                return this;
            }

            @Override
            public SearchState cancelSearching(SearchStateManager manager) {
                manager.clearSearchInput();
                manager.focusInput();
                manager.hideAutocomplete();
                manager.updateHistorySearchString();
                manager.refresh();
                return NOT_SEARCHING;
            }

            @Override
            public SearchState autocompleteStartNavigation(SearchStateManager manager) {
                manager.showAutocomplete();
                manager.focusAutocomplete();
                manager.refresh();
                return SEARCHING_AUTOCOMPLETE_ACTIVE;
            }

            @Override
            public SearchState searchInputReceived(SearchStateManager manager) {
                manager.refresh();
                manager.showAutocomplete();
                manager.focusInput();
                return SEARCHING_AUTOCOMPLETE_VISIBLE;
            }

            @Override
            public SearchState finishedSearching(SearchStateManager manager) {
                VConsole.log((String)"WARNING: attempting to finish search, but we're already finished!");
                return this;
            }

            @Override
            public SearchState currentEntrySelected(SearchStateManager manager) {
                VConsole.log((String)"WARNING: attempting to select an entry, but we're already finished!");
                return this;
            }

            @Override
            public SearchState updateMatchCount(SearchStateManager manager, int matchCount) {
                return this;
            }
        };

    }

    static interface SearchState {
        public SearchState initialize(SearchStateManager var1);

        public SearchState cancelSearching(SearchStateManager var1);

        public SearchState finishedSearching(SearchStateManager var1);

        public SearchState currentEntrySelected(SearchStateManager var1);

        public SearchState searchInputReceived(SearchStateManager var1);

        public SearchState autocompleteStartNavigation(SearchStateManager var1);

        public SearchState updateMatchCount(SearchStateManager var1, int var2);
    }
}

