/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.vaadin.nodemaps.internal.gwt.client.ui.controls.alarm;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.dom.client.Node;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Widget;
import com.vaadin.terminal.gwt.client.VConsole;
import org.discotools.gwt.leaflet.client.controls.Control;
import org.discotools.gwt.leaflet.client.jsobject.JSObject;
import org.discotools.gwt.leaflet.client.map.Map;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.SearchConsumer;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.event.DomEvent;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.event.SearchEventCallback;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.ui.controls.alarm.AlarmControlBundle;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.ui.controls.alarm.AlarmControlCss;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.ui.controls.alarm.AlarmControlImpl;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.ui.controls.alarm.AlarmControlOptions;

public class AlarmControl
extends Control {
    private ListBox m_severityBox;
    private final SearchConsumer m_searchConsumer;
    private SearchEventCallback m_onChange;

    public AlarmControl(SearchConsumer searchConsumer) {
        this(searchConsumer, new AlarmControlOptions());
    }

    public AlarmControl(SearchConsumer searchConsumer, AlarmControlOptions options) {
        super(JSObject.createJSObject());
        this.setJSObject(AlarmControlImpl.create(this, options.getJSObject()));
        VConsole.log((String)"new AlarmControl()");
        this.m_searchConsumer = searchConsumer;
    }

    public Element doOnAdd(JavaScriptObject map) {
        VConsole.log((String)"doOnAdd() called");
        AlarmControlCss css = AlarmControlBundle.INSTANCE.css();
        css.ensureInjected();
        Element element = AlarmControlImpl.createElement("leaflet-control-alarm");
        element.addClassName("leaflet-control");
        Label label = new Label("Show Severity >=");
        label.getElement().setAttribute("for", "alarmControl");
        label.addStyleName(css.label());
        element.appendChild((Node)label.getElement());
        this.m_severityBox = new ListBox(false);
        this.m_severityBox.getElement().setId("alarmControl");
        this.m_severityBox.addItem("Normal", "0");
        this.m_severityBox.addItem("Warning", "4");
        this.m_severityBox.addItem("Minor", "5");
        this.m_severityBox.addItem("Major", "6");
        this.m_severityBox.addItem("Critical", "7");
        DomEvent.stopEventPropagation((Widget)this.m_severityBox);
        this.m_onChange = new SearchEventCallback("change", (Widget)this.m_severityBox, this.m_searchConsumer){

            @Override
            protected void onEvent(NativeEvent event) {
                Widget widget = this.getWidget();
                final SearchConsumer searchConsumer = this.getSearchConsumer();
                ListBox severityBox = (ListBox)widget;
                int selected = severityBox.getSelectedIndex();
                VConsole.log((String)("new selection index = " + selected));
                String value = severityBox.getValue(selected);
                VConsole.log((String)("new severity = " + value));
                if (value != null && searchConsumer != null) {
                    final int severity = Integer.valueOf(value);
                    searchConsumer.setMinimumSeverity(severity);
                    Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                        public void execute() {
                            searchConsumer.refresh();
                            VConsole.log((String)("successfully set new severity to " + severity));
                        }
                    });
                }
            }
        };
        DomEvent.addListener(this.m_onChange);
        this.m_severityBox.addStyleName(css.label());
        element.appendChild((Node)this.m_severityBox.getElement());
        VConsole.log((String)("doOnAdd() finished, returning: " + element));
        return element;
    }

    public void doOnRemove(JavaScriptObject map) {
        VConsole.log((String)"doOnRemove() called");
        DomEvent.removeListener(this.m_onChange);
        if (this.m_searchConsumer != null) {
            this.m_searchConsumer.clearSearch();
        }
    }

    public AlarmControl addTo(Map map) {
        return (AlarmControl)super.addTo(map);
    }

    public AlarmControl setPosition(String position) {
        return (AlarmControl)super.setPosition(position);
    }

    public AlarmControl removeFrom(Map map) {
        return (AlarmControl)super.removeFrom(map);
    }
}

