/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.vaadin.nodemaps.internal.gwt.client.ui;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.Widget;
import com.vaadin.terminal.gwt.client.ApplicationConnection;
import com.vaadin.terminal.gwt.client.Paintable;
import com.vaadin.terminal.gwt.client.UIDL;
import com.vaadin.terminal.gwt.client.VConsole;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.discotools.gwt.leaflet.client.types.Icon;
import org.discotools.gwt.leaflet.client.types.IconOptions;
import org.discotools.gwt.leaflet.client.types.LatLng;
import org.discotools.gwt.leaflet.client.types.Point;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.NodeMarker;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.event.NodeMarkerClusterCallback;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.ui.GWTMapWidget;

public class VMapWidget
extends GWTMapWidget
implements Paintable {
    private ApplicationConnection m_client;
    private String m_uidlId;
    private boolean m_firstRun = true;
    private Map<String, Icon> m_icons;

    public VMapWidget() {
        this.setStyleName("v-openlayers");
        VConsole.log((String)("div ID = " + this.getElement().getId()));
    }

    private static final native boolean isRetina();

    public void updateFromUIDL(UIDL uidl, ApplicationConnection client) {
        if (client.updateComponent((Widget)this, uidl, true)) {
            return;
        }
        this.m_client = client;
        this.m_uidlId = uidl.getId();
        this.initializeIcons();
        if (uidl.hasAttribute("initialSearchString")) {
            this.setSearchString(uidl.getStringAttribute("initialSearchString"));
        }
        UIDL nodeUIDL = uidl.getChildByTagName("nodes");
        ArrayList<NodeMarker> featureCollection = new ArrayList<NodeMarker>();
        Iterator iterator = nodeUIDL.getChildIterator();
        while (iterator.hasNext()) {
            UIDL node = (UIDL)iterator.next();
            double latitude = Float.valueOf(node.getFloatAttribute("latitude")).doubleValue();
            double longitude = Float.valueOf(node.getFloatAttribute("longitude")).doubleValue();
            NodeMarker marker = new NodeMarker(new LatLng(latitude, longitude));
            for (String key : new String[]{"nodeId", "nodeLabel", "foreignSource", "foreignId", "description", "maintcontract", "ipAddress", "severity", "severityLabel", "unackedCount"}) {
                if (!node.hasAttribute(key)) continue;
                marker.putProperty(key, node.getStringAttribute(key));
            }
            if (node.hasAttribute("categories")) {
                marker.setCategories(node.getStringArrayAttribute("categories"));
            }
            if (this.m_icons.containsKey(marker.getSeverityLabel())) {
                marker.setIcon(this.m_icons.get(marker.getSeverityLabel()));
            } else {
                marker.setIcon(this.m_icons.get("Normal"));
            }
            marker.bindPopup(NodeMarkerClusterCallback.getPopupTextForMarker(marker));
            featureCollection.add(marker);
        }
        this.setMarkers(featureCollection);
        Scheduler.get().scheduleDeferred((Scheduler.ScheduledCommand)new Command(){

            public void execute() {
                VMapWidget.this.updateMarkerClusterLayer();
            }
        });
    }

    private void initializeIcons() {
        if (this.m_icons == null) {
            this.m_icons = new HashMap<String, Icon>();
            String basepath = this.m_client.getAppUri();
            for (String severity : new String[]{"Normal", "Warning", "Minor", "Major", "Critical"}) {
                IconOptions options = new IconOptions();
                options.setIconSize(new Point(25.0, 41.0));
                options.setIconAnchor(new Point(12.0, 41.0));
                options.setPopupAnchor(new Point(1.0, -34.0));
                options.setShadowUrl(new Point(41.0, 41.0));
                if (VMapWidget.isRetina()) {
                    options.setIconUrl(basepath + "../VAADIN/widgetsets/org.opennms.features.vaadin.nodemaps.internal.gwt.NodeMapsWidgetset/images/" + severity + "@2x.png");
                } else {
                    options.setIconUrl(basepath + "../VAADIN/widgetsets/org.opennms.features.vaadin.nodemaps.internal.gwt.NodeMapsWidgetset/images/" + severity + ".png");
                }
                Icon icon = new Icon(options);
                this.m_icons.put(severity, icon);
            }
        }
    }
}

