/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.vaadin.nodemaps.internal.gwt.client.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.MarkerProvider;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.NodeMarker;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.ui.MarkerFilter;

public class MarkerContainer
implements MarkerProvider {
    final List<NodeMarker> m_markers = new ArrayList<NodeMarker>();
    final List<NodeMarker> m_filteredMarkers = new ArrayList<NodeMarker>();
    private MarkerFilter m_filter;

    public MarkerContainer(MarkerFilter filter) {
        this.m_filter = filter;
    }

    public int size() {
        return this.getMarkers().size();
    }

    public ListIterator<NodeMarker> listIterator() {
        return this.getMarkers().listIterator();
    }

    public List<NodeMarker> getDisabledMarkers() {
        ArrayList<NodeMarker> markers = new ArrayList<NodeMarker>();
        for (NodeMarker marker : this.m_markers) {
            if (this.m_filteredMarkers.contains((Object)marker)) continue;
            markers.add(marker);
        }
        return Collections.unmodifiableList(markers);
    }

    @Override
    public List<NodeMarker> getMarkers() {
        return Collections.unmodifiableList(this.m_filteredMarkers);
    }

    public void setMarkers(List<NodeMarker> markers) {
        if (this.m_markers != markers) {
            this.m_markers.clear();
            this.m_markers.addAll(markers);
        }
        this.refresh();
    }

    public void refresh() {
        this.m_filteredMarkers.clear();
        for (NodeMarker marker : this.m_markers) {
            if (!this.m_filter.matches(marker)) continue;
            this.m_filteredMarkers.add(marker);
        }
    }
}

