/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.vaadin.nodemaps.internal;

import com.vaadin.Application;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.opennms.core.utils.LogUtils;
import org.opennms.features.geocoder.GeocoderService;
import org.opennms.features.vaadin.nodemaps.internal.NodeMapsApplication;
import org.opennms.netmgt.dao.AlarmDao;
import org.opennms.netmgt.dao.AssetRecordDao;
import org.opennms.netmgt.dao.NodeDao;
import org.opennms.web.api.OnmsHeaderProvider;
import org.ops4j.pax.vaadin.AbstractApplicationFactory;
import org.springframework.transaction.support.TransactionOperations;

public class NodeMapsApplicationFactory
extends AbstractApplicationFactory {
    private NodeDao m_nodeDao;
    private AssetRecordDao m_assetDao;
    private AlarmDao m_alarmDao;
    private GeocoderService m_geocoder;
    private TransactionOperations m_transaction;
    private OnmsHeaderProvider m_headerProvider;

    public Application createApplication(HttpServletRequest request) throws ServletException {
        if (this.m_nodeDao == null) {
            throw new RuntimeException("m_nodeDao cannot be null.");
        }
        NodeMapsApplication app = new NodeMapsApplication();
        app.setNodeDao(this.m_nodeDao);
        app.setAssetRecordDao(this.m_assetDao);
        app.setAlarmDao(this.m_alarmDao);
        app.setGeocoderService(this.m_geocoder);
        app.setTransactionOperations(this.m_transaction);
        if (this.m_headerProvider != null) {
            try {
                app.setHeaderHtml(this.m_headerProvider.getHeaderHtml(request));
            }
            catch (Exception e) {
                LogUtils.warnf((Object)((Object)this), (Throwable)e, (String)("failed to get header HTML for request " + request.getPathInfo()), (Object[])new Object[0]);
            }
        }
        return app;
    }

    public Class<? extends Application> getApplicationClass() throws ClassNotFoundException {
        return NodeMapsApplication.class;
    }

    public void setNodeDao(NodeDao nodeDao) {
        this.m_nodeDao = nodeDao;
    }

    public void setAssetDao(AssetRecordDao assetDao) {
        this.m_assetDao = assetDao;
    }

    public void setAlarmDao(AlarmDao alarmDao) {
        this.m_alarmDao = alarmDao;
    }

    public void setGeocoderService(GeocoderService geocoderService) {
        this.m_geocoder = geocoderService;
    }

    public void setTransactionOperations(TransactionOperations tx) {
        this.m_transaction = tx;
    }

    public void setHeaderProvider(OnmsHeaderProvider headerProvider) {
        this.m_headerProvider = headerProvider;
    }
}

