/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.vaadin.nodemaps.internal;

import com.github.wolfie.refresher.Refresher;
import com.vaadin.Application;
import com.vaadin.terminal.ParameterHandler;
import com.vaadin.terminal.gwt.client.VConsole;
import com.vaadin.ui.AbsoluteLayout;
import com.vaadin.ui.Component;
import com.vaadin.ui.ComponentContainer;
import com.vaadin.ui.CustomLayout;
import com.vaadin.ui.Panel;
import com.vaadin.ui.Window;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.opennms.features.geocoder.GeocoderService;
import org.opennms.features.vaadin.nodemaps.internal.MapWidgetComponent;
import org.opennms.netmgt.dao.AlarmDao;
import org.opennms.netmgt.dao.AssetRecordDao;
import org.opennms.netmgt.dao.NodeDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.support.TransactionOperations;

public class NodeMapsApplication
extends Application {
    private static final int REFRESH_INTERVAL = 300000;
    private NodeDao m_nodeDao;
    private AssetRecordDao m_assetDao;
    private AlarmDao m_alarmDao;
    private GeocoderService m_geocoderService;
    private TransactionOperations m_transaction;
    private String m_headerHtml;
    private Window m_window;
    private AbsoluteLayout m_rootLayout;
    private Logger m_log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public void setNodeDao(NodeDao nodeDao) {
        this.m_nodeDao = nodeDao;
    }

    public void setAssetRecordDao(AssetRecordDao assetDao) {
        this.m_assetDao = assetDao;
    }

    public void setAlarmDao(AlarmDao alarmDao) {
        this.m_alarmDao = alarmDao;
    }

    public void setGeocoderService(GeocoderService geocoderService) {
        this.m_geocoderService = geocoderService;
    }

    public void setTransactionOperations(TransactionOperations tx) {
        this.m_transaction = tx;
    }

    public void setHeaderHtml(String headerHtml) {
        this.m_headerHtml = headerHtml;
    }

    public void init() {
        this.m_log.debug("initializing");
        this.setTheme("opennms");
        final MapWidgetComponent mapPanel = new MapWidgetComponent();
        mapPanel.setNodeDao(this.m_nodeDao);
        mapPanel.setAssetRecordDao(this.m_assetDao);
        mapPanel.setAlarmDao(this.m_alarmDao);
        mapPanel.setGeocoderService(this.m_geocoderService);
        mapPanel.setTransactionOperation(this.m_transaction);
        mapPanel.setSizeFull();
        this.m_rootLayout = new AbsoluteLayout();
        this.m_rootLayout.setSizeFull();
        this.m_window = new Window("OpenNMS Node Maps");
        this.m_window.setContent((ComponentContainer)this.m_rootLayout);
        this.m_window.addParameterHandler(new ParameterHandler(){

            public void handleParameters(Map<String, String[]> parameters) {
                if (parameters.containsKey("search")) {
                    mapPanel.setSearchString(parameters.get("search")[0].toString());
                }
            }
        });
        this.setMainWindow(this.m_window);
        String mapLayerPosition = "top:0px; left:0px; right:0px; bottom:0px;";
        if (this.m_headerHtml != null) {
            Panel header = new Panel("header");
            header.setCaption(null);
            header.setSizeUndefined();
            header.addStyleName("onmsheader");
            ByteArrayInputStream is = null;
            try {
                is = new ByteArrayInputStream(this.m_headerHtml.getBytes());
                CustomLayout layout = new CustomLayout((InputStream)is);
                header.setContent((ComponentContainer)layout);
                this.m_rootLayout.addComponent((Component)header, "top: 0px; left: 0px; right:0px;");
                mapLayerPosition = "top:100px; left:0px; right:0px; bottom:0px;";
            }
            catch (IOException e) {
                if (is != null) {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (IOException closeE) {
                        VConsole.log((String)"failed to close HTML input stream");
                        VConsole.log((Throwable)closeE);
                    }
                }
                VConsole.log((String)"failed to get header layout data");
                VConsole.log((Throwable)e);
            }
        }
        this.m_rootLayout.addComponent((Component)mapPanel, mapLayerPosition);
        Refresher refresher = new Refresher();
        refresher.setRefreshInterval(300000L);
        this.m_window.addComponent((Component)refresher);
    }

    public int parseInt(String intStr, int defaultValue) {
        try {
            return Integer.parseInt(intStr);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }
}

