/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.vaadin.dashboard.dashlets;

import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.opennms.netmgt.dao.api.GraphDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.dao.api.ResourceDao;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsResource;
import org.opennms.netmgt.model.OnmsResourceType;
import org.opennms.netmgt.model.PrefabGraph;
import org.opennms.web.api.Util;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionOperations;

public class RrdGraphHelper {
    private ResourceDao m_resourceDao;
    private GraphDao m_graphDao;
    private NodeDao m_nodeDao;
    private TransactionOperations m_transactionOperations;

    public String imageUrlForGraph(String query, int width, int height, int calendarField, int calendarDiff) {
        GregorianCalendar cal = new GregorianCalendar();
        long end = cal.getTime().getTime();
        ((Calendar)cal).add(calendarField, -calendarDiff);
        long start = cal.getTime().getTime();
        return "/opennms/graph/graph.png?" + query + "&start=" + start + "&end=" + end + (width > 0 ? "&width=" + width : "") + (height > 0 ? "&height=" + height : "");
    }

    public String imageUrlForGraph(String query, int width, int height) {
        return this.imageUrlForGraph(query, width, height, 11, 1);
    }

    public Map<String, String> getGraphNameTitleMappingForResourceId(final String resourceId) {
        return (Map)this.m_transactionOperations.execute((TransactionCallback)new TransactionCallback<Map<String, String>>(){

            public Map<String, String> doInTransaction(TransactionStatus transactionStatus) {
                OnmsResource resource = RrdGraphHelper.this.m_resourceDao.getResourceById(resourceId);
                PrefabGraph[] queries = RrdGraphHelper.this.m_graphDao.getPrefabGraphsForResource(resource);
                TreeMap<String, String> graphResults = new TreeMap<String, String>();
                for (PrefabGraph query : queries) {
                    graphResults.put(query.getName(), query.getTitle());
                }
                return graphResults;
            }
        });
    }

    public Map<String, String> getGraphTitleNameMappingForResourceId(final String resourceId) {
        return (Map)this.m_transactionOperations.execute((TransactionCallback)new TransactionCallback<Map<String, String>>(){

            public Map<String, String> doInTransaction(TransactionStatus transactionStatus) {
                OnmsResource resource = RrdGraphHelper.this.m_resourceDao.getResourceById(resourceId);
                PrefabGraph[] queries = RrdGraphHelper.this.m_graphDao.getPrefabGraphsForResource(resource);
                TreeMap<String, String> graphResults = new TreeMap<String, String>();
                for (PrefabGraph query : queries) {
                    graphResults.put(query.getTitle(), query.getName());
                }
                return graphResults;
            }
        });
    }

    public Map<String, String> getGraphResultsForResourceId(final String resourceId) {
        return (Map)this.m_transactionOperations.execute((TransactionCallback)new TransactionCallback<Map<String, String>>(){

            public Map<String, String> doInTransaction(TransactionStatus transactionStatus) {
                OnmsResource resource = RrdGraphHelper.this.m_resourceDao.getResourceById(resourceId);
                PrefabGraph[] queries = RrdGraphHelper.this.m_graphDao.getPrefabGraphsForResource(resource);
                TreeMap<String, String> graphResults = new TreeMap<String, String>();
                for (PrefabGraph query : queries) {
                    graphResults.put(query.getName(), "resourceId=" + resourceId + "&report=" + query.getName());
                }
                return graphResults;
            }
        });
    }

    public Map<OnmsResourceType, List<OnmsResource>> getResourceTypeMapForNodeId(int nodeId) {
        return this.getResourceTypeMapForNodeId(String.valueOf(nodeId));
    }

    public Map<OnmsResourceType, List<OnmsResource>> getResourceTypeMapForNodeId(final String nodeId) {
        return (Map)this.m_transactionOperations.execute((TransactionCallback)new TransactionCallback<Map<OnmsResourceType, List<OnmsResource>>>(){

            public Map<OnmsResourceType, List<OnmsResource>> doInTransaction(TransactionStatus transactionStatus) {
                OnmsResource resource = RrdGraphHelper.this.m_resourceDao.getResourceById("node[" + nodeId + "]");
                LinkedHashMap<OnmsResourceType, List<OnmsResource>> resourceTypeMap = new LinkedHashMap<OnmsResourceType, List<OnmsResource>>();
                for (OnmsResource childResource : resource.getChildResources()) {
                    if (!resourceTypeMap.containsKey(childResource.getResourceType())) {
                        resourceTypeMap.put(childResource.getResourceType(), new LinkedList());
                    }
                    ((List)resourceTypeMap.get(childResource.getResourceType())).add(RrdGraphHelper.this.checkLabelForQuotes(childResource));
                }
                return resourceTypeMap;
            }
        });
    }

    public List<OnmsNode> getNodesWithResources() {
        return (List)this.m_transactionOperations.execute((TransactionCallback)new TransactionCallback<List<OnmsNode>>(){

            public List<OnmsNode> doInTransaction(TransactionStatus transactionStatus) {
                List onmsNodeList = RrdGraphHelper.this.m_nodeDao.findAll();
                for (int i = onmsNodeList.size() - 1; i >= 0; --i) {
                    OnmsResource resource = RrdGraphHelper.this.m_resourceDao.getResourceById("node[" + ((OnmsNode)onmsNodeList.get(i)).getId() + "]");
                    if (resource.getChildResources().size() != 0) continue;
                    onmsNodeList.remove(i);
                }
                return onmsNodeList;
            }
        });
    }

    private OnmsResource checkLabelForQuotes(OnmsResource childResource) {
        String lbl = Util.convertToJsSafeString((String)childResource.getLabel());
        OnmsResource resource = new OnmsResource(childResource.getName(), lbl, childResource.getResourceType(), childResource.getAttributes());
        resource.setParent(childResource.getParent());
        resource.setEntity(childResource.getEntity());
        resource.setLink(childResource.getLink());
        return resource;
    }

    public void setNodeDao(NodeDao nodeDao) {
        this.m_nodeDao = nodeDao;
    }

    public void setGraphDao(GraphDao graphDao) {
        this.m_graphDao = graphDao;
    }

    public void setResourceDao(ResourceDao resourceDao) {
        this.m_resourceDao = resourceDao;
    }

    public void setTransactionOperations(TransactionOperations transactionOperations) {
        this.m_transactionOperations = transactionOperations;
    }
}

