/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.vaadin.dashboard.config.ui.editors;

import com.google.gwt.thirdparty.guava.common.primitives.Primitives;
import java.beans.Introspector;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.features.vaadin.dashboard.config.ui.editors.CriteriaParser;
import org.opennms.features.vaadin.dashboard.config.ui.editors.CriteriaRestriction;
import org.opennms.netmgt.model.OnmsSeverity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CriteriaBuilderHelper {
    private static final Logger LOG = LoggerFactory.getLogger(CriteriaBuilderHelper.class);
    private Map<String, Class<?>> m_entities = new LinkedHashMap();
    private Map<Class<?>, CriteriaParser<?>> m_parsers = new HashMap();

    public CriteriaBuilderHelper(Class<?> entityType, Class<?> ... aliasTypes) {
        this.setCriteriaParser(Integer.class, new CriteriaParser<Integer>(){

            @Override
            public Integer parse(String string) {
                int integer = 0;
                try {
                    integer = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    return null;
                }
                return integer;
            }

            @Override
            public Integer getDefault() {
                return 0;
            }
        });
        this.setCriteriaParser(String.class, new CriteriaParser<String>(){

            @Override
            public String parse(String string) {
                return string;
            }

            @Override
            public String getDefault() {
                return "foo";
            }
        });
        this.setCriteriaParser(OnmsSeverity.class, new CriteriaParser<OnmsSeverity>(){

            @Override
            public OnmsSeverity parse(String string) {
                for (OnmsSeverity onmsSeverity : OnmsSeverity.values()) {
                    if (!onmsSeverity.name().toLowerCase().equals(string.toLowerCase())) continue;
                    return onmsSeverity;
                }
                return null;
            }

            @Override
            public OnmsSeverity getDefault() {
                return OnmsSeverity.CLEARED;
            }
        });
        this.setCriteriaParser(Date.class, new CriteriaParser<Date>(){

            @Override
            public Date parse(String string) {
                Date date = null;
                try {
                    date = DateFormat.getDateInstance().parse(string);
                }
                catch (ParseException e) {
                    return null;
                }
                return date;
            }

            @Override
            public Date getDefault() {
                return new Date();
            }
        });
        this.setCriteriaParser(InetAddress.class, new CriteriaParser<InetAddress>(){

            @Override
            public InetAddress parse(String string) {
                InetAddress inetAddress = null;
                try {
                    inetAddress = InetAddress.getByName(string);
                }
                catch (UnknownHostException e) {
                    return null;
                }
                catch (SecurityException e) {
                    return null;
                }
                return inetAddress;
            }

            @Override
            public InetAddress getDefault() {
                InetAddress inetAddress = null;
                try {
                    inetAddress = InetAddress.getByName("127.0.0.1");
                }
                catch (UnknownHostException e) {
                    return null;
                }
                catch (SecurityException e) {
                    return null;
                }
                return inetAddress;
            }
        });
        this.populateProperties(entityType, false);
        TreeMap sortedMap = new TreeMap();
        for (Class<?> clazz : aliasTypes) {
            sortedMap.put(clazz.getSimpleName(), clazz);
        }
        for (Map.Entry entry : sortedMap.entrySet()) {
            this.populateProperties((Class)entry.getValue(), true);
        }
    }

    public Object parseCriteriaValue(Class<?> clazz, String value) {
        CriteriaParser<?> criteriaParser = this.m_parsers.get(clazz);
        if (criteriaParser == null) {
            LoggerFactory.getLogger(CriteriaBuilderHelper.class).error("No parser for class " + clazz.getSimpleName() + " found");
            return null;
        }
        return criteriaParser.parse(value);
    }

    public Class<?> getTypeOfProperty(String property) {
        return this.m_entities.get(property);
    }

    public void setCriteriaParser(Class<?> clazz, CriteriaParser<?> criteriaParser) {
        this.m_parsers.put(clazz, criteriaParser);
    }

    public void parseConfiguration(CriteriaBuilder criteriaBuilder, String configurationString) {
        String[] entries;
        for (String entry : entries = configurationString.split("(?<=[\\)])\\.")) {
            String[] entryParts = entry.split("(?<!\\\\)[\\(\\),]", -1);
            CriteriaRestriction criteriaRestriction = CriteriaRestriction.valueOfIgnoreCase(entryParts[0]);
            criteriaRestriction.addRestrictionToCriteriaBuilder(this, criteriaBuilder, Arrays.copyOfRange(entryParts, 1, entryParts.length));
        }
    }

    public void dump() {
        for (Map.Entry<String, Class<?>> entry : this.m_entities.entrySet()) {
            LOG.debug("{} {}", (Object)entry.getKey(), (Object)entry.getValue().getSimpleName());
        }
    }

    public Set<String> getEntities() {
        return this.m_entities.keySet();
    }

    private void populateProperties(Class<?> entityClass, boolean alias) {
        TreeMap<String, Class> sortedMap = new TreeMap<String, Class>(new Comparator<String>(){

            @Override
            public int compare(String a, String b) {
                return a.toLowerCase().compareTo(b.toLowerCase());
            }
        });
        String aliasName = null;
        if (alias) {
            aliasName = entityClass.getSimpleName().replaceAll("Onms", "").toLowerCase();
        }
        for (Method method : entityClass.getDeclaredMethods()) {
            Annotation[] annotations;
            for (Annotation annotation : annotations = method.getAnnotations()) {
                if (!"javax.persistence.Column".equals(annotation.annotationType().getName())) continue;
                String propertyName = Introspector.decapitalize(method.getName().replace("get", ""));
                Class clazz = Primitives.wrap(method.getReturnType());
                if (this.m_parsers.containsKey(clazz)) {
                    if (aliasName != null) {
                        sortedMap.put(aliasName + "." + propertyName, clazz);
                        continue;
                    }
                    sortedMap.put(propertyName, clazz);
                    continue;
                }
                LoggerFactory.getLogger(CriteriaBuilderHelper.class).warn("No parser for class " + clazz.getSimpleName() + " found, ignoring property " + propertyName);
            }
        }
        for (Map.Entry entry : sortedMap.entrySet()) {
            this.m_entities.put(entry.getKey(), (Class<?>)entry.getValue());
        }
    }
}

