/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.topo.vmware.internal;

import com.google.common.collect.Lists;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.opennms.features.topology.api.GraphContainer;
import org.opennms.features.topology.api.OperationContext;
import org.opennms.features.topology.api.support.VertexHopGraphProvider;
import org.opennms.features.topology.api.topo.AbstractVertex;
import org.opennms.features.topology.api.topo.Criteria;
import org.opennms.features.topology.api.topo.Edge;
import org.opennms.features.topology.api.topo.EdgeRef;
import org.opennms.features.topology.api.topo.GraphProvider;
import org.opennms.features.topology.api.topo.SearchProvider;
import org.opennms.features.topology.api.topo.SearchQuery;
import org.opennms.features.topology.api.topo.SearchResult;
import org.opennms.features.topology.api.topo.Vertex;
import org.opennms.features.topology.api.topo.VertexRef;
import org.opennms.features.topology.plugins.topo.simple.SimpleGraphProvider;
import org.opennms.netmgt.dao.api.IpInterfaceDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VmwareTopologyProvider
extends SimpleGraphProvider
implements GraphProvider,
SearchProvider {
    public static final String TOPOLOGY_NAMESPACE_VMWARE = "vmware";
    private static final Logger LOG = LoggerFactory.getLogger(VmwareTopologyProvider.class);
    private static final String SPLIT_REGEXP = " *, *";
    private NodeDao m_nodeDao;
    private IpInterfaceDao m_ipInterfaceDao;
    private boolean m_generated = false;

    public VmwareTopologyProvider() {
        super(TOPOLOGY_NAMESPACE_VMWARE);
    }

    public NodeDao getNodeDao() {
        return this.m_nodeDao;
    }

    public void setNodeDao(NodeDao nodeDao) {
        this.m_nodeDao = nodeDao;
    }

    public IpInterfaceDao getIpInterfaceDao() {
        return this.m_ipInterfaceDao;
    }

    public void setIpInterfaceDao(IpInterfaceDao ipInterfaceDao) {
        this.m_ipInterfaceDao = ipInterfaceDao;
    }

    public boolean isGenerated() {
        return this.m_generated;
    }

    public void debug(Vertex vmwareVertex) {
        LOG.debug("-+- id: {}", (Object)vmwareVertex.getId());
        LOG.debug(" |- hashCode: {}", (Object)vmwareVertex.hashCode());
        LOG.debug(" |- label: {}", (Object)vmwareVertex.getLabel());
        LOG.debug(" |- ip: {}", (Object)vmwareVertex.getIpAddress());
        LOG.debug(" |- iconKey: {}", (Object)vmwareVertex.getIconKey());
        LOG.debug(" |- nodeId: {}", (Object)vmwareVertex.getNodeID());
        for (EdgeRef edge : this.getEdgeIdsForVertex((VertexRef)vmwareVertex)) {
            Edge vmwareEdge = this.getEdge(edge);
            VertexRef edgeTo = vmwareEdge.getTarget().getVertex();
            if (vmwareVertex.equals(edgeTo)) {
                edgeTo = vmwareEdge.getSource().getVertex();
            }
            LOG.debug(" |- edgeTo: {}", (Object)edgeTo);
        }
        LOG.debug(" '- parent: {}", vmwareVertex.getParent() == null ? null : vmwareVertex.getParent().getId());
    }

    public void debugAll() {
        for (Vertex id : this.getVertices(new Criteria[0])) {
            this.debug(id);
        }
    }

    private AbstractVertex addDatacenterGroup(String vertexId, String groupName) {
        if (this.containsVertexId(vertexId)) {
            return (AbstractVertex)this.getVertex(TOPOLOGY_NAMESPACE_VMWARE, vertexId);
        }
        return this.addGroup(vertexId, "DATACENTER_ICON", groupName);
    }

    private AbstractVertex addNetworkVertex(String vertexId, String vertexName) {
        if (this.containsVertexId(vertexId)) {
            return (AbstractVertex)this.getVertex(TOPOLOGY_NAMESPACE_VMWARE, vertexId);
        }
        AbstractVertex vertex = this.addVertex(vertexId, 50, 50);
        vertex.setIconKey("NETWORK_ICON");
        vertex.setLabel(vertexName);
        return vertex;
    }

    private AbstractVertex addDatastoreVertex(String vertexId, String vertexName) {
        if (this.containsVertexId(vertexId)) {
            return (AbstractVertex)this.getVertex(TOPOLOGY_NAMESPACE_VMWARE, vertexId);
        }
        AbstractVertex vertex = this.addVertex(vertexId, 50, 50);
        vertex.setIconKey("DATASTORE_ICON");
        vertex.setLabel(vertexName);
        return vertex;
    }

    private AbstractVertex addVirtualMachineVertex(String vertexId, String vertexName, String primaryInterface, int id, String powerState) {
        if (this.containsVertexId(vertexId)) {
            return (AbstractVertex)this.getVertex(TOPOLOGY_NAMESPACE_VMWARE, vertexId);
        }
        String icon = "VIRTUALMACHINE_ICON_UNKNOWN";
        if ("poweredOn".equals(powerState)) {
            icon = "VIRTUALMACHINE_ICON_ON";
        } else if ("poweredOff".equals(powerState)) {
            icon = "VIRTUALMACHINE_ICON_OFF";
        } else if ("suspended".equals(powerState)) {
            icon = "VIRTUALMACHINE_ICON_SUSPENDED";
        }
        AbstractVertex vertex = this.addVertex(vertexId, 50, 50);
        vertex.setIconKey(icon);
        vertex.setLabel(vertexName);
        vertex.setIpAddress(primaryInterface);
        vertex.setNodeID(Integer.valueOf(id));
        return vertex;
    }

    private AbstractVertex addHostSystemVertex(String vertexId, String vertexName, String primaryInterface, int id, String powerState) {
        if (this.containsVertexId(vertexId)) {
            return (AbstractVertex)this.getVertex(TOPOLOGY_NAMESPACE_VMWARE, vertexId);
        }
        String icon = "HOSTSYSTEM_ICON_UNKNOWN";
        if ("poweredOn".equals(powerState)) {
            icon = "HOSTSYSTEM_ICON_ON";
        } else if ("poweredOff".equals(powerState)) {
            icon = "HOSTSYSTEM_ICON_OFF";
        } else if ("standBy".equals(powerState)) {
            icon = "HOSTSYSTEM_ICON_STANDBY";
        }
        AbstractVertex vertex = this.addVertex(vertexId, 50, 50);
        vertex.setIconKey(icon);
        vertex.setLabel(vertexName);
        vertex.setIpAddress(primaryInterface);
        vertex.setNodeID(Integer.valueOf(id));
        return vertex;
    }

    private void addHostSystem(OnmsNode hostSystem) {
        AbstractVertex hostSystemVertex;
        String[] entities;
        String vmwareManagementServer = hostSystem.getAssetRecord().getVmwareManagementServer().trim();
        String vmwareManagedObjectId = hostSystem.getAssetRecord().getVmwareManagedObjectId().trim();
        String vmwareTopologyInfo = hostSystem.getAssetRecord().getVmwareTopologyInfo().trim();
        String vmwareState = hostSystem.getAssetRecord().getVmwareState().trim();
        String datacenterMoId = null;
        String datacenterName = "Datacenter (" + vmwareManagementServer + ")";
        ArrayList<String> networks = new ArrayList<String>();
        ArrayList<String> datastores = new ArrayList<String>();
        HashMap<String, String> moIdToName = new HashMap<String, String>();
        for (String entityAndName : entities = vmwareTopologyInfo.split(SPLIT_REGEXP)) {
            String entityType;
            String[] splitBySlash = entityAndName.split("/");
            String entityId = splitBySlash[0];
            String entityName = "unknown";
            if (splitBySlash.length > 1) {
                try {
                    entityName = new String(URLDecoder.decode(splitBySlash[1], "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    LOG.error(e.getMessage(), (Throwable)e);
                }
            }
            if ("network".equals(entityType = entityId.split("-")[0])) {
                networks.add(entityId);
            }
            if ("datastore".equals(entityType)) {
                datastores.add(entityId);
            }
            if ("datacenter".equals(entityType)) {
                datacenterMoId = entityId;
            }
            moIdToName.put(entityId, entityName);
        }
        if (datacenterMoId != null) {
            datacenterName = (String)moIdToName.get(datacenterMoId) + " (" + vmwareManagementServer + ")";
        }
        AbstractVertex datacenterVertex = this.addDatacenterGroup(vmwareManagementServer, datacenterName);
        String primaryInterface = "unknown";
        OnmsIpInterface ipInterface = this.m_ipInterfaceDao.findPrimaryInterfaceByNodeId(hostSystem.getId());
        if (ipInterface != null) {
            primaryInterface = ipInterface.getIpHostName();
        }
        if (!(hostSystemVertex = this.addHostSystemVertex(vmwareManagementServer + "/" + vmwareManagedObjectId, hostSystem.getLabel(), primaryInterface, hostSystem.getId(), vmwareState)).equals((Object)datacenterVertex)) {
            this.setParent((VertexRef)hostSystemVertex, (VertexRef)datacenterVertex);
        }
        for (String network : networks) {
            AbstractVertex networkVertex = this.addNetworkVertex(vmwareManagementServer + "/" + network, (String)moIdToName.get(network));
            if (!networkVertex.equals((Object)datacenterVertex)) {
                this.setParent((VertexRef)networkVertex, (VertexRef)datacenterVertex);
            }
            this.connectVertices(vmwareManagementServer + "/" + vmwareManagedObjectId + "->" + network, (VertexRef)hostSystemVertex, (VertexRef)networkVertex, this.getEdgeNamespace());
        }
        for (String datastore : datastores) {
            AbstractVertex datastoreVertex = this.addDatastoreVertex(vmwareManagementServer + "/" + datastore, (String)moIdToName.get(datastore));
            if (!datastoreVertex.equals((Object)datacenterVertex)) {
                this.setParent((VertexRef)datastoreVertex, (VertexRef)datacenterVertex);
            }
            this.connectVertices(vmwareManagementServer + "/" + vmwareManagedObjectId + "->" + datastore, (VertexRef)hostSystemVertex, (VertexRef)datastoreVertex, this.getEdgeNamespace());
        }
    }

    private void addVirtualMachine(OnmsNode virtualMachine) {
        String[] entities;
        String vmwareManagementServer = virtualMachine.getAssetRecord().getVmwareManagementServer().trim();
        String vmwareManagedObjectId = virtualMachine.getAssetRecord().getVmwareManagedObjectId().trim();
        String vmwareTopologyInfo = virtualMachine.getAssetRecord().getVmwareTopologyInfo().trim();
        String vmwareState = virtualMachine.getAssetRecord().getVmwareState().trim();
        String datacenterMoId = null;
        String datacenterName = "Datacenter (" + vmwareManagementServer + ")";
        String vmwareHostSystemId = null;
        ArrayList<String> networks = new ArrayList<String>();
        ArrayList<String> datastores = new ArrayList<String>();
        HashMap<String, String> moIdToName = new HashMap<String, String>();
        for (String entityAndName : entities = vmwareTopologyInfo.split(SPLIT_REGEXP)) {
            String entityType;
            String[] splitBySlash = entityAndName.split("/");
            String entityId = splitBySlash[0];
            String entityName = "unknown";
            if (splitBySlash.length > 1) {
                try {
                    entityName = new String(URLDecoder.decode(splitBySlash[1], "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    LOG.error(e.getMessage(), (Throwable)e);
                }
            }
            if ("network".equals(entityType = entityId.split("-")[0])) {
                networks.add(entityId);
            }
            if ("datastore".equals(entityType)) {
                datastores.add(entityId);
            }
            if ("datacenter".equals(entityType)) {
                datacenterMoId = entityId;
            }
            if ("host".equals(entityType)) {
                vmwareHostSystemId = entityId;
            }
            moIdToName.put(entityId, entityName);
        }
        if (datacenterMoId != null) {
            datacenterName = (String)moIdToName.get(datacenterMoId) + " (" + vmwareManagementServer + ")";
        }
        if (vmwareHostSystemId == null) {
            LOG.warn("Cannot find host system id for virtual machine {}/{}", (Object)vmwareManagementServer, (Object)vmwareManagedObjectId);
        }
        AbstractVertex datacenterVertex = this.addDatacenterGroup(vmwareManagementServer, datacenterName);
        String primaryInterface = "unknown";
        OnmsIpInterface ipInterface = this.m_ipInterfaceDao.findPrimaryInterfaceByNodeId(virtualMachine.getId());
        if (ipInterface != null) {
            primaryInterface = ipInterface.getIpHostName();
        }
        AbstractVertex virtualMachineVertex = this.addVirtualMachineVertex(vmwareManagementServer + "/" + vmwareManagedObjectId, virtualMachine.getLabel(), primaryInterface, virtualMachine.getId(), vmwareState);
        if (this.containsVertexId(vmwareManagementServer + "/" + vmwareHostSystemId)) {
            if (!virtualMachineVertex.equals((Object)datacenterVertex)) {
                this.setParent((VertexRef)virtualMachineVertex, (VertexRef)datacenterVertex);
            }
        } else {
            this.addHostSystemVertex(vmwareManagementServer + "/" + vmwareHostSystemId, (String)moIdToName.get(vmwareHostSystemId) + " (not in database)", "", -1, "unknown");
        }
        this.connectVertices(vmwareManagementServer + "/" + vmwareManagedObjectId + "->" + vmwareManagementServer + "/" + vmwareHostSystemId, (VertexRef)virtualMachineVertex, (VertexRef)this.getVertex(this.getVertexNamespace(), vmwareManagementServer + "/" + vmwareHostSystemId), this.getEdgeNamespace());
    }

    public void refresh() {
        this.m_generated = true;
        this.resetContainer();
        List hostSystems = this.m_nodeDao.findAllByVarCharAssetColumn("vmwareManagedEntityType", "HostSystem");
        if (hostSystems.isEmpty()) {
            LOG.info("refresh: No host systems with defined VMware assets fields found!");
        } else {
            for (OnmsNode hostSystem : hostSystems) {
                this.addHostSystem(hostSystem);
            }
        }
        List virtualMachines = this.m_nodeDao.findAllByVarCharAssetColumn("vmwareManagedEntityType", "VirtualMachine");
        if (virtualMachines.isEmpty()) {
            LOG.info("refresh: No virtual machines with defined VMware assets fields found!");
        } else {
            for (OnmsNode virtualMachine : virtualMachines) {
                this.addVirtualMachine(virtualMachine);
            }
        }
        this.debugAll();
    }

    public void onFocusSearchResult(SearchResult searchResult, OperationContext operationContext) {
        GraphContainer m_graphContainer = operationContext.getGraphContainer();
        Vertex vertexRef = this.getVertex(searchResult.getNamespace(), searchResult.getId());
        m_graphContainer.getSelectionManager().setSelectedVertexRefs((Collection)Lists.newArrayList((Object[])new VertexRef[]{vertexRef}));
    }

    public void onDefocusSearchResult(SearchResult searchResult, OperationContext operationContext) {
        GraphContainer graphContainer = operationContext.getGraphContainer();
        Vertex vertexRef = this.getVertex(searchResult.getNamespace(), searchResult.getId());
        graphContainer.getSelectionManager().deselectVertexRefs((Collection)Lists.newArrayList((Object[])new VertexRef[]{vertexRef}));
    }

    public void onCenterSearchResult(SearchResult searchResult, GraphContainer graphContainer) {
    }

    public void onToggleCollapse(SearchResult searchResult, GraphContainer graphContainer) {
    }

    public String getSearchProviderNamespace() {
        return TOPOLOGY_NAMESPACE_VMWARE;
    }

    public boolean supportsPrefix(String searchPrefix) {
        return searchPrefix.contains("nodes=");
    }

    public Set<VertexRef> getVertexRefsBy(SearchResult searchResult, GraphContainer container) {
        return Collections.emptySet();
    }

    public void addVertexHopCriteria(SearchResult searchResult, GraphContainer container) {
        VertexHopGraphProvider.FocusNodeHopCriteria criteria = VertexHopGraphProvider.getFocusNodeHopCriteriaForContainer((GraphContainer)container);
        criteria.add((VertexRef)this.getVertex(searchResult.getNamespace(), searchResult.getId()));
    }

    public void removeVertexHopCriteria(SearchResult searchResult, GraphContainer container) {
        VertexHopGraphProvider.FocusNodeHopCriteria criteria = VertexHopGraphProvider.getFocusNodeHopCriteriaForContainer((GraphContainer)container);
        criteria.remove((VertexRef)this.getVertex(searchResult.getNamespace(), searchResult.getLabel()));
    }

    public List<SearchResult> query(SearchQuery searchQuery, GraphContainer graphContainer) {
        List vertices = this.m_vertexProvider.getVertices(new Criteria[0]);
        ArrayList searchResults = Lists.newArrayList();
        for (Vertex vertex : vertices) {
            if (!searchQuery.matches(vertex.getLabel())) continue;
            searchResults.add(new SearchResult((VertexRef)vertex));
        }
        return searchResults;
    }
}

