/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.topo.vmware.internal;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.opennms.features.topology.api.topo.AbstractVertex;
import org.opennms.features.topology.api.topo.Edge;
import org.opennms.features.topology.api.topo.EdgeRef;
import org.opennms.features.topology.api.topo.GraphProvider;
import org.opennms.features.topology.api.topo.Vertex;
import org.opennms.features.topology.api.topo.VertexRef;
import org.opennms.features.topology.plugins.topo.simple.SimpleGraphProvider;
import org.opennms.netmgt.dao.IpInterfaceDao;
import org.opennms.netmgt.dao.NodeDao;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsNode;

public class VmwareTopologyProvider
extends SimpleGraphProvider
implements GraphProvider {
    public static final String TOPOLOGY_NAMESPACE_VMWARE = "vmware";
    private final String SPLIT_REGEXP = " *, *";
    private NodeDao m_nodeDao;
    private IpInterfaceDao m_ipInterfaceDao;
    private boolean m_generated = false;

    public VmwareTopologyProvider() {
        super(TOPOLOGY_NAMESPACE_VMWARE);
    }

    public NodeDao getNodeDao() {
        return this.m_nodeDao;
    }

    public void setNodeDao(NodeDao nodeDao) {
        this.m_nodeDao = nodeDao;
    }

    public IpInterfaceDao getIpInterfaceDao() {
        return this.m_ipInterfaceDao;
    }

    public void setIpInterfaceDao(IpInterfaceDao ipInterfaceDao) {
        this.m_ipInterfaceDao = ipInterfaceDao;
    }

    public boolean isGenerated() {
        return this.m_generated;
    }

    public void debug(Vertex vmwareVertex) {
        System.err.println("-+- id: " + vmwareVertex.getId());
        System.err.println(" |- hashCode: " + vmwareVertex.hashCode());
        System.err.println(" |- label: " + vmwareVertex.getLabel());
        System.err.println(" |- ip: " + vmwareVertex.getIpAddress());
        System.err.println(" |- iconKey: " + vmwareVertex.getIconKey());
        System.err.println(" |- nodeId: " + vmwareVertex.getNodeID());
        for (EdgeRef edge : this.getEdgeIdsForVertex((VertexRef)vmwareVertex)) {
            Edge vmwareEdge = this.getEdge(edge);
            VertexRef edgeTo = vmwareEdge.getTarget().getVertex();
            if (vmwareVertex.equals(edgeTo)) {
                edgeTo = vmwareEdge.getSource().getVertex();
            }
            System.err.println(" |- edgeTo: " + edgeTo);
        }
        System.err.println(" '- parent: " + (vmwareVertex.getParent() == null ? null : vmwareVertex.getParent().getId()));
    }

    public void debugAll() {
        for (Vertex id : this.getVertices()) {
            this.debug(id);
        }
    }

    private AbstractVertex addDatacenterGroup(String vertexId, String groupName) {
        if (this.containsVertexId(vertexId)) {
            return (AbstractVertex)this.getVertex(TOPOLOGY_NAMESPACE_VMWARE, vertexId);
        }
        return this.addGroup(vertexId, "DATACENTER_ICON", groupName);
    }

    private AbstractVertex addNetworkVertex(String vertexId, String vertexName) {
        if (this.containsVertexId(vertexId)) {
            return (AbstractVertex)this.getVertex(TOPOLOGY_NAMESPACE_VMWARE, vertexId);
        }
        AbstractVertex vertex = this.addVertex(vertexId, 50, 50);
        vertex.setIconKey("NETWORK_ICON");
        vertex.setLabel(vertexName);
        return vertex;
    }

    private AbstractVertex addDatastoreVertex(String vertexId, String vertexName) {
        if (this.containsVertexId(vertexId)) {
            return (AbstractVertex)this.getVertex(TOPOLOGY_NAMESPACE_VMWARE, vertexId);
        }
        AbstractVertex vertex = this.addVertex(vertexId, 50, 50);
        vertex.setIconKey("DATASTORE_ICON");
        vertex.setLabel(vertexName);
        return vertex;
    }

    private AbstractVertex addVirtualMachineVertex(String vertexId, String vertexName, String primaryInterface, int id, String powerState) {
        if (this.containsVertexId(vertexId)) {
            return (AbstractVertex)this.getVertex(TOPOLOGY_NAMESPACE_VMWARE, vertexId);
        }
        String icon = "VIRTUALMACHINE_ICON_UNKNOWN";
        if ("poweredOn".equals(powerState)) {
            icon = "VIRTUALMACHINE_ICON_ON";
        } else if ("poweredOff".equals(powerState)) {
            icon = "VIRTUALMACHINE_ICON_OFF";
        } else if ("suspended".equals(powerState)) {
            icon = "VIRTUALMACHINE_ICON_SUSPENDED";
        }
        AbstractVertex vertex = this.addVertex(vertexId, 50, 50);
        vertex.setIconKey(icon);
        vertex.setLabel(vertexName);
        vertex.setIpAddress(primaryInterface);
        vertex.setNodeID(Integer.valueOf(id));
        return vertex;
    }

    private AbstractVertex addHostSystemVertex(String vertexId, String vertexName, String primaryInterface, int id, String powerState) {
        if (this.containsVertexId(vertexId)) {
            return (AbstractVertex)this.getVertex(TOPOLOGY_NAMESPACE_VMWARE, vertexId);
        }
        String icon = "HOSTSYSTEM_ICON_UNKNOWN";
        if ("poweredOn".equals(powerState)) {
            icon = "HOSTSYSTEM_ICON_ON";
        } else if ("poweredOff".equals(powerState)) {
            icon = "HOSTSYSTEM_ICON_OFF";
        } else if ("standBy".equals(powerState)) {
            icon = "HOSTSYSTEM_ICON_STANDBY";
        }
        AbstractVertex vertex = this.addVertex(vertexId, 50, 50);
        vertex.setIconKey(icon);
        vertex.setLabel(vertexName);
        vertex.setIpAddress(primaryInterface);
        vertex.setNodeID(Integer.valueOf(id));
        return vertex;
    }

    private void addHostSystem(OnmsNode hostSystem) {
        AbstractVertex hostSystemVertex;
        String[] entities;
        String vmwareManagementServer = hostSystem.getAssetRecord().getVmwareManagementServer().trim();
        String vmwareManagedObjectId = hostSystem.getAssetRecord().getVmwareManagedObjectId().trim();
        String vmwareTopologyInfo = hostSystem.getAssetRecord().getVmwareTopologyInfo().trim();
        String vmwareState = hostSystem.getAssetRecord().getVmwareState().trim();
        String datacenterMoId = null;
        String datacenterName = "Datacenter (" + vmwareManagementServer + ")";
        ArrayList<String> networks = new ArrayList<String>();
        ArrayList<String> datastores = new ArrayList<String>();
        HashMap<String, String> moIdToName = new HashMap<String, String>();
        for (String entityAndName : entities = vmwareTopologyInfo.split(" *, *")) {
            String entityType;
            String[] splitBySlash = entityAndName.split("/");
            String entityId = splitBySlash[0];
            String entityName = "unknown";
            if (splitBySlash.length > 1) {
                try {
                    entityName = new String(URLDecoder.decode(splitBySlash[1], "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            }
            if ("network".equals(entityType = entityId.split("-")[0])) {
                networks.add(entityId);
            }
            if ("datastore".equals(entityType)) {
                datastores.add(entityId);
            }
            if ("datacenter".equals(entityType)) {
                datacenterMoId = entityId;
            }
            moIdToName.put(entityId, entityName);
        }
        if (datacenterMoId != null) {
            datacenterName = (String)moIdToName.get(datacenterMoId) + " (" + vmwareManagementServer + ")";
        }
        AbstractVertex datacenterVertex = this.addDatacenterGroup(vmwareManagementServer, datacenterName);
        String primaryInterface = "unknown";
        OnmsIpInterface ipInterface = this.m_ipInterfaceDao.findPrimaryInterfaceByNodeId(hostSystem.getId());
        if (ipInterface != null) {
            primaryInterface = ipInterface.getIpHostName();
        }
        if (!(hostSystemVertex = this.addHostSystemVertex(vmwareManagementServer + "/" + vmwareManagedObjectId, hostSystem.getLabel(), primaryInterface, hostSystem.getId(), vmwareState)).equals((Object)datacenterVertex)) {
            this.setParent((VertexRef)hostSystemVertex, (VertexRef)datacenterVertex);
        }
        for (String network : networks) {
            AbstractVertex networkVertex = this.addNetworkVertex(vmwareManagementServer + "/" + network, (String)moIdToName.get(network));
            if (!networkVertex.equals((Object)datacenterVertex)) {
                this.setParent((VertexRef)networkVertex, (VertexRef)datacenterVertex);
            }
            this.connectVertices(vmwareManagementServer + "/" + vmwareManagedObjectId + "->" + network, (VertexRef)hostSystemVertex, (VertexRef)networkVertex);
        }
        for (String datastore : datastores) {
            AbstractVertex datastoreVertex = this.addDatastoreVertex(vmwareManagementServer + "/" + datastore, (String)moIdToName.get(datastore));
            if (!datastoreVertex.equals((Object)datacenterVertex)) {
                this.setParent((VertexRef)datastoreVertex, (VertexRef)datacenterVertex);
            }
            this.connectVertices(vmwareManagementServer + "/" + vmwareManagedObjectId + "->" + datastore, (VertexRef)hostSystemVertex, (VertexRef)datastoreVertex);
        }
    }

    private void addVirtualMachine(OnmsNode virtualMachine) {
        String[] entities;
        String vmwareManagementServer = virtualMachine.getAssetRecord().getVmwareManagementServer().trim();
        String vmwareManagedObjectId = virtualMachine.getAssetRecord().getVmwareManagedObjectId().trim();
        String vmwareTopologyInfo = virtualMachine.getAssetRecord().getVmwareTopologyInfo().trim();
        String vmwareState = virtualMachine.getAssetRecord().getVmwareState().trim();
        String datacenterMoId = null;
        String datacenterName = "Datacenter (" + vmwareManagementServer + ")";
        String vmwareHostSystemId = null;
        ArrayList<String> networks = new ArrayList<String>();
        ArrayList<String> datastores = new ArrayList<String>();
        HashMap<String, String> moIdToName = new HashMap<String, String>();
        for (String entityAndName : entities = vmwareTopologyInfo.split(" *, *")) {
            String entityType;
            String[] splitBySlash = entityAndName.split("/");
            String entityId = splitBySlash[0];
            String entityName = "unknown";
            if (splitBySlash.length > 1) {
                try {
                    entityName = new String(URLDecoder.decode(splitBySlash[1], "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            }
            if ("network".equals(entityType = entityId.split("-")[0])) {
                networks.add(entityId);
            }
            if ("datastore".equals(entityType)) {
                datastores.add(entityId);
            }
            if ("datacenter".equals(entityType)) {
                datacenterMoId = entityId;
            }
            if ("host".equals(entityType)) {
                vmwareHostSystemId = entityId;
            }
            moIdToName.put(entityId, entityName);
        }
        if (datacenterMoId != null) {
            datacenterName = (String)moIdToName.get(datacenterMoId) + " (" + vmwareManagementServer + ")";
        }
        if (vmwareHostSystemId == null) {
            System.err.println("Cannot find host system id for virtual machine " + vmwareManagementServer + "/" + vmwareManagedObjectId);
        }
        AbstractVertex datacenterVertex = this.addDatacenterGroup(vmwareManagementServer, datacenterName);
        String primaryInterface = "unknown";
        OnmsIpInterface ipInterface = this.m_ipInterfaceDao.findPrimaryInterfaceByNodeId(virtualMachine.getId());
        if (ipInterface != null) {
            primaryInterface = ipInterface.getIpHostName();
        }
        AbstractVertex virtualMachineVertex = this.addVirtualMachineVertex(vmwareManagementServer + "/" + vmwareManagedObjectId, virtualMachine.getLabel(), primaryInterface, virtualMachine.getId(), vmwareState);
        if (this.containsVertexId(vmwareManagementServer + "/" + vmwareHostSystemId)) {
            if (!virtualMachineVertex.equals((Object)datacenterVertex)) {
                this.setParent((VertexRef)virtualMachineVertex, (VertexRef)datacenterVertex);
            }
        } else {
            this.addHostSystemVertex(vmwareManagementServer + "/" + vmwareHostSystemId, (String)moIdToName.get(vmwareHostSystemId) + " (not in database)", "", -1, "unknown");
        }
        this.connectVertices(vmwareManagementServer + "/" + vmwareManagedObjectId + "->" + vmwareManagementServer + "/" + vmwareHostSystemId, (VertexRef)virtualMachineVertex, (VertexRef)this.getVertex(this.getVertexNamespace(), vmwareManagementServer + "/" + vmwareHostSystemId));
    }

    public void refresh() {
        this.m_generated = true;
        this.resetContainer();
        List hostSystems = this.m_nodeDao.findAllByVarCharAssetColumn("vmwareManagedEntityType", "HostSystem");
        if (hostSystems.size() == 0) {
            System.err.println("No host systems with defined VMware assets fields found!");
        } else {
            for (OnmsNode hostSystem : hostSystems) {
                this.addHostSystem(hostSystem);
            }
        }
        List virtualMachines = this.m_nodeDao.findAllByVarCharAssetColumn("vmwareManagedEntityType", "VirtualMachine");
        if (virtualMachines.size() == 0) {
            System.err.println("No virtual machines with defined VMware assets fields found!");
        } else {
            for (OnmsNode virtualMachine : virtualMachines) {
                this.addVirtualMachine(virtualMachine);
            }
        }
        this.debugAll();
    }
}

