/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.topo.sfree.internal;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Random;
import org.opennms.features.topology.api.topo.AbstractEdge;
import org.opennms.features.topology.api.topo.AbstractTopologyProvider;
import org.opennms.features.topology.api.topo.Edge;
import org.opennms.features.topology.api.topo.GraphProvider;
import org.opennms.features.topology.api.topo.SimpleConnector;
import org.opennms.features.topology.api.topo.SimpleLeafVertex;
import org.opennms.features.topology.api.topo.Vertex;
import org.opennms.features.topology.api.topo.VertexRef;

public class SFreeTopologyProvider
extends AbstractTopologyProvider
implements GraphProvider {
    private static final String TOPOLOGY_NAMESPACE_SFREE = "sfree";
    public static final String ERDOS_RENIS = "ErdosReniy";
    public static final String BARABASI_ALBERT = "BarabasiAlbert";

    public SFreeTopologyProvider() {
        super(TOPOLOGY_NAMESPACE_SFREE);
    }

    public void save() {
    }

    public void refresh() {
    }

    public void load(String filename) {
        this.clearVertices();
        this.clearEdges();
        if (filename.equals(ERDOS_RENIS)) {
            this.createERRandomTopology(200, 4);
        } else if (filename.equals(BARABASI_ALBERT)) {
            this.createBARandomTopology(200, 4);
        }
    }

    private void createBARandomTopology(Integer numberOfNodes, Integer averageNumberofNeighboors) {
        SimpleLeafVertex vertexi;
        HashMap<Integer, SimpleLeafVertex> nodes = new HashMap<Integer, SimpleLeafVertex>();
        ArrayList<AbstractEdge> edges = new ArrayList<AbstractEdge>();
        for (int i = 0; i < 2 * averageNumberofNeighboors; ++i) {
            System.err.println("Creating First Cluster from: " + i);
            int j = (i + 1) % (2 * averageNumberofNeighboors);
            vertexi = new SimpleLeafVertex(TOPOLOGY_NAMESPACE_SFREE, Integer.toString(i), Integer.valueOf(0), Integer.valueOf(0));
            vertexi.setIconKey("sfree:system");
            vertexi.setLabel("BarabasiAlbertNode" + i);
            if (!nodes.containsKey(i)) {
                nodes.put(i, vertexi);
                System.err.println("Added Node: " + ((SimpleLeafVertex)nodes.get(i)).getId());
            }
            SimpleLeafVertex vertexj = new SimpleLeafVertex(TOPOLOGY_NAMESPACE_SFREE, Integer.toString(j), Integer.valueOf(0), Integer.valueOf(0));
            vertexj.setIconKey("sfree:system");
            vertexj.setLabel("BarabasiAlbertNode" + j);
            if (!nodes.containsKey(j)) {
                nodes.put(j, vertexj);
                System.err.println("Added Node: " + ((SimpleLeafVertex)nodes.get(j)).getId());
            }
            String edgeId = "link:" + i + "-" + j;
            SimpleConnector source = new SimpleConnector(TOPOLOGY_NAMESPACE_SFREE, ((SimpleLeafVertex)nodes.get(i)).getId() + "-" + edgeId + "-connector", (VertexRef)nodes.get(i));
            SimpleConnector target = new SimpleConnector(TOPOLOGY_NAMESPACE_SFREE, ((SimpleLeafVertex)nodes.get(j)).getId() + "-" + edgeId + "-connector", (VertexRef)nodes.get(j));
            edges.add(new AbstractEdge(TOPOLOGY_NAMESPACE_SFREE, edgeId, source, target));
            System.err.println("Added Link: " + edgeId);
        }
        Random r = new Random(new Date().getTime());
        for (int i = 2 * averageNumberofNeighboors; i < numberOfNodes; ++i) {
            vertexi = new SimpleLeafVertex(TOPOLOGY_NAMESPACE_SFREE, Integer.toString(i), Integer.valueOf(0), Integer.valueOf(0));
            vertexi.setIconKey("sfree:system");
            vertexi.setLabel("BarabasiAlbertNode" + i);
            nodes.put(i, vertexi);
            System.err.println("Adding Node: " + i);
            for (int times = 0; times < averageNumberofNeighboors; ++times) {
                double d = r.nextDouble() * (double)nodes.size();
                System.err.println("Generated random position: " + d);
                Long j = (long)d;
                System.err.println("Try Adding edge: " + j.intValue() + "--->" + i);
                String edgeId = "link:" + i + "-" + j.intValue();
                SimpleConnector source = new SimpleConnector(TOPOLOGY_NAMESPACE_SFREE, ((SimpleLeafVertex)nodes.get(i)).getId() + "-" + edgeId + "-connector", (VertexRef)nodes.get(i));
                SimpleConnector target = new SimpleConnector(TOPOLOGY_NAMESPACE_SFREE, ((SimpleLeafVertex)nodes.get(j.intValue())).getId() + "-" + edgeId + "-connector", (VertexRef)nodes.get(j.intValue()));
                AbstractEdge edge = new AbstractEdge(TOPOLOGY_NAMESPACE_SFREE, edgeId, source, target);
                if (i == j.intValue()) continue;
                edges.add(edge);
            }
        }
        this.addVertices(nodes.values().toArray(new Vertex[0]));
        this.addEdges(edges.toArray(new Edge[0]));
    }

    private void createERRandomTopology(Integer numberOfNodes, Integer averageNumberofNeighboors) {
        HashMap<Integer, SimpleLeafVertex> nodes = new HashMap<Integer, SimpleLeafVertex>();
        ArrayList<AbstractEdge> edges = new ArrayList<AbstractEdge>();
        Integer i = 0;
        while (i < numberOfNodes) {
            Object vertex = new SimpleLeafVertex(TOPOLOGY_NAMESPACE_SFREE, Integer.toString(i), Integer.valueOf(0), Integer.valueOf(0));
            vertex.setIconKey("sfree:system");
            vertex.setLabel("ErdosReniyNode" + i);
            nodes.put(i, (SimpleLeafVertex)vertex);
            vertex = i;
            Integer n = i = Integer.valueOf(i + 1);
        }
        Double z = 0.5 * (double)(numberOfNodes - 1);
        Random r = new Random(new Date().getTime());
        Integer start = 0;
        while (start < numberOfNodes) {
            Integer n;
            Integer end = start + 1;
            while (end < numberOfNodes) {
                if (z * r.nextDouble() < (double)averageNumberofNeighboors.intValue()) {
                    String edgeId = "link:" + start + "-" + end;
                    SimpleConnector source = new SimpleConnector(TOPOLOGY_NAMESPACE_SFREE, ((SimpleLeafVertex)nodes.get(start)).getId() + "-" + edgeId + "-connector", (VertexRef)nodes.get(start));
                    SimpleConnector target = new SimpleConnector(TOPOLOGY_NAMESPACE_SFREE, ((SimpleLeafVertex)nodes.get(end)).getId() + "-" + edgeId + "-connector", (VertexRef)nodes.get(end));
                    edges.add(new AbstractEdge(TOPOLOGY_NAMESPACE_SFREE, edgeId, source, target));
                }
                n = end;
                Integer n2 = end = Integer.valueOf(end + 1);
            }
            Integer n3 = start;
            n = start = Integer.valueOf(start + 1);
        }
        this.addVertices(nodes.values().toArray(new Vertex[0]));
        this.addEdges(edges.toArray(new Edge[0]));
    }
}

