/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.topo.linkd.internal;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.opennms.features.topology.api.GraphContainer;
import org.opennms.features.topology.api.OperationContext;
import org.opennms.features.topology.api.support.hops.VertexHopCriteria;
import org.opennms.features.topology.api.topo.AbstractSearchProvider;
import org.opennms.features.topology.api.topo.Criteria;
import org.opennms.features.topology.api.topo.GraphProvider;
import org.opennms.features.topology.api.topo.SearchProvider;
import org.opennms.features.topology.api.topo.SearchQuery;
import org.opennms.features.topology.api.topo.SearchResult;
import org.opennms.features.topology.api.topo.Vertex;
import org.opennms.features.topology.api.topo.VertexRef;
import org.opennms.features.topology.plugins.topo.linkd.internal.LinkdHopCriteria;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinkdSearchProvider
implements SearchProvider {
    private static final Logger LOG = LoggerFactory.getLogger(LinkdSearchProvider.class);
    private final GraphProvider m_delegate;

    public LinkdSearchProvider(GraphProvider delegate) {
        this.m_delegate = delegate;
    }

    public List<SearchResult> query(SearchQuery searchQuery, GraphContainer graphContainer) {
        LOG.debug("SearchProvider->query: called with search query: '{}'", (Object)searchQuery);
        List vertices = this.m_delegate.getCurrentGraph().getVertices(new Criteria[0]);
        ArrayList searchResults = Lists.newArrayList();
        for (Vertex vertex : vertices) {
            if (searchQuery.matches(vertex.getLabel())) {
                searchResults.add(new SearchResult((VertexRef)vertex, false, false));
            }
            if (searchResults.size() <= 50) continue;
            break;
        }
        LOG.debug("SearchProvider->query: found {} search results.", (Object)searchResults.size());
        return searchResults;
    }

    public String getSearchProviderNamespace() {
        return this.m_delegate.getNamespace();
    }

    public void onFocusSearchResult(SearchResult searchResult, OperationContext operationContext) {
    }

    public void onDefocusSearchResult(SearchResult searchResult, OperationContext operationContext) {
    }

    public boolean supportsPrefix(String searchPrefix) {
        return AbstractSearchProvider.supportsPrefix((String)"nodes=", (String)searchPrefix);
    }

    public Set<VertexRef> getVertexRefsBy(SearchResult searchResult, GraphContainer container) {
        LOG.debug("SearchProvider->getVertexRefsBy: called with search result: '{}'", (Object)searchResult);
        Criteria criterion = this.findCriterion(searchResult.getId(), container);
        Set vertices = ((VertexHopCriteria)criterion).getVertices();
        LOG.debug("SearchProvider->getVertexRefsBy: found '{}' vertices.", (Object)vertices.size());
        return vertices;
    }

    public void addVertexHopCriteria(SearchResult searchResult, GraphContainer container) {
        LOG.debug("SearchProvider->addVertexHopCriteria: called with search result: '{}'", (Object)searchResult);
        VertexHopCriteria criterion = LinkdHopCriteria.createCriteria(searchResult.getId(), searchResult.getLabel());
        container.addCriteria((Criteria)criterion);
        LOG.debug("SearchProvider->addVertexHop: adding hop criteria {}.", (Object)criterion);
        this.logCriteriaInContainer(container);
    }

    public void removeVertexHopCriteria(SearchResult searchResult, GraphContainer container) {
        LOG.debug("SearchProvider->removeVertexHopCriteria: called with search result: '{}'", (Object)searchResult);
        Criteria criterion = this.findCriterion(searchResult.getId(), container);
        if (criterion != null) {
            LOG.debug("SearchProvider->removeVertexHopCriteria: found criterion: {} for searchResult {}.", (Object)criterion, (Object)searchResult);
            container.removeCriteria(criterion);
        } else {
            LOG.debug("SearchProvider->removeVertexHopCriteria: did not find criterion for searchResult {}.", (Object)searchResult);
        }
        this.logCriteriaInContainer(container);
    }

    private Criteria findCriterion(String resultId, GraphContainer container) {
        Criteria[] criteria;
        for (Criteria criterion : criteria = container.getCriteria()) {
            String id;
            if (!(criterion instanceof LinkdHopCriteria) || !(id = ((LinkdHopCriteria)criterion).getId()).equals(resultId)) continue;
            return criterion;
        }
        return null;
    }

    private void logCriteriaInContainer(GraphContainer container) {
        Criteria[] criteria = container.getCriteria();
        LOG.debug("SearchProvider->addVertexHopCriteria: there are now {} criteria in the GraphContainer.", (Object)criteria.length);
        for (Criteria crit : criteria) {
            LOG.debug("SearchProvider->addVertexHopCriteria: criterion: '{}' is in the GraphContainer.", (Object)crit);
        }
    }

    public void onCenterSearchResult(SearchResult searchResult, GraphContainer graphContainer) {
        LOG.debug("SearchProvider->onCenterSearchResult: called with search result: '{}'", (Object)searchResult);
    }

    public void onToggleCollapse(SearchResult searchResult, GraphContainer graphContainer) {
        LOG.debug("SearchProvider->onToggleCollapse: called with search result: '{}'", (Object)searchResult);
    }

    public boolean contributesTo(String namespace) {
        return this.m_delegate.getNamespace().equalsIgnoreCase(namespace);
    }
}

