/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.topo.bsm;

import java.util.Set;
import org.opennms.features.topology.plugins.topo.bsm.AbstractBusinessServiceVertex;
import org.opennms.features.topology.plugins.topo.bsm.BusinessServiceVertexVisitor;
import org.opennms.netmgt.bsm.service.model.Application;
import org.opennms.netmgt.bsm.service.model.graph.GraphVertex;

public class ApplicationVertex
extends AbstractBusinessServiceVertex {
    private final Integer applicationId;
    private final Set<String> reductionKeys;

    public ApplicationVertex(Application application, int level) {
        this(application.getId(), application.getApplicationName(), application.getReductionKeys(), level);
    }

    public ApplicationVertex(GraphVertex graphVertex) {
        this(graphVertex.getApplication(), graphVertex.getLevel());
    }

    private ApplicationVertex(int applicationId, String applicationName, Set<String> reductionKeys, int level) {
        super((Object)((Object)AbstractBusinessServiceVertex.Type.Application) + ":" + applicationId, applicationName, level);
        this.applicationId = applicationId;
        this.reductionKeys = reductionKeys;
        this.setTooltipText(String.format("Application '%s'", applicationName));
        this.setIconKey("bsm.application");
    }

    public Integer getApplicationId() {
        return this.applicationId;
    }

    @Override
    public AbstractBusinessServiceVertex.Type getType() {
        return AbstractBusinessServiceVertex.Type.Application;
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    public Set<String> getReductionKeys() {
        return this.reductionKeys;
    }

    @Override
    public <T> T accept(BusinessServiceVertexVisitor<T> visitor) {
        return visitor.visit(this);
    }
}

