/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.topo.onmsdao.internal.operations;

import java.util.List;
import org.opennms.features.topology.api.GraphContainer;
import org.opennms.features.topology.api.Operation;
import org.opennms.features.topology.api.OperationContext;
import org.opennms.features.topology.api.topo.VertexRef;
import org.opennms.features.topology.plugins.topo.onmsdao.internal.OnmsTopologyProvider;
import org.slf4j.LoggerFactory;

public class RemoveVertexOperation
implements Operation {
    OnmsTopologyProvider m_topologyProvider;

    public RemoveVertexOperation(OnmsTopologyProvider topologyProvider) {
        this.m_topologyProvider = topologyProvider;
    }

    public Operation.Undoer execute(List<VertexRef> targets, OperationContext operationContext) {
        GraphContainer graphContainer = operationContext.getGraphContainer();
        if (targets == null) {
            LoggerFactory.getLogger(this.getClass()).debug("need to handle selection!!!");
        } else {
            for (VertexRef target : targets) {
                this.m_topologyProvider.removeVertex(new VertexRef[]{target});
            }
            graphContainer.redoLayout();
        }
        return null;
    }

    public boolean display(List<VertexRef> targets, OperationContext operationContext) {
        return false;
    }

    public boolean enabled(List<VertexRef> targets, OperationContext operationContext) {
        if (targets != null) {
            for (VertexRef target : targets) {
                if (this.m_topologyProvider.containsVertexId(target)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String getId() {
        return null;
    }
}

