/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.topo.onmsdao.internal;

import java.util.ArrayList;
import java.util.List;
import org.opennms.features.topology.api.topo.AbstractTopologyProvider;
import org.opennms.features.topology.api.topo.Edge;
import org.opennms.features.topology.api.topo.GraphProvider;
import org.opennms.features.topology.api.topo.SimpleGroup;
import org.opennms.features.topology.api.topo.SimpleLeafVertex;
import org.opennms.features.topology.api.topo.Vertex;
import org.opennms.features.topology.api.topo.VertexRef;
import org.opennms.netmgt.dao.DataLinkInterfaceDao;
import org.opennms.netmgt.dao.OnmsMapDao;
import org.opennms.netmgt.dao.OnmsMapElementDao;
import org.opennms.netmgt.model.DataLinkInterface;
import org.opennms.netmgt.model.OnmsMap;
import org.opennms.netmgt.model.OnmsMapElement;

public class OnmsTopologyProvider
extends AbstractTopologyProvider
implements GraphProvider {
    private static final String TOPOLOGY_NAMESPACE_ONMSDAO = "onmsdao";
    private OnmsMapDao m_onmsMapDao;
    private OnmsMapElementDao m_onmsMapElementDao;
    private DataLinkInterfaceDao m_dataLinkInterfaceDao;

    public OnmsMapDao getOnmsMapDao() {
        return this.m_onmsMapDao;
    }

    public void setOnmsMapDao(OnmsMapDao onmsMapDao) {
        this.m_onmsMapDao = onmsMapDao;
    }

    public OnmsMapElementDao getOnmsMapElementDao() {
        return this.m_onmsMapElementDao;
    }

    public void setOnmsMapElementDao(OnmsMapElementDao onmsMapElementDao) {
        this.m_onmsMapElementDao = onmsMapElementDao;
    }

    public DataLinkInterfaceDao getDataLinkInterfaceDao() {
        return this.m_dataLinkInterfaceDao;
    }

    public void setDataLinkInterfaceDao(DataLinkInterfaceDao dataLinkInterfaceDao) {
        this.m_dataLinkInterfaceDao = dataLinkInterfaceDao;
    }

    public OnmsTopologyProvider() {
        super(TOPOLOGY_NAMESPACE_ONMSDAO);
    }

    private OnmsMap getMap(int mapId) {
        return this.getOnmsMapDao().findMapById(mapId);
    }

    public void save() {
        this.save("1");
    }

    public void save(String filename) {
        Integer mapid;
        List vertices = super.getVertices();
        int rootMapid = Integer.parseInt(filename);
        OnmsMap rootMap = this.getMap(rootMapid);
        this.getOnmsMapElementDao().deleteElementsByMapId(rootMap);
        for (Vertex vertex : vertices) {
            if (!vertex.isGroup()) continue;
            mapid = ((SimpleGroup)vertex).getMapid();
            this.getOnmsMapElementDao().deleteElementsByMapId(this.getMap(mapid));
        }
        for (Vertex vertex : vertices) {
            String type;
            Integer id;
            if (!vertex.isGroup()) {
                id = ((SimpleLeafVertex)vertex).getNodeID();
                type = "N";
            } else {
                id = ((SimpleGroup)vertex).getMapid();
                type = "M";
            }
            VertexRef parentRef = vertex.getParent();
            Vertex parent = this.getParent(parentRef);
            mapid = parent == null ? Integer.valueOf(rootMapid) : Integer.valueOf(((SimpleGroup)parent).getMapid());
            OnmsMap map = this.getMap(mapid);
            this.getOnmsMapElementDao().save((Object)new OnmsMapElement(map, id.intValue(), type, "Here is the label", vertex.getIconKey(), vertex.getX().intValue(), vertex.getY().intValue()));
        }
    }

    public void refresh() {
    }

    public void load(String filename) {
        OnmsMap map = this.getMap(Integer.parseInt(filename));
        List<Vertex> vertices = this.getVertex(map.getId(), null);
        List<Edge> edges = this.getEdges(vertices);
        this.clearVertices();
        this.addVertices(vertices.toArray(new Vertex[0]));
        this.clearEdges();
        this.addEdges(edges.toArray(new Edge[0]));
    }

    private List<Vertex> getVertex(int mapId, SimpleGroup parent) {
        SimpleLeafVertex vertex;
        ArrayList<Vertex> vertexes = new ArrayList<Vertex>();
        for (OnmsMapElement element : this.getOnmsMapElementDao().findNodeElementsOnMap(mapId)) {
            vertex = new SimpleLeafVertex(this.getVertexNamespace(), Integer.toString(element.getId()), Integer.valueOf(element.getX()), Integer.valueOf(element.getY()));
            vertex.setLocked(false);
            vertex.setSelected(false);
            vertex.setIconKey(element.getIconName());
            if (!vertex.equals((Object)parent)) {
                vertex.setParent((VertexRef)parent);
            }
            vertexes.add((Vertex)vertex);
        }
        for (OnmsMapElement element : this.getOnmsMapElementDao().findMapElementsOnMap(mapId)) {
            vertex = new SimpleGroup(this.getVertexNamespace(), Integer.toString(element.getId()));
            vertex.setLocked(false);
            vertex.setSelected(false);
            vertex.setIconKey(element.getIconName());
            if (!vertex.equals((Object)parent)) {
                vertex.setParent((VertexRef)parent);
            }
            vertexes.add((Vertex)vertex);
            vertexes.addAll(this.getVertex(element.getElementId(), (SimpleGroup)vertex));
        }
        return vertexes;
    }

    private List<Edge> getEdges(List<Vertex> vertexes) {
        ArrayList<Edge> edges = new ArrayList<Edge>();
        ArrayList<SimpleLeafVertex> leafs = new ArrayList<SimpleLeafVertex>();
        for (Vertex vertex : leafs) {
            if (vertex.isGroup()) continue;
            leafs.add((SimpleLeafVertex)vertex);
        }
        for (Vertex vertex : leafs) {
            for (DataLinkInterface link : this.getDataLinkInterfaceDao().findByNodeParentId(((SimpleLeafVertex)vertex).getNodeID())) {
                for (Vertex vertex2 : leafs) {
                    if (link.getNode().getId() != ((SimpleLeafVertex)vertex2).getNodeID()) continue;
                    this.connectVertices(link.getId().toString(), (VertexRef)vertex2, (VertexRef)vertex);
                }
            }
        }
        return edges;
    }
}

