/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.topo.onmsdao.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.opennms.features.topology.api.VertexContainer;
import org.opennms.features.topology.plugins.topo.onmsdao.internal.SimpleGroup;
import org.opennms.features.topology.plugins.topo.onmsdao.internal.SimpleVertex;

public class SimpleVertexContainer
extends VertexContainer<String, SimpleVertex> {
    private static final long serialVersionUID = 1L;

    public SimpleVertexContainer() {
        super(SimpleVertex.class);
        this.setBeanIdProperty("id");
    }

    public void fireLayoutChange() {
        this.fireItemSetChange();
    }

    public boolean areChildrenAllowed(Object itemId) {
        if (!this.containsId(itemId)) {
            return false;
        }
        SimpleVertex v = (SimpleVertex)this.getItem(itemId).getBean();
        return !v.isLeaf();
    }

    public Collection<?> getChildren(Object itemId) {
        if (!this.containsId(itemId)) {
            return Collections.EMPTY_LIST;
        }
        SimpleVertex v = (SimpleVertex)this.getItem(itemId).getBean();
        if (v.isLeaf()) {
            return Collections.EMPTY_LIST;
        }
        SimpleGroup g = (SimpleGroup)v;
        ArrayList<String> memberIds = new ArrayList<String>();
        for (SimpleVertex member : g.getMembers()) {
            memberIds.add(member.getId());
        }
        return memberIds;
    }

    public Object getParent(Object itemId) {
        if (!this.containsId(itemId)) {
            return null;
        }
        SimpleGroup g = ((SimpleVertex)this.getItem(itemId).getBean()).getParent();
        return g == null ? null : g.getId();
    }

    public boolean hasChildren(Object itemId) {
        if (!this.containsId(itemId)) {
            return false;
        }
        SimpleVertex v = (SimpleVertex)this.getItem(itemId).getBean();
        return !v.isLeaf();
    }

    public boolean isRoot(Object itemId) {
        if (!this.containsId(itemId)) {
            return false;
        }
        return this.getParent(itemId) == null;
    }

    public Collection<?> rootItemIds() {
        ArrayList<String> rootItemIds = new ArrayList<String>();
        for (String itemId : this.getItemIds()) {
            if (((SimpleVertex)this.getItem(itemId).getBean()).getParent() != null) continue;
            rootItemIds.add(itemId);
        }
        return rootItemIds;
    }

    public boolean setChildrenAllowed(Object itemId, boolean areChildrenAllowed) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("this operation is not allowed");
    }

    public boolean setParent(Object itemId, Object newParentId) throws UnsupportedOperationException {
        if (!this.containsId(itemId)) {
            return false;
        }
        SimpleVertex v = (SimpleVertex)this.getItem(itemId).getBean();
        if (newParentId == null) {
            v.setParent(null);
            return true;
        }
        if (!this.containsId(newParentId)) {
            return false;
        }
        SimpleVertex p = (SimpleVertex)this.getItem(newParentId).getBean();
        if (p.isLeaf()) {
            return false;
        }
        SimpleGroup g = (SimpleGroup)p;
        v.setParent(g);
        return true;
    }
}

