/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.topo.onmsdao.internal;

import com.vaadin.data.Item;
import com.vaadin.data.Property;
import com.vaadin.data.util.BeanContainer;
import com.vaadin.data.util.BeanItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.opennms.features.topology.api.TopologyProvider;
import org.opennms.features.topology.plugins.topo.onmsdao.internal.SimpleEdge;
import org.opennms.features.topology.plugins.topo.onmsdao.internal.SimpleGroup;
import org.opennms.features.topology.plugins.topo.onmsdao.internal.SimpleLeafVertex;
import org.opennms.features.topology.plugins.topo.onmsdao.internal.SimpleVertex;
import org.opennms.features.topology.plugins.topo.onmsdao.internal.SimpleVertexContainer;
import org.opennms.netmgt.dao.DataLinkInterfaceDao;
import org.opennms.netmgt.dao.OnmsMapDao;
import org.opennms.netmgt.dao.OnmsMapElementDao;
import org.opennms.netmgt.model.DataLinkInterface;
import org.opennms.netmgt.model.OnmsMap;
import org.opennms.netmgt.model.OnmsMapElement;
import org.slf4j.LoggerFactory;

public class OnmsTopologyProvider
implements TopologyProvider {
    private SimpleVertexContainer m_vertexContainer = new SimpleVertexContainer();
    private BeanContainer<String, SimpleEdge> m_edgeContainer = new BeanContainer(SimpleEdge.class);
    private int m_counter = 0;
    private int m_edgeCounter = 0;
    private int m_groupCounter = 0;
    private OnmsMapDao m_onmsMapDao;
    private OnmsMapElementDao m_onmsMapElementDao;
    private DataLinkInterfaceDao m_dataLinkInterfaceDao;

    public OnmsMapDao getOnmsMapDao() {
        return this.m_onmsMapDao;
    }

    public void setOnmsMapDao(OnmsMapDao onmsMapDao) {
        this.m_onmsMapDao = onmsMapDao;
    }

    public OnmsMapElementDao getOnmsMapElementDao() {
        return this.m_onmsMapElementDao;
    }

    public void setOnmsMapElementDao(OnmsMapElementDao onmsMapElementDao) {
        this.m_onmsMapElementDao = onmsMapElementDao;
    }

    public DataLinkInterfaceDao getDataLinkInterfaceDao() {
        return this.m_dataLinkInterfaceDao;
    }

    public void setDataLinkInterfaceDao(DataLinkInterfaceDao dataLinkInterfaceDao) {
        this.m_dataLinkInterfaceDao = dataLinkInterfaceDao;
    }

    public OnmsTopologyProvider() {
        this.m_edgeContainer.setBeanIdProperty((Object)"id");
    }

    public SimpleVertexContainer getVertexContainer() {
        return this.m_vertexContainer;
    }

    public BeanContainer<String, SimpleEdge> getEdgeContainer() {
        return this.m_edgeContainer;
    }

    public Collection<?> getVertexIds() {
        return this.m_vertexContainer.getItemIds();
    }

    public Collection<?> getEdgeIds() {
        return this.m_edgeContainer.getItemIds();
    }

    public Item getVertexItem(Object vertexId) {
        return this.m_vertexContainer.getItem(vertexId);
    }

    public Item getEdgeItem(Object edgeId) {
        return this.m_edgeContainer.getItem(edgeId);
    }

    public Collection<?> getEndPointIdsForEdge(Object edgeId) {
        SimpleEdge edge = this.getRequiredEdge(edgeId);
        ArrayList<String> endPoints = new ArrayList<String>(2);
        endPoints.add(edge.getSource().getId());
        endPoints.add(edge.getTarget().getId());
        return endPoints;
    }

    public Collection<?> getEdgeIdsForVertex(Object vertexId) {
        SimpleVertex vertex = this.getRequiredVertex(vertexId);
        ArrayList<String> edges = new ArrayList<String>(vertex.getEdges().size());
        for (SimpleEdge e : vertex.getEdges()) {
            String edgeId = e.getId();
            edges.add(edgeId);
        }
        return edges;
    }

    private Item addVertex(String id, int x, int y, String icon) {
        if (this.m_vertexContainer.containsId(id)) {
            throw new IllegalArgumentException("A vertex or group with id " + id + " already exists!");
        }
        LoggerFactory.getLogger(this.getClass()).debug("Adding a vertex: {}", (Object)id);
        SimpleLeafVertex vertex = new SimpleLeafVertex(-1, id, x, y);
        vertex.setIcon(icon);
        return this.m_vertexContainer.addBean(vertex);
    }

    private Item addGroup(String groupId, String icon) {
        if (this.m_vertexContainer.containsId(groupId)) {
            throw new IllegalArgumentException("A vertex or group with id " + groupId + " already exists!");
        }
        LoggerFactory.getLogger(this.getClass()).debug("Adding a group: {}", (Object)groupId);
        SimpleGroup vertex = new SimpleGroup(-1, groupId);
        vertex.setIcon(icon);
        return this.m_vertexContainer.addBean(vertex);
    }

    private void connectVertices(String id, Object sourceVertextId, Object targetVertextId) {
        SimpleVertex source = this.getRequiredVertex(sourceVertextId);
        SimpleVertex target = this.getRequiredVertex(targetVertextId);
        SimpleEdge edge = new SimpleEdge(id, source, target);
        this.m_edgeContainer.addBean((Object)edge);
    }

    public void removeVertex(Object vertexId) {
        SimpleVertex vertex = this.getVertex(vertexId, false);
        if (vertex == null) {
            return;
        }
        this.m_vertexContainer.removeItem(vertexId);
        for (SimpleEdge e : vertex.getEdges()) {
            this.m_edgeContainer.removeItem((Object)e.getId());
        }
    }

    private SimpleVertex getRequiredVertex(Object vertexId) {
        return this.getVertex(vertexId, true);
    }

    private SimpleVertex getVertex(Object vertexId, boolean required) {
        BeanItem item = this.m_vertexContainer.getItem(vertexId);
        if (required && item == null) {
            throw new IllegalArgumentException("required vertex " + vertexId + " not found.");
        }
        return item == null ? null : (SimpleVertex)item.getBean();
    }

    private SimpleEdge getRequiredEdge(Object edgeId) {
        return this.getEdge(edgeId, true);
    }

    private SimpleEdge getEdge(Object edgeId, boolean required) {
        BeanItem item = this.m_edgeContainer.getItem(edgeId);
        if (required && item == null) {
            throw new IllegalArgumentException("required edge " + edgeId + " not found.");
        }
        return item == null ? null : (SimpleEdge)item.getBean();
    }

    private OnmsMap getMap(int mapId) {
        return this.getOnmsMapDao().findMapById(mapId);
    }

    public void save(String filename) {
        Integer mapid;
        List vertices = this.getBeans((BeanContainer)this.m_vertexContainer);
        int rootMapid = Integer.parseInt(filename);
        OnmsMap rootMap = this.getMap(rootMapid);
        this.getOnmsMapElementDao().deleteElementsByMapId(rootMap);
        for (SimpleVertex vertex : vertices) {
            if (vertex.isLeaf()) continue;
            mapid = ((SimpleGroup)vertex).getMapid();
            this.getOnmsMapElementDao().deleteElementsByMapId(this.getMap(mapid));
        }
        for (SimpleVertex vertex : vertices) {
            String type;
            Integer id;
            if (vertex.isLeaf()) {
                id = ((SimpleLeafVertex)vertex).getNodeid();
                type = "N";
            } else {
                id = ((SimpleGroup)vertex).getMapid();
                type = "M";
            }
            SimpleGroup parent = vertex.getParent();
            mapid = parent == null ? Integer.valueOf(rootMapid) : Integer.valueOf(parent.getMapid());
            OnmsMap map = this.getMap(mapid);
            this.getOnmsMapElementDao().save((Object)new OnmsMapElement(map, id.intValue(), type, "Here is the label", vertex.getIcon(), vertex.getX(), vertex.getY()));
        }
    }

    public void load(String filename) {
        OnmsMap map = this.getMap(Integer.parseInt(filename));
        List<SimpleVertex> vertices = this.getVertex(map.getId(), null);
        List<SimpleEdge> edges = this.getEdges(vertices);
        this.m_vertexContainer.removeAllItems();
        this.m_vertexContainer.addAll(vertices);
        this.m_edgeContainer.removeAllItems();
        this.m_edgeContainer.addAll(edges);
    }

    private List<SimpleVertex> getVertex(int mapId, SimpleGroup parent) {
        SimpleVertex vertex;
        ArrayList<SimpleVertex> vertexes = new ArrayList<SimpleVertex>();
        for (OnmsMapElement element : this.getOnmsMapElementDao().findNodeElementsOnMap(mapId)) {
            vertex = new SimpleLeafVertex(element.getElementId(), Integer.toString(element.getId()), element.getX(), element.getY());
            vertex.setLocked(false);
            vertex.setSelected(false);
            vertex.setIcon(element.getIconName());
            vertex.setParent(parent);
            vertexes.add(vertex);
        }
        for (OnmsMapElement element : this.getOnmsMapElementDao().findMapElementsOnMap(mapId)) {
            vertex = new SimpleGroup(element.getElementId(), Integer.toString(element.getId()));
            vertex.setLocked(false);
            vertex.setSelected(false);
            vertex.setIcon(element.getIconName());
            vertex.setParent(parent);
            vertexes.add(vertex);
            vertexes.addAll(this.getVertex(element.getElementId(), (SimpleGroup)vertex));
        }
        return vertexes;
    }

    private List<SimpleEdge> getEdges(List<SimpleVertex> vertexes) {
        ArrayList<SimpleEdge> edges = new ArrayList<SimpleEdge>();
        ArrayList<SimpleLeafVertex> leafs = new ArrayList<SimpleLeafVertex>();
        for (SimpleLeafVertex vertex : leafs) {
            if (!((SimpleVertex)vertex).isLeaf()) continue;
            leafs.add(vertex);
        }
        for (SimpleLeafVertex target : leafs) {
            for (DataLinkInterface link : this.getDataLinkInterfaceDao().findByNodeParentId(Integer.valueOf(target.getNodeid()))) {
                for (SimpleLeafVertex source : leafs) {
                    if (link.getNode().getId().intValue() != source.getNodeid()) continue;
                    SimpleEdge edge = new SimpleEdge(link.getId().toString(), source, target);
                    edges.add(edge);
                }
            }
        }
        return edges;
    }

    private <T> List<T> getBeans(BeanContainer<?, T> container) {
        Collection itemIds = container.getItemIds();
        ArrayList<Object> beans = new ArrayList<Object>(itemIds.size());
        for (Object itemId : itemIds) {
            beans.add(container.getItem(itemId).getBean());
        }
        return beans;
    }

    public String getNextVertexId() {
        return "v" + this.m_counter++;
    }

    public String getNextEdgeId() {
        return "e" + this.m_edgeCounter++;
    }

    public String getNextGroupId() {
        return "g" + this.m_groupCounter++;
    }

    public void resetContainer() {
        this.getVertexContainer().removeAllItems();
        this.getEdgeContainer().removeAllItems();
        this.m_counter = 0;
        this.m_edgeCounter = 0;
    }

    public Collection<?> getPropertyIds() {
        return Collections.EMPTY_LIST;
    }

    public Property getProperty(String propertyId) {
        return null;
    }

    public Object addVertex(int nodeid, int x, int y, String icon) {
        LoggerFactory.getLogger(this.getClass()).debug("Adding vertex in {} with icon: {}", (Object)this.getClass().getSimpleName(), (Object)icon);
        String nextVertexId = this.getNextVertexId();
        this.addVertex(nextVertexId, x, y, icon);
        return nextVertexId;
    }

    public void setParent(Object vertexId, Object parentId) {
        this.m_vertexContainer.setParent(vertexId, parentId);
    }

    public Object connectVertices(Object sourceVertextId, Object targetVertextId) {
        String nextEdgeId = this.getNextEdgeId();
        this.connectVertices(nextEdgeId, sourceVertextId, targetVertextId);
        return nextEdgeId;
    }

    public Object addGroup(String groupIcon) {
        String nextGroupId = this.getNextGroupId();
        this.addGroup(nextGroupId, groupIcon);
        return nextGroupId;
    }

    public boolean containsVertexId(Object vertexId) {
        return this.m_vertexContainer.containsId(vertexId);
    }
}

